/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.reflect.opt;

import com.sun.xml.bind.Util;
import com.sun.xml.bind.v2.runtime.reflect.Accessor;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

final class Injector {
    private static final Map<ClassLoader, WeakReference<Injector>> injectors = new WeakHashMap<ClassLoader, WeakReference<Injector>>();
    private static final Logger logger = Util.getClassLogger();
    private final Map<String, Class> classes = new HashMap<String, Class>();
    private final ClassLoader parent;
    private final boolean loadable;
    private static final Method defineClass;
    private static final Method resolveClass;
    private static final Method findLoadedClass;

    static Class inject(ClassLoader cl, String className, byte[] image) {
        Injector injector = Injector.get(cl);
        if (injector != null) {
            return injector.inject(className, image);
        }
        return null;
    }

    static Class find(ClassLoader cl, String className) {
        Injector injector = Injector.get(cl);
        if (injector != null) {
            return injector.find(className);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Injector get(ClassLoader cl) {
        Injector injector = null;
        Map<ClassLoader, WeakReference<Injector>> map3 = injectors;
        synchronized (map3) {
            WeakReference<Injector> wr = injectors.get(cl);
            if (wr != null) {
                injector = (Injector)wr.get();
            }
            if (injector == null) {
                try {
                    injector = new Injector(cl);
                    injectors.put(cl, new WeakReference<Injector>(injector));
                }
                catch (SecurityException e2) {
                    logger.log(Level.FINE, "Unable to set up a back-door for the injector", e2);
                    return null;
                }
            }
            return injector;
        }
    }

    private Injector(ClassLoader parent2) {
        this.parent = parent2;
        assert (parent2 != null);
        boolean loadable = false;
        try {
            loadable = parent2.loadClass(Accessor.class.getName()) == Accessor.class;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.loadable = loadable;
    }

    private synchronized Class inject(String className, byte[] image) {
        Throwable t2;
        if (!this.loadable) {
            return null;
        }
        Class c2 = this.classes.get(className);
        if (c2 == null) {
            try {
                c2 = (Class)findLoadedClass.invoke((Object)this.parent, className.replace('/', '.'));
            }
            catch (IllegalArgumentException e2) {
                logger.log(Level.FINE, "Unable to find " + className, e2);
            }
            catch (IllegalAccessException e3) {
                logger.log(Level.FINE, "Unable to find " + className, e3);
            }
            catch (InvocationTargetException e4) {
                t2 = e4.getTargetException();
                logger.log(Level.FINE, "Unable to find " + className, t2);
            }
            if (c2 != null) {
                this.classes.put(className, c2);
                return c2;
            }
        }
        if (c2 == null) {
            try {
                c2 = (Class)defineClass.invoke((Object)this.parent, className.replace('/', '.'), image, 0, image.length);
                resolveClass.invoke((Object)this.parent, c2);
            }
            catch (IllegalAccessException e5) {
                logger.log(Level.FINE, "Unable to inject " + className, e5);
                return null;
            }
            catch (InvocationTargetException e6) {
                t2 = e6.getTargetException();
                if (t2 instanceof LinkageError) {
                    logger.log(Level.WARNING, "duplicate class definition bug occured? Please report this : " + className, t2);
                } else {
                    logger.log(Level.FINE, "Unable to inject " + className, t2);
                }
                return null;
            }
            catch (SecurityException e7) {
                logger.log(Level.FINE, "Unable to inject " + className, e7);
                return null;
            }
            catch (LinkageError e8) {
                logger.log(Level.FINE, "Unable to inject " + className, e8);
                return null;
            }
            this.classes.put(className, c2);
        }
        return c2;
    }

    private synchronized Class find(String className) {
        return this.classes.get(className);
    }

    static {
        try {
            defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            resolveClass = ClassLoader.class.getDeclaredMethod("resolveClass", Class.class);
            findLoadedClass = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
        }
        catch (NoSuchMethodException e2) {
            throw new NoSuchMethodError(e2.getMessage());
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                defineClass.setAccessible(true);
                resolveClass.setAccessible(true);
                findLoadedClass.setAccessible(true);
                return null;
            }
        });
    }
}

