/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.unmarshaller;

import com.sun.xml.bind.api.AccessorException;
import com.sun.xml.bind.v2.runtime.ClassBeanInfoImpl;
import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.bind.v2.runtime.JaxBeanInfo;
import com.sun.xml.bind.v2.runtime.property.AttributeProperty;
import com.sun.xml.bind.v2.runtime.property.Property;
import com.sun.xml.bind.v2.runtime.property.StructureLoaderBuilder;
import com.sun.xml.bind.v2.runtime.property.UnmarshallerChain;
import com.sun.xml.bind.v2.runtime.reflect.Accessor;
import com.sun.xml.bind.v2.runtime.reflect.TransducedAccessor;
import com.sun.xml.bind.v2.runtime.unmarshaller.ChildLoader;
import com.sun.xml.bind.v2.runtime.unmarshaller.Loader;
import com.sun.xml.bind.v2.runtime.unmarshaller.Messages;
import com.sun.xml.bind.v2.runtime.unmarshaller.TagName;
import com.sun.xml.bind.v2.runtime.unmarshaller.UnmarshallingContext;
import com.sun.xml.bind.v2.util.QNameMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StructureLoader
extends Loader {
    private final QNameMap<ChildLoader> childUnmarshallers = new QNameMap();
    private ChildLoader catchAll;
    private ChildLoader textHandler;
    private QNameMap<TransducedAccessor> attUnmarshallers;
    private Accessor<Object, Map<QName, String>> attCatchAll;
    private final JaxBeanInfo beanInfo;
    private int frameSize;
    private static final QNameMap<TransducedAccessor> EMPTY = new QNameMap();

    public StructureLoader(ClassBeanInfoImpl beanInfo) {
        super(true);
        this.beanInfo = beanInfo;
    }

    public void init(JAXBContextImpl context, ClassBeanInfoImpl beanInfo, Accessor<?, Map<QName, String>> attWildcard) {
        UnmarshallerChain chain2 = new UnmarshallerChain(context);
        ClassBeanInfoImpl bi = beanInfo;
        while (bi != null) {
            block5: for (int i = bi.properties.length - 1; i >= 0; --i) {
                Property p = bi.properties[i];
                switch (p.getKind()) {
                    case ATTRIBUTE: {
                        if (this.attUnmarshallers == null) {
                            this.attUnmarshallers = new QNameMap();
                        }
                        AttributeProperty ap = (AttributeProperty)p;
                        this.attUnmarshallers.put(ap.attName.toQName(), ap.xacc);
                        continue block5;
                    }
                    case ELEMENT: 
                    case REFERENCE: 
                    case MAP: 
                    case VALUE: {
                        p.buildChildElementUnmarshallers(chain2, this.childUnmarshallers);
                    }
                }
            }
            bi = bi.superClazz;
        }
        this.frameSize = chain2.getScopeSize();
        this.textHandler = this.childUnmarshallers.get(StructureLoaderBuilder.TEXT_HANDLER);
        this.catchAll = this.childUnmarshallers.get(StructureLoaderBuilder.CATCH_ALL);
        if (attWildcard != null) {
            this.attCatchAll = attWildcard;
            if (this.attUnmarshallers == null) {
                this.attUnmarshallers = EMPTY;
            }
        } else {
            this.attCatchAll = null;
        }
    }

    @Override
    public void startElement(UnmarshallingContext.State state2, TagName ea) throws SAXException {
        UnmarshallingContext context = state2.getContext();
        assert (!this.beanInfo.isImmutable());
        Object child = context.getInnerPeer();
        if (child != null && this.beanInfo.jaxbType != child.getClass()) {
            child = null;
        }
        if (child != null) {
            this.beanInfo.reset(child, context);
        }
        if (child == null) {
            child = context.createInstance(this.beanInfo);
        }
        context.recordInnerPeer(child);
        state2.target = child;
        this.fireBeforeUnmarshal(this.beanInfo, child, state2);
        context.startScope(this.frameSize);
        if (this.attUnmarshallers != null) {
            Attributes atts = ea.atts;
            for (int i = 0; i < atts.getLength(); ++i) {
                String auri = atts.getURI(i);
                String alocal = atts.getLocalName(i);
                String avalue = atts.getValue(i);
                TransducedAccessor xacc = this.attUnmarshallers.get(auri, alocal);
                try {
                    int idx;
                    if (xacc != null) {
                        xacc.parse(child, avalue);
                        continue;
                    }
                    if (this.attCatchAll == null) continue;
                    String qname = atts.getQName(i);
                    if (atts.getURI(i).equals("http://www.w3.org/2001/XMLSchema-instance")) continue;
                    Object o = state2.target;
                    Map<QName, String> map3 = this.attCatchAll.get(o);
                    if (map3 == null) {
                        if (!this.attCatchAll.valueType.isAssignableFrom(HashMap.class)) {
                            context.handleError(Messages.UNABLE_TO_CREATE_MAP.format(this.attCatchAll.valueType));
                            return;
                        }
                        map3 = new HashMap<QName, String>();
                        this.attCatchAll.set(o, map3);
                    }
                    String prefix2 = (idx = qname.indexOf(58)) < 0 ? "" : qname.substring(0, idx);
                    map3.put(new QName(auri, alocal, prefix2), avalue);
                    continue;
                }
                catch (AccessorException e2) {
                    StructureLoader.handleGenericException(e2, true);
                }
            }
        }
    }

    @Override
    public void childElement(UnmarshallingContext.State state2, TagName arg) throws SAXException {
        ChildLoader child = this.childUnmarshallers.get(arg.uri, arg.local);
        if (child == null && (child = this.catchAll) == null) {
            super.childElement(state2, arg);
            return;
        }
        state2.loader = child.loader;
        state2.receiver = child.receiver;
    }

    @Override
    public Collection<QName> getExpectedChildElements() {
        return this.childUnmarshallers.keySet();
    }

    @Override
    public Collection<QName> getExpectedAttributes() {
        return this.attUnmarshallers.keySet();
    }

    @Override
    public void text(UnmarshallingContext.State state2, CharSequence text2) throws SAXException {
        if (this.textHandler != null) {
            this.textHandler.loader.text(state2, text2);
        }
    }

    @Override
    public void leaveElement(UnmarshallingContext.State state2, TagName ea) throws SAXException {
        state2.getContext().endScope(this.frameSize);
        this.fireAfterUnmarshal(this.beanInfo, state2.target, state2.prev);
    }

    public JaxBeanInfo getBeanInfo() {
        return this.beanInfo;
    }
}

