/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.unmarshaller;

import com.sun.xml.bind.IDResolver;
import com.sun.xml.bind.api.ClassResolver;
import com.sun.xml.bind.unmarshaller.DOMScanner;
import com.sun.xml.bind.unmarshaller.InfosetScanner;
import com.sun.xml.bind.unmarshaller.Messages;
import com.sun.xml.bind.v2.runtime.AssociationMap;
import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.bind.v2.runtime.JaxBeanInfo;
import com.sun.xml.bind.v2.runtime.unmarshaller.DefaultIDResolver;
import com.sun.xml.bind.v2.runtime.unmarshaller.InterningXmlVisitor;
import com.sun.xml.bind.v2.runtime.unmarshaller.MTOMDecorator;
import com.sun.xml.bind.v2.runtime.unmarshaller.SAXConnector;
import com.sun.xml.bind.v2.runtime.unmarshaller.StAXConnector;
import com.sun.xml.bind.v2.runtime.unmarshaller.StAXEventConnector;
import com.sun.xml.bind.v2.runtime.unmarshaller.StAXStreamConnector;
import com.sun.xml.bind.v2.runtime.unmarshaller.UnmarshallingContext;
import com.sun.xml.bind.v2.runtime.unmarshaller.ValidatingUnmarshaller;
import com.sun.xml.bind.v2.runtime.unmarshaller.XmlVisitor;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.bind.helpers.AbstractUnmarshallerImpl;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnmarshallerImpl
extends AbstractUnmarshallerImpl
implements ValidationEventHandler {
    protected final JAXBContextImpl context;
    private Schema schema;
    public final UnmarshallingContext coordinator;
    private Unmarshaller.Listener externalListener;
    private AttachmentUnmarshaller attachmentUnmarshaller;
    private IDResolver idResolver = new DefaultIDResolver();
    private static final DefaultHandler dummyHandler = new DefaultHandler();
    public static final String FACTORY = "com.sun.xml.bind.ObjectFactory";

    public UnmarshallerImpl(JAXBContextImpl context, AssociationMap assoc2) {
        this.context = context;
        this.coordinator = new UnmarshallingContext(this, assoc2);
        try {
            this.setEventHandler(this);
        }
        catch (JAXBException e2) {
            throw new AssertionError((Object)e2);
        }
    }

    public UnmarshallerHandler getUnmarshallerHandler() {
        return this.getUnmarshallerHandler(true, null);
    }

    private SAXConnector getUnmarshallerHandler(boolean intern, JaxBeanInfo expectedType) {
        XmlVisitor h = this.createUnmarshallerHandler(null, false, expectedType);
        if (intern) {
            h = new InterningXmlVisitor(h);
        }
        return new SAXConnector(h, null);
    }

    public final XmlVisitor createUnmarshallerHandler(InfosetScanner scanner, boolean inplace, JaxBeanInfo expectedType) {
        this.coordinator.reset(scanner, inplace, expectedType, this.idResolver);
        XmlVisitor unmarshaller = this.coordinator;
        if (this.schema != null) {
            unmarshaller = new ValidatingUnmarshaller(this.schema, unmarshaller);
        }
        if (this.attachmentUnmarshaller != null && this.attachmentUnmarshaller.isXOPPackage()) {
            unmarshaller = new MTOMDecorator(this, unmarshaller, this.attachmentUnmarshaller);
        }
        return unmarshaller;
    }

    public static boolean needsInterning(XMLReader reader2) {
        try {
            reader2.setFeature("http://xml.org/sax/features/string-interning", true);
        }
        catch (SAXException e2) {
            // empty catch block
        }
        try {
            if (reader2.getFeature("http://xml.org/sax/features/string-interning")) {
                return false;
            }
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return true;
    }

    protected Object unmarshal(XMLReader reader2, InputSource source) throws JAXBException {
        return this.unmarshal0(reader2, source, null);
    }

    protected <T> JAXBElement<T> unmarshal(XMLReader reader2, InputSource source, Class<T> expectedType) throws JAXBException {
        if (expectedType == null) {
            throw new IllegalArgumentException();
        }
        return (JAXBElement)this.unmarshal0(reader2, source, this.getBeanInfo(expectedType));
    }

    private Object unmarshal0(XMLReader reader2, InputSource source, JaxBeanInfo expectedType) throws JAXBException {
        SAXConnector connector = this.getUnmarshallerHandler(UnmarshallerImpl.needsInterning(reader2), expectedType);
        reader2.setContentHandler((ContentHandler)((Object)connector));
        reader2.setErrorHandler(this.coordinator);
        try {
            reader2.parse(source);
        }
        catch (IOException e2) {
            throw new UnmarshalException((Throwable)e2);
        }
        catch (SAXException e3) {
            throw this.createUnmarshalException(e3);
        }
        Object result2 = connector.getResult();
        reader2.setContentHandler(dummyHandler);
        reader2.setErrorHandler(dummyHandler);
        return result2;
    }

    public <T> JAXBElement<T> unmarshal(Source source, Class<T> expectedType) throws JAXBException {
        if (source instanceof SAXSource) {
            SAXSource ss = (SAXSource)source;
            XMLReader reader2 = ss.getXMLReader();
            if (reader2 == null) {
                reader2 = this.getXMLReader();
            }
            return this.unmarshal(reader2, ss.getInputSource(), expectedType);
        }
        if (source instanceof StreamSource) {
            return this.unmarshal(this.getXMLReader(), UnmarshallerImpl.streamSourceToInputSource((StreamSource)source), expectedType);
        }
        if (source instanceof DOMSource) {
            return this.unmarshal(((DOMSource)source).getNode(), expectedType);
        }
        throw new IllegalArgumentException();
    }

    public Object unmarshal0(Source source, JaxBeanInfo expectedType) throws JAXBException {
        if (source instanceof SAXSource) {
            SAXSource ss = (SAXSource)source;
            XMLReader reader2 = ss.getXMLReader();
            if (reader2 == null) {
                reader2 = this.getXMLReader();
            }
            return this.unmarshal0(reader2, ss.getInputSource(), expectedType);
        }
        if (source instanceof StreamSource) {
            return this.unmarshal0(this.getXMLReader(), UnmarshallerImpl.streamSourceToInputSource((StreamSource)source), expectedType);
        }
        if (source instanceof DOMSource) {
            return this.unmarshal0(((DOMSource)source).getNode(), expectedType);
        }
        throw new IllegalArgumentException();
    }

    public final ValidationEventHandler getEventHandler() {
        try {
            return super.getEventHandler();
        }
        catch (JAXBException e2) {
            throw new AssertionError();
        }
    }

    public final boolean hasEventHandler() {
        return this.getEventHandler() != this;
    }

    public <T> JAXBElement<T> unmarshal(Node node4, Class<T> expectedType) throws JAXBException {
        if (expectedType == null) {
            throw new IllegalArgumentException();
        }
        return (JAXBElement)this.unmarshal0(node4, this.getBeanInfo(expectedType));
    }

    public final Object unmarshal(Node node4) throws JAXBException {
        return this.unmarshal0(node4, null);
    }

    @Deprecated
    public final Object unmarshal(SAXSource source) throws JAXBException {
        return super.unmarshal((Source)source);
    }

    public final Object unmarshal0(Node node4, JaxBeanInfo expectedType) throws JAXBException {
        try {
            DOMScanner scanner = new DOMScanner();
            InterningXmlVisitor handler = new InterningXmlVisitor(this.createUnmarshallerHandler(null, false, expectedType));
            scanner.setContentHandler((ContentHandler)((Object)new SAXConnector(handler, scanner)));
            if (node4 instanceof Element) {
                scanner.scan((Element)node4);
            } else if (node4 instanceof Document) {
                scanner.scan((Document)node4);
            } else {
                throw new IllegalArgumentException("Unexpected node type: " + node4);
            }
            Object retVal = handler.getContext().getResult();
            handler.getContext().clearResult();
            return retVal;
        }
        catch (SAXException e2) {
            throw this.createUnmarshalException(e2);
        }
    }

    public Object unmarshal(XMLStreamReader reader2) throws JAXBException {
        return this.unmarshal0(reader2, null);
    }

    public <T> JAXBElement<T> unmarshal(XMLStreamReader reader2, Class<T> expectedType) throws JAXBException {
        if (expectedType == null) {
            throw new IllegalArgumentException();
        }
        return (JAXBElement)this.unmarshal0(reader2, this.getBeanInfo(expectedType));
    }

    public Object unmarshal0(XMLStreamReader reader2, JaxBeanInfo expectedType) throws JAXBException {
        if (reader2 == null) {
            throw new IllegalArgumentException(Messages.format("Unmarshaller.NullReader"));
        }
        int eventType = reader2.getEventType();
        if (eventType != 1 && eventType != 7) {
            throw new IllegalStateException(Messages.format("Unmarshaller.IllegalReaderState", eventType));
        }
        XmlVisitor h = this.createUnmarshallerHandler(null, false, expectedType);
        StAXConnector connector = StAXStreamConnector.create(reader2, h);
        try {
            connector.bridge();
        }
        catch (XMLStreamException e2) {
            throw UnmarshallerImpl.handleStreamException(e2);
        }
        Object retVal = h.getContext().getResult();
        h.getContext().clearResult();
        return retVal;
    }

    public <T> JAXBElement<T> unmarshal(XMLEventReader reader2, Class<T> expectedType) throws JAXBException {
        if (expectedType == null) {
            throw new IllegalArgumentException();
        }
        return (JAXBElement)this.unmarshal0(reader2, this.getBeanInfo(expectedType));
    }

    public Object unmarshal(XMLEventReader reader2) throws JAXBException {
        return this.unmarshal0(reader2, null);
    }

    private Object unmarshal0(XMLEventReader reader2, JaxBeanInfo expectedType) throws JAXBException {
        if (reader2 == null) {
            throw new IllegalArgumentException(Messages.format("Unmarshaller.NullReader"));
        }
        try {
            XMLEvent event = reader2.peek();
            if (!event.isStartElement() && !event.isStartDocument()) {
                throw new IllegalStateException(Messages.format("Unmarshaller.IllegalReaderState", event.getEventType()));
            }
            boolean isZephyr = reader2.getClass().getName().equals("com.sun.xml.stream.XMLReaderImpl");
            XmlVisitor h = this.createUnmarshallerHandler(null, false, expectedType);
            if (!isZephyr) {
                h = new InterningXmlVisitor(h);
            }
            new StAXEventConnector(reader2, h).bridge();
            return h.getContext().getResult();
        }
        catch (XMLStreamException e2) {
            throw UnmarshallerImpl.handleStreamException(e2);
        }
    }

    public Object unmarshal0(InputStream input2, JaxBeanInfo expectedType) throws JAXBException {
        return this.unmarshal0(this.getXMLReader(), new InputSource(input2), expectedType);
    }

    private static JAXBException handleStreamException(XMLStreamException e2) {
        Throwable ne = e2.getNestedException();
        if (ne instanceof JAXBException) {
            return (JAXBException)ne;
        }
        if (ne instanceof SAXException) {
            return new UnmarshalException(ne);
        }
        return new UnmarshalException((Throwable)e2);
    }

    public Object getProperty(String name) throws PropertyException {
        if (name.equals(IDResolver.class.getName())) {
            return this.idResolver;
        }
        return super.getProperty(name);
    }

    public void setProperty(String name, Object value2) throws PropertyException {
        if (name.equals(FACTORY)) {
            this.coordinator.setFactories(value2);
            return;
        }
        if (name.equals(IDResolver.class.getName())) {
            this.idResolver = (IDResolver)value2;
            return;
        }
        if (name.equals(ClassResolver.class.getName())) {
            this.coordinator.classResolver = (ClassResolver)value2;
            return;
        }
        if (name.equals(ClassLoader.class.getName())) {
            this.coordinator.classLoader = (ClassLoader)value2;
            return;
        }
        super.setProperty(name, value2);
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public AttachmentUnmarshaller getAttachmentUnmarshaller() {
        return this.attachmentUnmarshaller;
    }

    public void setAttachmentUnmarshaller(AttachmentUnmarshaller au) {
        this.attachmentUnmarshaller = au;
    }

    public boolean isValidating() {
        throw new UnsupportedOperationException();
    }

    public void setValidating(boolean validating) {
        throw new UnsupportedOperationException();
    }

    public <A extends XmlAdapter> void setAdapter(Class<A> type, A adapter) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.coordinator.putAdapter(type, adapter);
    }

    public <A extends XmlAdapter> A getAdapter(Class<A> type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (this.coordinator.containsAdapter(type)) {
            return this.coordinator.getAdapter(type);
        }
        return null;
    }

    public UnmarshalException createUnmarshalException(SAXException e2) {
        return super.createUnmarshalException(e2);
    }

    public boolean handleEvent(ValidationEvent event) {
        return event.getSeverity() != 2;
    }

    private static InputSource streamSourceToInputSource(StreamSource ss) {
        InputSource is2 = new InputSource();
        is2.setSystemId(ss.getSystemId());
        is2.setByteStream(ss.getInputStream());
        is2.setCharacterStream(ss.getReader());
        return is2;
    }

    public <T> JaxBeanInfo<T> getBeanInfo(Class<T> clazz2) throws JAXBException {
        return this.context.getBeanInfo(clazz2, true);
    }

    public Unmarshaller.Listener getListener() {
        return this.externalListener;
    }

    public void setListener(Unmarshaller.Listener listener) {
        this.externalListener = listener;
    }

    public UnmarshallingContext getContext() {
        return this.coordinator;
    }
}

