/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.unmarshaller;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.istack.SAXParseException2;
import com.sun.xml.bind.IDResolver;
import com.sun.xml.bind.api.AccessorException;
import com.sun.xml.bind.api.ClassResolver;
import com.sun.xml.bind.unmarshaller.InfosetScanner;
import com.sun.xml.bind.v2.ClassFactory;
import com.sun.xml.bind.v2.runtime.AssociationMap;
import com.sun.xml.bind.v2.runtime.Coordinator;
import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.bind.v2.runtime.JaxBeanInfo;
import com.sun.xml.bind.v2.runtime.unmarshaller.Intercepter;
import com.sun.xml.bind.v2.runtime.unmarshaller.Loader;
import com.sun.xml.bind.v2.runtime.unmarshaller.LocatorEx;
import com.sun.xml.bind.v2.runtime.unmarshaller.LocatorExWrapper;
import com.sun.xml.bind.v2.runtime.unmarshaller.Messages;
import com.sun.xml.bind.v2.runtime.unmarshaller.Patcher;
import com.sun.xml.bind.v2.runtime.unmarshaller.Receiver;
import com.sun.xml.bind.v2.runtime.unmarshaller.Scope;
import com.sun.xml.bind.v2.runtime.unmarshaller.StructureLoader;
import com.sun.xml.bind.v2.runtime.unmarshaller.TagName;
import com.sun.xml.bind.v2.runtime.unmarshaller.UnmarshallerImpl;
import com.sun.xml.bind.v2.runtime.unmarshaller.XmlVisitor;
import com.sun.xml.bind.v2.runtime.unmarshaller.XsiNilLoader;
import com.sun.xml.bind.v2.runtime.unmarshaller.XsiTypeLoader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.helpers.ValidationEventImpl;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.LocatorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnmarshallingContext
extends Coordinator
implements NamespaceContext,
ValidationEventHandler,
ErrorHandler,
XmlVisitor,
XmlVisitor.TextPredictor {
    private final State root;
    private State current;
    private static final LocatorEx DUMMY_INSTANCE;
    @NotNull
    private LocatorEx locator = DUMMY_INSTANCE;
    private Object result;
    private JaxBeanInfo expectedType;
    private IDResolver idResolver;
    private boolean isUnmarshalInProgress = true;
    private boolean aborted = false;
    public final UnmarshallerImpl parent;
    private final AssociationMap assoc;
    private boolean isInplaceMode;
    private InfosetScanner scanner;
    private Object currentElement;
    private NamespaceContext environmentNamespaceContext;
    @Nullable
    public ClassResolver classResolver;
    @Nullable
    public ClassLoader classLoader;
    private final Map<Class, Factory> factories = new HashMap<Class, Factory>();
    private Patcher[] patchers = null;
    private int patchersLen = 0;
    private String[] nsBind = new String[16];
    private int nsLen = 0;
    private Scope[] scopes = new Scope[16];
    private int scopeTop = 0;
    private static final Loader DEFAULT_ROOT_LOADER;
    private static final Loader EXPECTED_TYPE_ROOT_LOADER;

    public UnmarshallingContext(UnmarshallerImpl _parent, AssociationMap assoc2) {
        for (int i = 0; i < this.scopes.length; ++i) {
            this.scopes[i] = new Scope(this);
        }
        this.parent = _parent;
        this.assoc = assoc2;
        this.root = this.current = new State(null);
        this.allocateMoreStates();
    }

    public void reset(InfosetScanner scanner, boolean isInplaceMode, JaxBeanInfo expectedType, IDResolver idResolver) {
        this.scanner = scanner;
        this.isInplaceMode = isInplaceMode;
        this.expectedType = expectedType;
        this.idResolver = idResolver;
    }

    public JAXBContextImpl getJAXBContext() {
        return this.parent.context;
    }

    public State getCurrentState() {
        return this.current;
    }

    public Loader selectRootLoader(State state2, TagName tag2) throws SAXException {
        try {
            Class<?> clazz2;
            Loader l = this.getJAXBContext().selectRootLoader(state2, tag2);
            if (l != null) {
                return l;
            }
            if (this.classResolver != null && (clazz2 = this.classResolver.resolveElementName(tag2.uri, tag2.local)) != null) {
                JAXBContextImpl enhanced = this.getJAXBContext().createAugmented(clazz2);
                JaxBeanInfo<?> bi = enhanced.getBeanInfo(clazz2);
                return bi.getLoader(enhanced, true);
            }
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            this.handleError(e3);
        }
        return null;
    }

    private void allocateMoreStates() {
        assert (this.current.next == null);
        State s2 = this.current;
        for (int i = 0; i < 8; ++i) {
            s2 = new State(s2);
        }
    }

    public void setFactories(Object factoryInstances) {
        this.factories.clear();
        if (factoryInstances == null) {
            return;
        }
        if (factoryInstances instanceof Object[]) {
            for (Object factory : (Object[])factoryInstances) {
                this.addFactory(factory);
            }
        } else {
            this.addFactory(factoryInstances);
        }
    }

    private void addFactory(Object factory) {
        for (Method m : factory.getClass().getMethods()) {
            if (!m.getName().startsWith("create") || m.getParameterTypes().length > 0) continue;
            Class<?> type = m.getReturnType();
            this.factories.put(type, new Factory(factory, m));
        }
    }

    @Override
    public void startDocument(LocatorEx locator, NamespaceContext nsContext) throws SAXException {
        if (locator != null) {
            this.locator = locator;
        }
        this.environmentNamespaceContext = nsContext;
        this.result = null;
        this.current = this.root;
        this.patchersLen = 0;
        this.aborted = false;
        this.isUnmarshalInProgress = true;
        this.nsLen = 0;
        this.setThreadAffinity();
        this.root.loader = this.expectedType != null ? EXPECTED_TYPE_ROOT_LOADER : DEFAULT_ROOT_LOADER;
        this.idResolver.startDocument(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startElement(TagName tagName) throws SAXException {
        this.pushCoordinator();
        try {
            this._startElement(tagName);
        }
        finally {
            this.popCoordinator();
        }
    }

    private void _startElement(TagName tagName) throws SAXException {
        if (this.assoc != null) {
            this.currentElement = this.scanner.getCurrentElement();
        }
        Loader h = this.current.loader;
        this.current.push();
        h.childElement(this.current, tagName);
        assert (this.current.loader != null);
        this.current.loader.startElement(this.current, tagName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void text(CharSequence pcdata) throws SAXException {
        State cur = this.current;
        this.pushCoordinator();
        try {
            if (cur.elementDefaultValue != null && pcdata.length() == 0) {
                pcdata = cur.elementDefaultValue;
            }
            cur.loader.text(cur, pcdata);
        }
        finally {
            this.popCoordinator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void endElement(TagName tagName) throws SAXException {
        this.pushCoordinator();
        try {
            State child = this.current;
            child.loader.leaveElement(child, tagName);
            Object target2 = child.target;
            Receiver recv = child.receiver;
            Intercepter intercepter = child.intercepter;
            child.pop();
            if (intercepter != null) {
                target2 = intercepter.intercept(this.current, target2);
            }
            if (recv != null) {
                recv.receive(this.current, target2);
            }
        }
        finally {
            this.popCoordinator();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.runPatchers();
        this.idResolver.endDocument();
        this.isUnmarshalInProgress = false;
        this.currentElement = null;
        this.locator = DUMMY_INSTANCE;
        this.environmentNamespaceContext = null;
        assert (this.root == this.current);
        this.resetThreadAffinity();
    }

    @Override
    @Deprecated
    public boolean expectText() {
        return this.current.loader.expectText;
    }

    @Override
    @Deprecated
    public XmlVisitor.TextPredictor getPredictor() {
        return this;
    }

    @Override
    public UnmarshallingContext getContext() {
        return this;
    }

    public Object getResult() throws UnmarshalException {
        if (this.isUnmarshalInProgress) {
            throw new IllegalStateException();
        }
        if (!this.aborted) {
            return this.result;
        }
        throw new UnmarshalException((String)null);
    }

    void clearResult() {
        if (this.isUnmarshalInProgress) {
            throw new IllegalStateException();
        }
        this.result = null;
    }

    public Object createInstance(Class<?> clazz2) throws SAXException {
        Factory factory;
        if (!this.factories.isEmpty() && (factory = this.factories.get(clazz2)) != null) {
            return factory.createInstance();
        }
        return ClassFactory.create(clazz2);
    }

    public Object createInstance(JaxBeanInfo beanInfo) throws SAXException {
        Factory factory;
        if (!this.factories.isEmpty() && (factory = this.factories.get(beanInfo.jaxbType)) != null) {
            return factory.createInstance();
        }
        try {
            return beanInfo.createInstance(this);
        }
        catch (IllegalAccessException e2) {
            Loader.reportError("Unable to create an instance of " + beanInfo.jaxbType.getName(), e2, false);
        }
        catch (InvocationTargetException e3) {
            Loader.reportError("Unable to create an instance of " + beanInfo.jaxbType.getName(), e3, false);
        }
        catch (InstantiationException e4) {
            Loader.reportError("Unable to create an instance of " + beanInfo.jaxbType.getName(), e4, false);
        }
        return null;
    }

    public void handleEvent(ValidationEvent event, boolean canRecover) throws SAXException {
        ValidationEventHandler eventHandler = this.parent.getEventHandler();
        boolean recover2 = eventHandler.handleEvent(event);
        if (!recover2) {
            this.aborted = true;
        }
        if (!canRecover || !recover2) {
            throw new SAXParseException2(event.getMessage(), this.locator, (Exception)new UnmarshalException(event.getMessage(), event.getLinkedException()));
        }
    }

    public boolean handleEvent(ValidationEvent event) {
        try {
            boolean recover2 = this.parent.getEventHandler().handleEvent(event);
            if (!recover2) {
                this.aborted = true;
            }
            return recover2;
        }
        catch (RuntimeException re) {
            return false;
        }
    }

    public void handleError(Exception e2) throws SAXException {
        this.handleError(e2, true);
    }

    public void handleError(Exception e2, boolean canRecover) throws SAXException {
        this.handleEvent((ValidationEvent)new ValidationEventImpl(1, e2.getMessage(), this.locator.getLocation(), (Throwable)e2), canRecover);
    }

    public void handleError(String msg) {
        this.handleEvent((ValidationEvent)new ValidationEventImpl(1, msg, this.locator.getLocation()));
    }

    @Override
    protected ValidationEventLocator getLocation() {
        return this.locator.getLocation();
    }

    public LocatorEx getLocator() {
        return this.locator;
    }

    public void errorUnresolvedIDREF(Object bean, String idref, LocatorEx loc) throws SAXException {
        this.handleEvent((ValidationEvent)new ValidationEventImpl(1, Messages.UNRESOLVED_IDREF.format(idref), loc.getLocation()), true);
    }

    public void addPatcher(Patcher job) {
        if (this.patchers == null) {
            this.patchers = new Patcher[32];
        }
        if (this.patchers.length == this.patchersLen) {
            Patcher[] buf = new Patcher[this.patchersLen * 2];
            System.arraycopy(this.patchers, 0, buf, 0, this.patchersLen);
            this.patchers = buf;
        }
        this.patchers[this.patchersLen++] = job;
    }

    private void runPatchers() throws SAXException {
        if (this.patchers != null) {
            for (int i = 0; i < this.patchersLen; ++i) {
                this.patchers[i].run();
                this.patchers[i] = null;
            }
        }
    }

    public String addToIdTable(String id2) throws SAXException {
        Object o = this.current.target;
        if (o == null) {
            o = this.current.prev.target;
        }
        this.idResolver.bind(id2, o);
        return id2;
    }

    public Callable getObjectFromId(String id2, Class targetType) throws SAXException {
        return this.idResolver.resolve(id2, targetType);
    }

    @Override
    public void startPrefixMapping(String prefix2, String uri) {
        if (this.nsBind.length == this.nsLen) {
            String[] n = new String[this.nsLen * 2];
            System.arraycopy(this.nsBind, 0, n, 0, this.nsLen);
            this.nsBind = n;
        }
        this.nsBind[this.nsLen++] = prefix2;
        this.nsBind[this.nsLen++] = uri;
    }

    @Override
    public void endPrefixMapping(String prefix2) {
        this.nsLen -= 2;
    }

    private String resolveNamespacePrefix(String prefix2) {
        if (prefix2.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        for (int i = this.nsLen - 2; i >= 0; i -= 2) {
            if (!prefix2.equals(this.nsBind[i])) continue;
            return this.nsBind[i + 1];
        }
        if (this.environmentNamespaceContext != null) {
            return this.environmentNamespaceContext.getNamespaceURI(prefix2.intern());
        }
        if (prefix2.equals("")) {
            return "";
        }
        return null;
    }

    public String[] getNewlyDeclaredPrefixes() {
        return this.getPrefixList(this.current.prev.numNsDecl);
    }

    public String[] getAllDeclaredPrefixes() {
        return this.getPrefixList(0);
    }

    private String[] getPrefixList(int startIndex) {
        int size2 = (this.current.numNsDecl - startIndex) / 2;
        String[] r = new String[size2];
        for (int i = 0; i < r.length; ++i) {
            r[i] = this.nsBind[startIndex + i * 2];
        }
        return r;
    }

    @Override
    public Iterator<String> getPrefixes(String uri) {
        return Collections.unmodifiableList(this.getAllPrefixesInList(uri)).iterator();
    }

    private List<String> getAllPrefixesInList(String uri) {
        ArrayList<String> a2 = new ArrayList<String>();
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            a2.add("xml");
            return a2;
        }
        if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            a2.add("xmlns");
            return a2;
        }
        for (int i = this.nsLen - 2; i >= 0; i -= 2) {
            if (!uri.equals(this.nsBind[i + 1]) || !this.getNamespaceURI(this.nsBind[i]).equals(this.nsBind[i + 1])) continue;
            a2.add(this.nsBind[i]);
        }
        return a2;
    }

    @Override
    public String getPrefix(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        for (int i = this.nsLen - 2; i >= 0; i -= 2) {
            if (!uri.equals(this.nsBind[i + 1]) || !this.getNamespaceURI(this.nsBind[i]).equals(this.nsBind[i + 1])) continue;
            return this.nsBind[i];
        }
        if (this.environmentNamespaceContext != null) {
            return this.environmentNamespaceContext.getPrefix(uri);
        }
        return null;
    }

    @Override
    public String getNamespaceURI(String prefix2) {
        if (prefix2 == null) {
            throw new IllegalArgumentException();
        }
        if (prefix2.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        return this.resolveNamespacePrefix(prefix2);
    }

    public void startScope(int frameSize) {
        this.scopeTop += frameSize;
        if (this.scopeTop >= this.scopes.length) {
            Scope[] s2 = new Scope[Math.max(this.scopeTop + 1, this.scopes.length * 2)];
            System.arraycopy(this.scopes, 0, s2, 0, this.scopes.length);
            for (int i = this.scopes.length; i < s2.length; ++i) {
                s2[i] = new Scope(this);
            }
            this.scopes = s2;
        }
    }

    public void endScope(int frameSize) throws SAXException {
        try {
            while (frameSize > 0) {
                this.scopes[this.scopeTop].finish();
                --frameSize;
                --this.scopeTop;
            }
        }
        catch (AccessorException e2) {
            this.handleError(e2);
            while (frameSize > 0) {
                this.scopes[this.scopeTop--] = new Scope(this);
                --frameSize;
            }
        }
    }

    public Scope getScope(int offset2) {
        return this.scopes[this.scopeTop - offset2];
    }

    public void recordInnerPeer(Object innerPeer) {
        if (this.assoc != null) {
            this.assoc.addInner(this.currentElement, innerPeer);
        }
    }

    public Object getInnerPeer() {
        if (this.assoc != null && this.isInplaceMode) {
            return this.assoc.getInnerPeer(this.currentElement);
        }
        return null;
    }

    public void recordOuterPeer(Object outerPeer) {
        if (this.assoc != null) {
            this.assoc.addOuter(this.currentElement, outerPeer);
        }
    }

    public Object getOuterPeer() {
        if (this.assoc != null && this.isInplaceMode) {
            return this.assoc.getOuterPeer(this.currentElement);
        }
        return null;
    }

    public String getXMIMEContentType() {
        Object t2 = this.current.target;
        if (t2 == null) {
            return null;
        }
        return this.getJAXBContext().getXMIMEContentType(t2);
    }

    public static UnmarshallingContext getInstance() {
        return (UnmarshallingContext)Coordinator._getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<QName> getCurrentExpectedElements() {
        this.pushCoordinator();
        try {
            State s2 = this.getCurrentState();
            Loader l = s2.loader;
            Collection<QName> collection = l != null ? l.getExpectedChildElements() : null;
            return collection;
        }
        finally {
            this.popCoordinator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<QName> getCurrentExpectedAttributes() {
        this.pushCoordinator();
        try {
            State s2 = this.getCurrentState();
            Loader l = s2.loader;
            Collection<QName> collection = l != null ? l.getExpectedAttributes() : null;
            return collection;
        }
        finally {
            this.popCoordinator();
        }
    }

    public StructureLoader getStructureLoader() {
        if (this.current.loader instanceof StructureLoader) {
            return (StructureLoader)this.current.loader;
        }
        return null;
    }

    static {
        LocatorImpl loc = new LocatorImpl();
        loc.setPublicId(null);
        loc.setSystemId(null);
        loc.setLineNumber(-1);
        loc.setColumnNumber(-1);
        DUMMY_INSTANCE = new LocatorExWrapper(loc);
        DEFAULT_ROOT_LOADER = new DefaultRootLoader();
        EXPECTED_TYPE_ROOT_LOADER = new ExpectedTypeRootLoader();
    }

    private static final class ExpectedTypeRootLoader
    extends Loader
    implements Receiver {
        private ExpectedTypeRootLoader() {
        }

        public void childElement(State state2, TagName ea) {
            UnmarshallingContext context = state2.getContext();
            QName qn = new QName(ea.uri, ea.local);
            state2.prev.target = new JAXBElement(qn, ((UnmarshallingContext)context).expectedType.jaxbType, null, null);
            state2.receiver = this;
            state2.loader = new XsiNilLoader(context.expectedType.getLoader(null, true));
        }

        public void receive(State state2, Object o) {
            JAXBElement e2 = (JAXBElement)state2.target;
            e2.setValue(o);
            state2.getContext().recordOuterPeer(e2);
            state2.getContext().result = e2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultRootLoader
    extends Loader
    implements Receiver {
        private DefaultRootLoader() {
        }

        @Override
        public void childElement(State state2, TagName ea) throws SAXException {
            Loader loader = state2.getContext().selectRootLoader(state2, ea);
            if (loader != null) {
                state2.loader = loader;
                state2.receiver = this;
                return;
            }
            JaxBeanInfo beanInfo = XsiTypeLoader.parseXsiType(state2, ea, null);
            if (beanInfo == null) {
                this.reportUnexpectedChildElement(ea, false);
                return;
            }
            state2.loader = beanInfo.getLoader(null, false);
            state2.prev.backup = new JAXBElement(ea.createQName(), Object.class, null);
            state2.receiver = this;
        }

        @Override
        public Collection<QName> getExpectedChildElements() {
            return UnmarshallingContext.getInstance().getJAXBContext().getValidRootNames();
        }

        @Override
        public void receive(State state2, Object o) {
            if (state2.backup != null) {
                ((JAXBElement)state2.backup).setValue(o);
                o = state2.backup;
            }
            if (state2.nil) {
                ((JAXBElement)o).setNil(true);
            }
            state2.getContext().result = o;
        }
    }

    private static class Factory {
        private final Object factorInstance;
        private final Method method;

        public Factory(Object factorInstance, Method method) {
            this.factorInstance = factorInstance;
            this.method = method;
        }

        public Object createInstance() throws SAXException {
            try {
                return this.method.invoke(this.factorInstance, new Object[0]);
            }
            catch (IllegalAccessException e2) {
                UnmarshallingContext.getInstance().handleError(e2, false);
            }
            catch (InvocationTargetException e3) {
                UnmarshallingContext.getInstance().handleError(e3, false);
            }
            return null;
        }
    }

    public final class State {
        public Loader loader;
        public Receiver receiver;
        public Intercepter intercepter;
        public Object target;
        public Object backup;
        private int numNsDecl;
        public String elementDefaultValue;
        public final State prev;
        private State next;
        public boolean nil = false;

        public UnmarshallingContext getContext() {
            return UnmarshallingContext.this;
        }

        private State(State prev) {
            this.prev = prev;
            if (prev != null) {
                prev.next = this;
            }
        }

        private void push() {
            if (this.next == null) {
                UnmarshallingContext.this.allocateMoreStates();
            }
            State n = this.next;
            n.numNsDecl = UnmarshallingContext.this.nsLen;
            UnmarshallingContext.this.current = n;
        }

        private void pop() {
            assert (this.prev != null);
            this.loader = null;
            this.receiver = null;
            this.intercepter = null;
            this.elementDefaultValue = null;
            this.target = null;
            UnmarshallingContext.this.current = this.prev;
        }
    }
}

