/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.unmarshaller;

import com.sun.xml.bind.v2.runtime.unmarshaller.LocatorEx;
import com.sun.xml.bind.v2.runtime.unmarshaller.TagName;
import com.sun.xml.bind.v2.runtime.unmarshaller.UnmarshallingContext;
import com.sun.xml.bind.v2.runtime.unmarshaller.XmlVisitor;
import com.sun.xml.bind.v2.util.FatalAdapter;
import javax.xml.namespace.NamespaceContext;
import javax.xml.validation.Schema;
import javax.xml.validation.ValidatorHandler;
import org.xml.sax.SAXException;

final class ValidatingUnmarshaller
implements XmlVisitor,
XmlVisitor.TextPredictor {
    private final XmlVisitor next;
    private final ValidatorHandler validator;
    private NamespaceContext nsContext = null;
    private final XmlVisitor.TextPredictor predictor;
    private char[] buf = new char[256];

    public ValidatingUnmarshaller(Schema schema, XmlVisitor next2) {
        this.validator = schema.newValidatorHandler();
        this.next = next2;
        this.predictor = next2.getPredictor();
        this.validator.setErrorHandler(new FatalAdapter(this.getContext()));
    }

    public void startDocument(LocatorEx locator, NamespaceContext nsContext) throws SAXException {
        this.nsContext = nsContext;
        this.validator.setDocumentLocator(locator);
        this.validator.startDocument();
        this.next.startDocument(locator, nsContext);
    }

    public void endDocument() throws SAXException {
        this.nsContext = null;
        this.validator.endDocument();
        this.next.endDocument();
    }

    public void startElement(TagName tagName) throws SAXException {
        String tagNamePrefix;
        if (this.nsContext != null && (tagNamePrefix = tagName.getPrefix().intern()) != "") {
            this.validator.startPrefixMapping(tagNamePrefix, this.nsContext.getNamespaceURI(tagNamePrefix));
        }
        this.validator.startElement(tagName.uri, tagName.local, tagName.getQname(), tagName.atts);
        this.next.startElement(tagName);
    }

    public void endElement(TagName tagName) throws SAXException {
        this.validator.endElement(tagName.uri, tagName.local, tagName.getQname());
        this.next.endElement(tagName);
    }

    public void startPrefixMapping(String prefix2, String nsUri) throws SAXException {
        this.validator.startPrefixMapping(prefix2, nsUri);
        this.next.startPrefixMapping(prefix2, nsUri);
    }

    public void endPrefixMapping(String prefix2) throws SAXException {
        this.validator.endPrefixMapping(prefix2);
        this.next.endPrefixMapping(prefix2);
    }

    public void text(CharSequence pcdata) throws SAXException {
        int len2 = pcdata.length();
        if (this.buf.length < len2) {
            this.buf = new char[len2];
        }
        for (int i = 0; i < len2; ++i) {
            this.buf[i] = pcdata.charAt(i);
        }
        this.validator.characters(this.buf, 0, len2);
        if (this.predictor.expectText()) {
            this.next.text(pcdata);
        }
    }

    public UnmarshallingContext getContext() {
        return this.next.getContext();
    }

    public XmlVisitor.TextPredictor getPredictor() {
        return this;
    }

    @Deprecated
    public boolean expectText() {
        return true;
    }
}

