/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.schemagen;

import com.sun.xml.bind.v2.schemagen.GroupKind;
import com.sun.xml.bind.v2.schemagen.xmlschema.ContentModelContainer;
import com.sun.xml.bind.v2.schemagen.xmlschema.Occurs;
import com.sun.xml.bind.v2.schemagen.xmlschema.Particle;
import com.sun.xml.bind.v2.schemagen.xmlschema.TypeDefParticle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Tree {
    Tree() {
    }

    Tree makeOptional(boolean really) {
        return really ? new Optional(this) : this;
    }

    Tree makeRepeated(boolean really) {
        return really ? new Repeated(this) : this;
    }

    static Tree makeGroup(GroupKind kind, List<Tree> children2) {
        if (children2.size() == 1) {
            return children2.get(0);
        }
        ArrayList<Tree> normalizedChildren = new ArrayList<Tree>(children2.size());
        for (Tree t2 : children2) {
            Group g;
            if (t2 instanceof Group && (g = (Group)t2).kind == kind) {
                normalizedChildren.addAll(Arrays.asList(g.children));
                continue;
            }
            normalizedChildren.add(t2);
        }
        return new Group(kind, normalizedChildren.toArray(new Tree[normalizedChildren.size()]));
    }

    abstract boolean isNullable();

    boolean canBeTopLevel() {
        return false;
    }

    protected abstract void write(ContentModelContainer var1, boolean var2, boolean var3);

    protected void write(TypeDefParticle ct) {
        if (this.canBeTopLevel()) {
            this.write(ct._cast(ContentModelContainer.class), false, false);
        } else {
            new Group(GroupKind.SEQUENCE, new Tree[]{this}).write(ct);
        }
    }

    protected final void writeOccurs(Occurs o, boolean isOptional, boolean repeated) {
        if (isOptional) {
            o.minOccurs(0);
        }
        if (repeated) {
            o.maxOccurs("unbounded");
        }
    }

    private static final class Group
    extends Tree {
        private final GroupKind kind;
        private final Tree[] children;

        private Group(GroupKind kind, Tree ... children2) {
            this.kind = kind;
            this.children = children2;
        }

        boolean canBeTopLevel() {
            return true;
        }

        boolean isNullable() {
            if (this.kind == GroupKind.CHOICE) {
                for (Tree t2 : this.children) {
                    if (!t2.isNullable()) continue;
                    return true;
                }
                return false;
            }
            for (Tree t3 : this.children) {
                if (t3.isNullable()) continue;
                return false;
            }
            return true;
        }

        protected void write(ContentModelContainer parent2, boolean isOptional, boolean repeated) {
            Particle c2 = this.kind.write(parent2);
            this.writeOccurs(c2, isOptional, repeated);
            for (Tree child : this.children) {
                child.write(c2, false, false);
            }
        }
    }

    private static final class Repeated
    extends Tree {
        private final Tree body;

        private Repeated(Tree body2) {
            this.body = body2;
        }

        boolean isNullable() {
            return this.body.isNullable();
        }

        Tree makeRepeated(boolean really) {
            return this;
        }

        protected void write(ContentModelContainer parent2, boolean isOptional, boolean repeated) {
            this.body.write(parent2, isOptional, true);
        }
    }

    private static final class Optional
    extends Tree {
        private final Tree body;

        private Optional(Tree body2) {
            this.body = body2;
        }

        boolean isNullable() {
            return true;
        }

        Tree makeOptional(boolean really) {
            return this;
        }

        protected void write(ContentModelContainer parent2, boolean isOptional, boolean repeated) {
            this.body.write(parent2, true, repeated);
        }
    }

    static abstract class Term
    extends Tree {
        Term() {
        }

        boolean isNullable() {
            return false;
        }
    }
}

