/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.util;

import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditDistance {
    private int[] cost;
    private int[] back;
    private final String a;
    private final String b;

    public static int editDistance(String a2, String b) {
        return new EditDistance(a2, b).calc();
    }

    public static String findNearest(String key, String[] group) {
        return EditDistance.findNearest(key, Arrays.asList(group));
    }

    public static String findNearest(String key, Collection<String> group) {
        int c2 = Integer.MAX_VALUE;
        String r = null;
        for (String s2 : group) {
            int ed = EditDistance.editDistance(key, s2);
            if (c2 <= ed) continue;
            c2 = ed;
            r = s2;
        }
        return r;
    }

    private EditDistance(String a2, String b) {
        this.a = a2;
        this.b = b;
        this.cost = new int[a2.length() + 1];
        this.back = new int[a2.length() + 1];
        for (int i = 0; i <= a2.length(); ++i) {
            this.cost[i] = i;
        }
    }

    private void flip() {
        int[] t2 = this.cost;
        this.cost = this.back;
        this.back = t2;
    }

    private int min(int a2, int b, int c2) {
        return Math.min(a2, Math.min(b, c2));
    }

    private int calc() {
        for (int j = 0; j < this.b.length(); ++j) {
            this.flip();
            this.cost[0] = j + 1;
            for (int i = 0; i < this.a.length(); ++i) {
                int match = this.a.charAt(i) == this.b.charAt(j) ? 0 : 1;
                this.cost[i + 1] = this.min(this.back[i] + match, this.cost[i] + 1, this.back[i + 1] + 1);
            }
        }
        return this.cost[this.a.length()];
    }
}

