/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.txw2.output;

import com.sun.xml.txw2.TxwException;
import com.sun.xml.txw2.output.IndentingXMLFilter;
import com.sun.xml.txw2.output.XmlSerializer;
import java.util.Stack;
import javax.xml.transform.sax.SAXResult;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class SaxSerializer
implements XmlSerializer {
    private final ContentHandler writer;
    private final LexicalHandler lexical;
    private final Stack<String> prefixBindings = new Stack();
    private final Stack<String> elementBindings = new Stack();
    private final AttributesImpl attrs = new AttributesImpl();

    public SaxSerializer(ContentHandler handler) {
        this(handler, null, true);
    }

    public SaxSerializer(ContentHandler handler, LexicalHandler lex) {
        this(handler, lex, true);
    }

    public SaxSerializer(ContentHandler handler, LexicalHandler lex, boolean indenting) {
        if (!indenting) {
            this.writer = handler;
            this.lexical = lex;
        } else {
            IndentingXMLFilter indenter = new IndentingXMLFilter(handler, lex);
            this.writer = indenter;
            this.lexical = indenter;
        }
    }

    public SaxSerializer(SAXResult result2) {
        this(result2.getHandler(), result2.getLexicalHandler());
    }

    public void startDocument() {
        try {
            this.writer.startDocument();
        }
        catch (SAXException e2) {
            throw new TxwException(e2);
        }
    }

    public void writeXmlns(String prefix2, String uri) {
        if (prefix2 == null) {
            prefix2 = "";
        }
        if (prefix2.equals("xml")) {
            return;
        }
        this.prefixBindings.add(uri);
        this.prefixBindings.add(prefix2);
    }

    public void beginStartTag(String uri, String localName, String prefix2) {
        this.elementBindings.add(SaxSerializer.getQName(prefix2, localName));
        this.elementBindings.add(localName);
        this.elementBindings.add(uri);
    }

    public void writeAttribute(String uri, String localName, String prefix2, StringBuilder value2) {
        this.attrs.addAttribute(uri, localName, SaxSerializer.getQName(prefix2, localName), "CDATA", value2.toString());
    }

    public void endStartTag(String uri, String localName, String prefix2) {
        try {
            while (this.prefixBindings.size() != 0) {
                this.writer.startPrefixMapping(this.prefixBindings.pop(), this.prefixBindings.pop());
            }
            this.writer.startElement(uri, localName, SaxSerializer.getQName(prefix2, localName), this.attrs);
            this.attrs.clear();
        }
        catch (SAXException e2) {
            throw new TxwException(e2);
        }
    }

    public void endTag() {
        try {
            this.writer.endElement(this.elementBindings.pop(), this.elementBindings.pop(), this.elementBindings.pop());
        }
        catch (SAXException e2) {
            throw new TxwException(e2);
        }
    }

    public void text(StringBuilder text2) {
        try {
            this.writer.characters(text2.toString().toCharArray(), 0, text2.length());
        }
        catch (SAXException e2) {
            throw new TxwException(e2);
        }
    }

    public void cdata(StringBuilder text2) {
        if (this.lexical == null) {
            throw new UnsupportedOperationException("LexicalHandler is needed to write PCDATA");
        }
        try {
            this.lexical.startCDATA();
            this.text(text2);
            this.lexical.endCDATA();
        }
        catch (SAXException e2) {
            throw new TxwException(e2);
        }
    }

    public void comment(StringBuilder comment2) {
        try {
            if (this.lexical == null) {
                throw new UnsupportedOperationException("LexicalHandler is needed to write comments");
            }
            this.lexical.comment(comment2.toString().toCharArray(), 0, comment2.length());
        }
        catch (SAXException e2) {
            throw new TxwException(e2);
        }
    }

    public void endDocument() {
        try {
            this.writer.endDocument();
        }
        catch (SAXException e2) {
            throw new TxwException(e2);
        }
    }

    public void flush() {
    }

    private static String getQName(String prefix2, String localName) {
        String qName = prefix2 == null || prefix2.length() == 0 ? localName : prefix2 + ':' + localName;
        return qName;
    }
}

