/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config;

import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.impl.ConfigImplUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;

public abstract class ConfigException
extends RuntimeException
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final transient ConfigOrigin origin;

    protected ConfigException(ConfigOrigin configOrigin, String string2, Throwable throwable2) {
        super(configOrigin.description() + ": " + string2, throwable2);
        this.origin = configOrigin;
    }

    protected ConfigException(ConfigOrigin configOrigin, String string2) {
        this(configOrigin.description() + ": " + string2, null);
    }

    protected ConfigException(String string2, Throwable throwable2) {
        super(string2, throwable2);
        this.origin = null;
    }

    protected ConfigException(String string2) {
        this(string2, null);
    }

    public ConfigOrigin origin() {
        return this.origin;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        ConfigImplUtil.writeOrigin(objectOutputStream, this.origin);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Field field2;
        objectInputStream.defaultReadObject();
        ConfigOrigin configOrigin = ConfigImplUtil.readOrigin(objectInputStream);
        try {
            field2 = ConfigException.class.getDeclaredField("origin");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IOException("ConfigException has no origin field?", noSuchFieldException);
        }
        catch (SecurityException securityException) {
            throw new IOException("unable to fill out origin field in ConfigException", securityException);
        }
        field2.setAccessible(true);
        try {
            field2.set(this, configOrigin);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("unable to set origin field", illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("unable to set origin field", illegalAccessException);
        }
    }

    public static class Generic
    extends ConfigException {
        private static final long serialVersionUID = 1L;

        public Generic(String string2, Throwable throwable2) {
            super(string2, throwable2);
        }

        public Generic(String string2) {
            this(string2, null);
        }
    }

    public static class ValidationFailed
    extends ConfigException {
        private static final long serialVersionUID = 1L;
        private final Iterable<ValidationProblem> problems;

        public ValidationFailed(Iterable<ValidationProblem> iterable) {
            super(ValidationFailed.makeMessage(iterable), null);
            this.problems = iterable;
        }

        public Iterable<ValidationProblem> problems() {
            return this.problems;
        }

        private static String makeMessage(Iterable<ValidationProblem> iterable) {
            StringBuilder stringBuilder = new StringBuilder();
            for (ValidationProblem validationProblem : iterable) {
                stringBuilder.append(validationProblem.origin().description());
                stringBuilder.append(": ");
                stringBuilder.append(validationProblem.path());
                stringBuilder.append(": ");
                stringBuilder.append(validationProblem.problem());
                stringBuilder.append(", ");
            }
            if (stringBuilder.length() == 0) {
                throw new BugOrBroken("ValidationFailed must have a non-empty list of problems");
            }
            stringBuilder.setLength(stringBuilder.length() - 2);
            return stringBuilder.toString();
        }
    }

    public static class ValidationProblem {
        private final String path;
        private final ConfigOrigin origin;
        private final String problem;

        public ValidationProblem(String string2, ConfigOrigin configOrigin, String string3) {
            this.path = string2;
            this.origin = configOrigin;
            this.problem = string3;
        }

        public String path() {
            return this.path;
        }

        public ConfigOrigin origin() {
            return this.origin;
        }

        public String problem() {
            return this.problem;
        }
    }

    public static class NotResolved
    extends BugOrBroken {
        private static final long serialVersionUID = 1L;

        public NotResolved(String string2, Throwable throwable2) {
            super(string2, throwable2);
        }

        public NotResolved(String string2) {
            this(string2, null);
        }
    }

    public static class UnresolvedSubstitution
    extends Parse {
        private static final long serialVersionUID = 1L;

        public UnresolvedSubstitution(ConfigOrigin configOrigin, String string2, Throwable throwable2) {
            super(configOrigin, "Could not resolve substitution to a value: " + string2, throwable2);
        }

        public UnresolvedSubstitution(ConfigOrigin configOrigin, String string2) {
            this(configOrigin, string2, null);
        }
    }

    public static class Parse
    extends ConfigException {
        private static final long serialVersionUID = 1L;

        public Parse(ConfigOrigin configOrigin, String string2, Throwable throwable2) {
            super(configOrigin, string2, throwable2);
        }

        public Parse(ConfigOrigin configOrigin, String string2) {
            this(configOrigin, string2, null);
        }
    }

    public static class IO
    extends ConfigException {
        private static final long serialVersionUID = 1L;

        public IO(ConfigOrigin configOrigin, String string2, Throwable throwable2) {
            super(configOrigin, string2, throwable2);
        }

        public IO(ConfigOrigin configOrigin, String string2) {
            this(configOrigin, string2, null);
        }
    }

    public static class BugOrBroken
    extends ConfigException {
        private static final long serialVersionUID = 1L;

        public BugOrBroken(String string2, Throwable throwable2) {
            super(string2, throwable2);
        }

        public BugOrBroken(String string2) {
            this(string2, null);
        }
    }

    public static class BadPath
    extends ConfigException {
        private static final long serialVersionUID = 1L;

        public BadPath(ConfigOrigin configOrigin, String string2, String string3, Throwable throwable2) {
            super(configOrigin, string2 != null ? "Invalid path '" + string2 + "': " + string3 : string3, throwable2);
        }

        public BadPath(ConfigOrigin configOrigin, String string2, String string3) {
            this(configOrigin, string2, string3, null);
        }

        public BadPath(String string2, String string3, Throwable throwable2) {
            super(string2 != null ? "Invalid path '" + string2 + "': " + string3 : string3, throwable2);
        }

        public BadPath(String string2, String string3) {
            this(string2, string3, null);
        }

        public BadPath(ConfigOrigin configOrigin, String string2) {
            this(configOrigin, null, string2);
        }
    }

    public static class BadValue
    extends ConfigException {
        private static final long serialVersionUID = 1L;

        public BadValue(ConfigOrigin configOrigin, String string2, String string3, Throwable throwable2) {
            super(configOrigin, "Invalid value at '" + string2 + "': " + string3, throwable2);
        }

        public BadValue(ConfigOrigin configOrigin, String string2, String string3) {
            this(configOrigin, string2, string3, null);
        }

        public BadValue(String string2, String string3, Throwable throwable2) {
            super("Invalid value at '" + string2 + "': " + string3, throwable2);
        }

        public BadValue(String string2, String string3) {
            this(string2, string3, null);
        }
    }

    public static class Null
    extends Missing {
        private static final long serialVersionUID = 1L;

        private static String makeMessage(String string2, String string3) {
            if (string3 != null) {
                return "Configuration key '" + string2 + "' is set to null but expected " + string3;
            }
            return "Configuration key '" + string2 + "' is null";
        }

        public Null(ConfigOrigin configOrigin, String string2, String string3, Throwable throwable2) {
            super(configOrigin, Null.makeMessage(string2, string3), throwable2);
        }

        public Null(ConfigOrigin configOrigin, String string2, String string3) {
            this(configOrigin, string2, string3, null);
        }
    }

    public static class Missing
    extends ConfigException {
        private static final long serialVersionUID = 1L;

        public Missing(String string2, Throwable throwable2) {
            super("No configuration setting found for key '" + string2 + "'", throwable2);
        }

        public Missing(String string2) {
            this(string2, null);
        }

        protected Missing(ConfigOrigin configOrigin, String string2, Throwable throwable2) {
            super(configOrigin, string2, throwable2);
        }

        protected Missing(ConfigOrigin configOrigin, String string2) {
            this(configOrigin, string2, null);
        }
    }

    public static class WrongType
    extends ConfigException {
        private static final long serialVersionUID = 1L;

        public WrongType(ConfigOrigin configOrigin, String string2, String string3, String string4, Throwable throwable2) {
            super(configOrigin, string2 + " has type " + string4 + " rather than " + string3, throwable2);
        }

        public WrongType(ConfigOrigin configOrigin, String string2, String string3, String string4) {
            this(configOrigin, string2, string3, string4, null);
        }

        public WrongType(ConfigOrigin configOrigin, String string2, Throwable throwable2) {
            super(configOrigin, string2, throwable2);
        }

        public WrongType(ConfigOrigin configOrigin, String string2) {
            super(configOrigin, string2, null);
        }
    }
}

