/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.impl.ConfigImpl;
import com.typesafe.config.impl.Parseable;
import java.io.File;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;

public final class ConfigFactory {
    private ConfigFactory() {
    }

    public static Config load(String string2) {
        return ConfigFactory.load(string2, ConfigParseOptions.defaults(), ConfigResolveOptions.defaults());
    }

    public static Config load(ClassLoader classLoader, String string2) {
        return ConfigFactory.load(string2, ConfigParseOptions.defaults().setClassLoader(classLoader), ConfigResolveOptions.defaults());
    }

    public static Config load(String string2, ConfigParseOptions configParseOptions, ConfigResolveOptions configResolveOptions) {
        Config config = ConfigFactory.parseResourcesAnySyntax(string2, configParseOptions);
        return ConfigFactory.load(configParseOptions.getClassLoader(), config, configResolveOptions);
    }

    public static Config load(ClassLoader classLoader, String string2, ConfigParseOptions configParseOptions, ConfigResolveOptions configResolveOptions) {
        return ConfigFactory.load(string2, configParseOptions.setClassLoader(classLoader), configResolveOptions);
    }

    public static Config load(Config config) {
        return ConfigFactory.load(Thread.currentThread().getContextClassLoader(), config);
    }

    public static Config load(ClassLoader classLoader, Config config) {
        return ConfigFactory.load(classLoader, config, ConfigResolveOptions.defaults());
    }

    public static Config load(Config config, ConfigResolveOptions configResolveOptions) {
        return ConfigFactory.load(Thread.currentThread().getContextClassLoader(), config, configResolveOptions);
    }

    public static Config load(ClassLoader classLoader, Config config, ConfigResolveOptions configResolveOptions) {
        return ConfigFactory.defaultOverrides(classLoader).withFallback(config).withFallback(ConfigFactory.defaultReference(classLoader)).resolve(configResolveOptions);
    }

    private static Config loadDefaultConfig(ClassLoader classLoader) {
        return ConfigFactory.loadDefaultConfig(classLoader, ConfigParseOptions.defaults());
    }

    private static Config loadDefaultConfig(ClassLoader classLoader, ConfigParseOptions configParseOptions) {
        return ConfigFactory.loadDefaultConfig(classLoader, configParseOptions, ConfigResolveOptions.defaults());
    }

    private static Config loadDefaultConfig(ClassLoader classLoader, ConfigResolveOptions configResolveOptions) {
        return ConfigFactory.loadDefaultConfig(classLoader, ConfigParseOptions.defaults(), configResolveOptions);
    }

    private static Config loadDefaultConfig(ClassLoader classLoader, ConfigParseOptions configParseOptions, ConfigResolveOptions configResolveOptions) {
        String string2;
        String string3;
        int n = 0;
        String string4 = System.getProperty("config.resource");
        if (string4 != null) {
            ++n;
        }
        if ((string3 = System.getProperty("config.file")) != null) {
            ++n;
        }
        if ((string2 = System.getProperty("config.url")) != null) {
            ++n;
        }
        if (n == 0) {
            return ConfigFactory.load(classLoader, "application", configParseOptions, configResolveOptions);
        }
        if (n > 1) {
            throw new ConfigException.Generic("You set more than one of config.file='" + string3 + "', config.url='" + string2 + "', config.resource='" + string4 + "'; don't know which one to use!");
        }
        if (string4 != null) {
            if (string4.startsWith("/")) {
                string4 = string4.substring(1);
            }
            return ConfigFactory.load(classLoader, ConfigFactory.parseResources(classLoader, string4, configParseOptions), configResolveOptions);
        }
        if (string3 != null) {
            return ConfigFactory.load(classLoader, ConfigFactory.parseFile(new File(string3), configParseOptions), configResolveOptions);
        }
        try {
            return ConfigFactory.load(classLoader, ConfigFactory.parseURL(new URL(string2), configParseOptions), configResolveOptions);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ConfigException.Generic("Bad URL in config.url system property: '" + string2 + "': " + malformedURLException.getMessage(), malformedURLException);
        }
    }

    public static Config load() {
        return ConfigFactory.load(Thread.currentThread().getContextClassLoader());
    }

    public static Config load(ConfigParseOptions configParseOptions) {
        return ConfigFactory.load(Thread.currentThread().getContextClassLoader(), configParseOptions);
    }

    public static Config load(final ClassLoader classLoader) {
        return ConfigImpl.computeCachedConfig(classLoader, "load", new Callable<Config>(){

            @Override
            public Config call() {
                return ConfigFactory.loadDefaultConfig(classLoader);
            }
        });
    }

    public static Config load(ClassLoader classLoader, ConfigParseOptions configParseOptions) {
        return ConfigFactory.loadDefaultConfig(classLoader, configParseOptions);
    }

    public static Config load(ClassLoader classLoader, ConfigResolveOptions configResolveOptions) {
        return ConfigFactory.loadDefaultConfig(classLoader, configResolveOptions);
    }

    public static Config load(ClassLoader classLoader, ConfigParseOptions configParseOptions, ConfigResolveOptions configResolveOptions) {
        return ConfigFactory.loadDefaultConfig(classLoader, configParseOptions, configResolveOptions);
    }

    public static Config defaultReference() {
        return ConfigFactory.defaultReference(Thread.currentThread().getContextClassLoader());
    }

    public static Config defaultReference(ClassLoader classLoader) {
        return ConfigImpl.defaultReference(classLoader);
    }

    public static Config defaultOverrides() {
        return ConfigFactory.systemProperties();
    }

    public static Config defaultOverrides(ClassLoader classLoader) {
        return ConfigFactory.systemProperties();
    }

    public static void invalidateCaches() {
        ConfigImpl.reloadSystemPropertiesConfig();
    }

    public static Config empty() {
        return ConfigFactory.empty(null);
    }

    public static Config empty(String string2) {
        return ConfigImpl.emptyConfig(string2);
    }

    public static Config systemProperties() {
        return ConfigImpl.systemPropertiesAsConfig();
    }

    public static Config systemEnvironment() {
        return ConfigImpl.envVariablesAsConfig();
    }

    public static Config parseProperties(Properties properties2, ConfigParseOptions configParseOptions) {
        return Parseable.newProperties(properties2, configParseOptions).parse().toConfig();
    }

    public static Config parseProperties(Properties properties2) {
        return ConfigFactory.parseProperties(properties2, ConfigParseOptions.defaults());
    }

    public static Config parseReader(Reader reader2, ConfigParseOptions configParseOptions) {
        return Parseable.newReader(reader2, configParseOptions).parse().toConfig();
    }

    public static Config parseReader(Reader reader2) {
        return ConfigFactory.parseReader(reader2, ConfigParseOptions.defaults());
    }

    public static Config parseURL(URL uRL, ConfigParseOptions configParseOptions) {
        return Parseable.newURL(uRL, configParseOptions).parse().toConfig();
    }

    public static Config parseURL(URL uRL) {
        return ConfigFactory.parseURL(uRL, ConfigParseOptions.defaults());
    }

    public static Config parseFile(File file, ConfigParseOptions configParseOptions) {
        return Parseable.newFile(file, configParseOptions).parse().toConfig();
    }

    public static Config parseFile(File file) {
        return ConfigFactory.parseFile(file, ConfigParseOptions.defaults());
    }

    public static Config parseFileAnySyntax(File file, ConfigParseOptions configParseOptions) {
        return ConfigImpl.parseFileAnySyntax(file, configParseOptions).toConfig();
    }

    public static Config parseFileAnySyntax(File file) {
        return ConfigFactory.parseFileAnySyntax(file, ConfigParseOptions.defaults());
    }

    public static Config parseResources(Class<?> clazz2, String string2, ConfigParseOptions configParseOptions) {
        return Parseable.newResources(clazz2, string2, configParseOptions).parse().toConfig();
    }

    public static Config parseResources(Class<?> clazz2, String string2) {
        return ConfigFactory.parseResources(clazz2, string2, ConfigParseOptions.defaults());
    }

    public static Config parseResourcesAnySyntax(Class<?> clazz2, String string2, ConfigParseOptions configParseOptions) {
        return ConfigImpl.parseResourcesAnySyntax(clazz2, string2, configParseOptions).toConfig();
    }

    public static Config parseResourcesAnySyntax(Class<?> clazz2, String string2) {
        return ConfigFactory.parseResourcesAnySyntax(clazz2, string2, ConfigParseOptions.defaults());
    }

    public static Config parseResources(ClassLoader classLoader, String string2, ConfigParseOptions configParseOptions) {
        return Parseable.newResources(string2, configParseOptions.setClassLoader(classLoader)).parse().toConfig();
    }

    public static Config parseResources(ClassLoader classLoader, String string2) {
        return ConfigFactory.parseResources(classLoader, string2, ConfigParseOptions.defaults());
    }

    public static Config parseResourcesAnySyntax(ClassLoader classLoader, String string2, ConfigParseOptions configParseOptions) {
        return ConfigImpl.parseResourcesAnySyntax(string2, configParseOptions.setClassLoader(classLoader)).toConfig();
    }

    public static Config parseResourcesAnySyntax(ClassLoader classLoader, String string2) {
        return ConfigFactory.parseResourcesAnySyntax(classLoader, string2, ConfigParseOptions.defaults());
    }

    public static Config parseResources(String string2, ConfigParseOptions configParseOptions) {
        return Parseable.newResources(string2, configParseOptions).parse().toConfig();
    }

    public static Config parseResources(String string2) {
        return ConfigFactory.parseResources(string2, ConfigParseOptions.defaults());
    }

    public static Config parseResourcesAnySyntax(String string2, ConfigParseOptions configParseOptions) {
        return ConfigImpl.parseResourcesAnySyntax(string2, configParseOptions).toConfig();
    }

    public static Config parseResourcesAnySyntax(String string2) {
        return ConfigFactory.parseResourcesAnySyntax(string2, ConfigParseOptions.defaults());
    }

    public static Config parseString(String string2, ConfigParseOptions configParseOptions) {
        return Parseable.newString(string2, configParseOptions).parse().toConfig();
    }

    public static Config parseString(String string2) {
        return ConfigFactory.parseString(string2, ConfigParseOptions.defaults());
    }

    public static Config parseMap(Map<String, ? extends Object> map3, String string2) {
        return ConfigImpl.fromPathMap(map3, string2).toConfig();
    }

    public static Config parseMap(Map<String, ? extends Object> map3) {
        return ConfigFactory.parseMap(map3, null);
    }
}

