/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.ConfigDelayedMerge;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.MergeableValue;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveContext;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SimpleConfig;
import com.typesafe.config.impl.SimpleConfigObject;
import com.typesafe.config.impl.SimpleConfigOrigin;
import com.typesafe.config.impl.Unmergeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

abstract class AbstractConfigValue
implements ConfigValue,
MergeableValue {
    private final SimpleConfigOrigin origin;

    AbstractConfigValue(ConfigOrigin configOrigin) {
        this.origin = (SimpleConfigOrigin)configOrigin;
    }

    @Override
    public SimpleConfigOrigin origin() {
        return this.origin;
    }

    AbstractConfigValue resolveSubstitutions(ResolveContext resolveContext) throws NotPossibleToResolve {
        return this;
    }

    ResolveStatus resolveStatus() {
        return ResolveStatus.RESOLVED;
    }

    AbstractConfigValue relativized(Path path2) {
        return this;
    }

    @Override
    public AbstractConfigValue toFallbackValue() {
        return this;
    }

    protected abstract AbstractConfigValue newCopy(ConfigOrigin var1);

    protected boolean ignoresFallbacks() {
        return this.resolveStatus() == ResolveStatus.RESOLVED;
    }

    protected AbstractConfigValue withFallbacksIgnored() {
        if (this.ignoresFallbacks()) {
            return this;
        }
        throw new ConfigException.BugOrBroken("value class doesn't implement forced fallback-ignoring " + this);
    }

    protected final void requireNotIgnoringFallbacks() {
        if (this.ignoresFallbacks()) {
            throw new ConfigException.BugOrBroken("method should not have been called with ignoresFallbacks=true " + this.getClass().getSimpleName());
        }
    }

    protected AbstractConfigValue constructDelayedMerge(ConfigOrigin configOrigin, List<AbstractConfigValue> list2) {
        return new ConfigDelayedMerge(configOrigin, list2);
    }

    protected final AbstractConfigValue mergedWithTheUnmergeable(Collection<AbstractConfigValue> collection, Unmergeable unmergeable) {
        this.requireNotIgnoringFallbacks();
        ArrayList<AbstractConfigValue> arrayList = new ArrayList<AbstractConfigValue>();
        arrayList.addAll(collection);
        arrayList.addAll(unmergeable.unmergedValues());
        return this.constructDelayedMerge(AbstractConfigObject.mergeOrigins(arrayList), arrayList);
    }

    private final AbstractConfigValue delayMerge(Collection<AbstractConfigValue> collection, AbstractConfigValue abstractConfigValue) {
        ArrayList<AbstractConfigValue> arrayList = new ArrayList<AbstractConfigValue>();
        arrayList.addAll(collection);
        arrayList.add(abstractConfigValue);
        return this.constructDelayedMerge(AbstractConfigObject.mergeOrigins(arrayList), arrayList);
    }

    protected final AbstractConfigValue mergedWithObject(Collection<AbstractConfigValue> collection, AbstractConfigObject abstractConfigObject) {
        this.requireNotIgnoringFallbacks();
        if (this instanceof AbstractConfigObject) {
            throw new ConfigException.BugOrBroken("Objects must reimplement mergedWithObject");
        }
        return this.mergedWithNonObject(collection, abstractConfigObject);
    }

    protected final AbstractConfigValue mergedWithNonObject(Collection<AbstractConfigValue> collection, AbstractConfigValue abstractConfigValue) {
        this.requireNotIgnoringFallbacks();
        if (this.resolveStatus() == ResolveStatus.RESOLVED) {
            return this.withFallbacksIgnored();
        }
        return this.delayMerge(collection, abstractConfigValue);
    }

    protected AbstractConfigValue mergedWithTheUnmergeable(Unmergeable unmergeable) {
        this.requireNotIgnoringFallbacks();
        return this.mergedWithTheUnmergeable(Collections.singletonList(this), unmergeable);
    }

    protected AbstractConfigValue mergedWithObject(AbstractConfigObject abstractConfigObject) {
        this.requireNotIgnoringFallbacks();
        return this.mergedWithObject(Collections.singletonList(this), abstractConfigObject);
    }

    protected AbstractConfigValue mergedWithNonObject(AbstractConfigValue abstractConfigValue) {
        this.requireNotIgnoringFallbacks();
        return this.mergedWithNonObject(Collections.singletonList(this), abstractConfigValue);
    }

    public AbstractConfigValue withOrigin(ConfigOrigin configOrigin) {
        if (this.origin == configOrigin) {
            return this;
        }
        return this.newCopy(configOrigin);
    }

    @Override
    public AbstractConfigValue withFallback(ConfigMergeable configMergeable) {
        if (this.ignoresFallbacks()) {
            return this;
        }
        ConfigValue configValue = ((MergeableValue)configMergeable).toFallbackValue();
        if (configValue instanceof Unmergeable) {
            return this.mergedWithTheUnmergeable((Unmergeable)((Object)configValue));
        }
        if (configValue instanceof AbstractConfigObject) {
            return this.mergedWithObject((AbstractConfigObject)configValue);
        }
        return this.mergedWithNonObject((AbstractConfigValue)configValue);
    }

    protected boolean canEqual(Object object) {
        return object instanceof ConfigValue;
    }

    public boolean equals(Object object) {
        if (object instanceof ConfigValue) {
            return this.canEqual(object) && this.valueType() == ((ConfigValue)object).valueType() && ConfigImplUtil.equalsHandlingNull(this.unwrapped(), ((ConfigValue)object).unwrapped());
        }
        return false;
    }

    public int hashCode() {
        Object object = this.unwrapped();
        if (object == null) {
            return 0;
        }
        return object.hashCode();
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.render(stringBuilder, 0, null, ConfigRenderOptions.concise());
        return this.getClass().getSimpleName() + "(" + stringBuilder.toString() + ")";
    }

    protected static void indent(StringBuilder stringBuilder, int n, ConfigRenderOptions configRenderOptions) {
        if (configRenderOptions.getFormatted()) {
            for (int i = n; i > 0; --i) {
                stringBuilder.append("    ");
            }
        }
    }

    protected void render(StringBuilder stringBuilder, int n, String string2, ConfigRenderOptions configRenderOptions) {
        if (string2 != null) {
            String string3 = configRenderOptions.getJson() ? ConfigImplUtil.renderJsonString(string2) : ConfigImplUtil.renderStringUnquotedIfPossible(string2);
            stringBuilder.append(string3);
            if (configRenderOptions.getJson()) {
                if (configRenderOptions.getFormatted()) {
                    stringBuilder.append(" : ");
                } else {
                    stringBuilder.append(":");
                }
            } else if (this instanceof ConfigObject) {
                if (configRenderOptions.getFormatted()) {
                    stringBuilder.append(' ');
                }
            } else {
                stringBuilder.append("=");
            }
        }
        this.render(stringBuilder, n, configRenderOptions);
    }

    protected void render(StringBuilder stringBuilder, int n, ConfigRenderOptions configRenderOptions) {
        Object object = this.unwrapped();
        stringBuilder.append(object.toString());
    }

    @Override
    public final String render() {
        return this.render(ConfigRenderOptions.defaults());
    }

    @Override
    public final String render(ConfigRenderOptions configRenderOptions) {
        StringBuilder stringBuilder = new StringBuilder();
        this.render(stringBuilder, 0, null, configRenderOptions);
        return stringBuilder.toString();
    }

    String transformToString() {
        return null;
    }

    SimpleConfig atKey(ConfigOrigin configOrigin, String string2) {
        Map<String, AbstractConfigValue> map3 = Collections.singletonMap(string2, this);
        return new SimpleConfigObject(configOrigin, map3).toConfig();
    }

    @Override
    public SimpleConfig atKey(String string2) {
        return this.atKey(SimpleConfigOrigin.newSimple("atKey(" + string2 + ")"), string2);
    }

    SimpleConfig atPath(ConfigOrigin configOrigin, Path path2) {
        SimpleConfig simpleConfig = this.atKey(configOrigin, path2.last());
        for (Path path3 = path2.parent(); path3 != null; path3 = path3.parent()) {
            String string2 = path3.last();
            simpleConfig = simpleConfig.atKey(configOrigin, string2);
        }
        return simpleConfig;
    }

    @Override
    public SimpleConfig atPath(String string2) {
        SimpleConfigOrigin simpleConfigOrigin = SimpleConfigOrigin.newSimple("atPath(" + string2 + ")");
        return this.atPath(simpleConfigOrigin, Path.newPath(string2));
    }

    protected abstract class NoExceptionsModifier
    implements Modifier {
        protected NoExceptionsModifier() {
        }

        @Override
        public final AbstractConfigValue modifyChildMayThrow(String string2, AbstractConfigValue abstractConfigValue) throws Exception {
            try {
                return this.modifyChild(string2, abstractConfigValue);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new ConfigException.BugOrBroken("Unexpected exception", exception);
            }
        }

        abstract AbstractConfigValue modifyChild(String var1, AbstractConfigValue var2);
    }

    protected static interface Modifier {
        public AbstractConfigValue modifyChildMayThrow(String var1, AbstractConfigValue var2) throws Exception;
    }

    static class NotPossibleToResolve
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final String traceString;

        NotPossibleToResolve(ResolveContext resolveContext) {
            super("was not possible to resolve");
            this.traceString = resolveContext.traceString();
        }

        String traceString() {
            return this.traceString;
        }
    }
}

