/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigReference;
import com.typesafe.config.impl.ConfigString;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveContext;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SimpleConfigList;
import com.typesafe.config.impl.SimpleConfigOrigin;
import com.typesafe.config.impl.SubstitutionExpression;
import com.typesafe.config.impl.Unmergeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

final class ConfigConcatenation
extends AbstractConfigValue
implements Unmergeable {
    private final List<AbstractConfigValue> pieces;

    ConfigConcatenation(ConfigOrigin configOrigin, List<AbstractConfigValue> list2) {
        super(configOrigin);
        this.pieces = list2;
        if (list2.size() < 2) {
            throw new ConfigException.BugOrBroken("Created concatenation with less than 2 items: " + this);
        }
        boolean bl = false;
        for (AbstractConfigValue abstractConfigValue : list2) {
            if (abstractConfigValue instanceof ConfigConcatenation) {
                throw new ConfigException.BugOrBroken("ConfigConcatenation should never be nested: " + this);
            }
            if (!(abstractConfigValue instanceof Unmergeable)) continue;
            bl = true;
        }
        if (!bl) {
            throw new ConfigException.BugOrBroken("Created concatenation without an unmergeable in it: " + this);
        }
    }

    private ConfigException.NotResolved notResolved() {
        return new ConfigException.NotResolved("need to Config#resolve(), see the API docs for Config#resolve(); substitution not resolved: " + this);
    }

    @Override
    public ConfigValueType valueType() {
        throw this.notResolved();
    }

    @Override
    public Object unwrapped() {
        throw this.notResolved();
    }

    @Override
    protected ConfigConcatenation newCopy(ConfigOrigin configOrigin) {
        return new ConfigConcatenation(configOrigin, this.pieces);
    }

    @Override
    protected boolean ignoresFallbacks() {
        return false;
    }

    public Collection<ConfigConcatenation> unmergedValues() {
        return Collections.singleton(this);
    }

    private static void join(ArrayList<AbstractConfigValue> arrayList, AbstractConfigValue abstractConfigValue) {
        AbstractConfigValue abstractConfigValue2 = arrayList.get(arrayList.size() - 1);
        AbstractConfigValue abstractConfigValue3 = null;
        if (abstractConfigValue2 instanceof ConfigObject && abstractConfigValue instanceof ConfigObject) {
            abstractConfigValue3 = abstractConfigValue.withFallback(abstractConfigValue2);
        } else if (abstractConfigValue2 instanceof SimpleConfigList && abstractConfigValue instanceof SimpleConfigList) {
            abstractConfigValue3 = ((SimpleConfigList)abstractConfigValue2).concatenate((SimpleConfigList)abstractConfigValue);
        } else {
            if (abstractConfigValue2 instanceof ConfigConcatenation || abstractConfigValue instanceof ConfigConcatenation) {
                throw new ConfigException.BugOrBroken("unflattened ConfigConcatenation");
            }
            if (!(abstractConfigValue2 instanceof Unmergeable) && !(abstractConfigValue instanceof Unmergeable)) {
                String string2 = abstractConfigValue2.transformToString();
                String string3 = abstractConfigValue.transformToString();
                if (string2 == null || string3 == null) {
                    throw new ConfigException.WrongType(abstractConfigValue2.origin(), "Cannot concatenate object or list with a non-object-or-list, " + abstractConfigValue2 + " and " + abstractConfigValue + " are not compatible");
                }
                ConfigOrigin configOrigin = SimpleConfigOrigin.mergeOrigins(abstractConfigValue2.origin(), abstractConfigValue.origin());
                abstractConfigValue3 = new ConfigString(configOrigin, string2 + string3);
            }
        }
        if (abstractConfigValue3 == null) {
            arrayList.add(abstractConfigValue);
        } else {
            arrayList.remove(arrayList.size() - 1);
            arrayList.add(abstractConfigValue3);
        }
    }

    static List<AbstractConfigValue> consolidate(List<AbstractConfigValue> list2) {
        if (list2.size() < 2) {
            return list2;
        }
        ArrayList<AbstractConfigValue> arrayList = new ArrayList<AbstractConfigValue>(list2.size());
        for (AbstractConfigValue object : list2) {
            if (object instanceof ConfigConcatenation) {
                arrayList.addAll(((ConfigConcatenation)object).pieces);
                continue;
            }
            arrayList.add(object);
        }
        ArrayList arrayList2 = new ArrayList(arrayList.size());
        for (AbstractConfigValue abstractConfigValue : arrayList) {
            if (arrayList2.isEmpty()) {
                arrayList2.add(abstractConfigValue);
                continue;
            }
            ConfigConcatenation.join(arrayList2, abstractConfigValue);
        }
        return arrayList2;
    }

    static AbstractConfigValue concatenate(List<AbstractConfigValue> list2) {
        List<AbstractConfigValue> list3 = ConfigConcatenation.consolidate(list2);
        if (list3.isEmpty()) {
            return null;
        }
        if (list3.size() == 1) {
            return list3.get(0);
        }
        ConfigOrigin configOrigin = SimpleConfigOrigin.mergeOrigins(list3);
        return new ConfigConcatenation(configOrigin, list3);
    }

    @Override
    AbstractConfigValue resolveSubstitutions(ResolveContext resolveContext) throws AbstractConfigValue.NotPossibleToResolve {
        ArrayList<AbstractConfigValue> arrayList = new ArrayList<AbstractConfigValue>(this.pieces.size());
        for (AbstractConfigValue abstractConfigValue : this.pieces) {
            AbstractConfigValue abstractConfigValue2 = resolveContext.unrestricted().resolve(abstractConfigValue);
            if (abstractConfigValue2 == null) continue;
            arrayList.add(abstractConfigValue2);
        }
        List<AbstractConfigValue> list2 = ConfigConcatenation.consolidate(arrayList);
        if (list2.size() != 1) {
            throw new ConfigException.BugOrBroken("Resolved list should always join to exactly one value, not " + list2);
        }
        return (AbstractConfigValue)list2.get(0);
    }

    @Override
    ResolveStatus resolveStatus() {
        return ResolveStatus.UNRESOLVED;
    }

    @Override
    ConfigConcatenation relativized(Path path2) {
        ArrayList<AbstractConfigValue> arrayList = new ArrayList<AbstractConfigValue>();
        for (AbstractConfigValue abstractConfigValue : this.pieces) {
            arrayList.add(abstractConfigValue.relativized(path2));
        }
        return new ConfigConcatenation(this.origin(), arrayList);
    }

    @Override
    protected boolean canEqual(Object object) {
        return object instanceof ConfigConcatenation;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ConfigConcatenation) {
            return this.canEqual(object) && ((Object)this.pieces).equals(((ConfigConcatenation)object).pieces);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.pieces).hashCode();
    }

    @Override
    protected void render(StringBuilder stringBuilder, int n, ConfigRenderOptions configRenderOptions) {
        for (AbstractConfigValue abstractConfigValue : this.pieces) {
            abstractConfigValue.render(stringBuilder, n, configRenderOptions);
        }
    }

    static List<AbstractConfigValue> valuesFromPieces(ConfigOrigin configOrigin, List<Object> list2) {
        ArrayList<AbstractConfigValue> arrayList = new ArrayList<AbstractConfigValue>(list2.size());
        for (Object object : list2) {
            if (object instanceof SubstitutionExpression) {
                arrayList.add(new ConfigReference(configOrigin, (SubstitutionExpression)object));
                continue;
            }
            if (object instanceof String) {
                arrayList.add(new ConfigString(configOrigin, (String)object));
                continue;
            }
            throw new ConfigException.BugOrBroken("Unexpected piece " + object);
        }
        return arrayList;
    }
}

