/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigDelayedMergeObject;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ReplaceableMergeStack;
import com.typesafe.config.impl.ResolveContext;
import com.typesafe.config.impl.ResolveReplacer;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.Unmergeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

final class ConfigDelayedMerge
extends AbstractConfigValue
implements Unmergeable,
ReplaceableMergeStack {
    private final List<AbstractConfigValue> stack;

    ConfigDelayedMerge(ConfigOrigin configOrigin, List<AbstractConfigValue> list2) {
        super(configOrigin);
        this.stack = list2;
        if (list2.isEmpty()) {
            throw new ConfigException.BugOrBroken("creating empty delayed merge value");
        }
        for (AbstractConfigValue abstractConfigValue : list2) {
            if (!(abstractConfigValue instanceof ConfigDelayedMerge) && !(abstractConfigValue instanceof ConfigDelayedMergeObject)) continue;
            throw new ConfigException.BugOrBroken("placed nested DelayedMerge in a ConfigDelayedMerge, should have consolidated stack");
        }
    }

    @Override
    public ConfigValueType valueType() {
        throw new ConfigException.NotResolved("called valueType() on value with unresolved substitutions, need to Config#resolve() first, see API docs");
    }

    @Override
    public Object unwrapped() {
        throw new ConfigException.NotResolved("called unwrapped() on value with unresolved substitutions, need to Config#resolve() first, see API docs");
    }

    @Override
    AbstractConfigValue resolveSubstitutions(ResolveContext resolveContext) throws AbstractConfigValue.NotPossibleToResolve {
        return ConfigDelayedMerge.resolveSubstitutions(this, this.stack, resolveContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AbstractConfigValue resolveSubstitutions(ReplaceableMergeStack replaceableMergeStack, List<AbstractConfigValue> list2, ResolveContext resolveContext) throws AbstractConfigValue.NotPossibleToResolve {
        int n = 0;
        AbstractConfigValue abstractConfigValue = null;
        for (AbstractConfigValue abstractConfigValue2 : list2) {
            AbstractConfigValue abstractConfigValue3;
            if (abstractConfigValue2 instanceof ReplaceableMergeStack) {
                throw new ConfigException.BugOrBroken("A delayed merge should not contain another one: " + replaceableMergeStack);
            }
            boolean bl = false;
            if (abstractConfigValue2 instanceof Unmergeable) {
                resolveContext.source().replace((AbstractConfigValue)((Object)replaceableMergeStack), replaceableMergeStack.makeReplacer(n + 1));
                bl = true;
            }
            try {
                abstractConfigValue3 = resolveContext.resolve(abstractConfigValue2);
            }
            finally {
                if (bl) {
                    resolveContext.source().unreplace((AbstractConfigValue)((Object)replaceableMergeStack));
                }
            }
            if (abstractConfigValue3 != null) {
                abstractConfigValue = abstractConfigValue == null ? abstractConfigValue3 : abstractConfigValue.withFallback(abstractConfigValue3);
            }
            ++n;
        }
        return abstractConfigValue;
    }

    @Override
    public ResolveReplacer makeReplacer(final int n) {
        return new ResolveReplacer(){

            @Override
            protected AbstractConfigValue makeReplacement(ResolveContext resolveContext) throws AbstractConfigValue.NotPossibleToResolve {
                return ConfigDelayedMerge.makeReplacement(resolveContext, ConfigDelayedMerge.this.stack, n);
            }
        };
    }

    static AbstractConfigValue makeReplacement(ResolveContext resolveContext, List<AbstractConfigValue> list2, int n) throws AbstractConfigValue.NotPossibleToResolve {
        List<AbstractConfigValue> list3 = list2.subList(n, list2.size());
        if (list3.isEmpty()) {
            throw new AbstractConfigValue.NotPossibleToResolve(resolveContext);
        }
        AbstractConfigValue abstractConfigValue = null;
        for (AbstractConfigValue abstractConfigValue2 : list3) {
            if (abstractConfigValue == null) {
                abstractConfigValue = abstractConfigValue2;
                continue;
            }
            abstractConfigValue = abstractConfigValue.withFallback(abstractConfigValue2);
        }
        return abstractConfigValue;
    }

    @Override
    ResolveStatus resolveStatus() {
        return ResolveStatus.UNRESOLVED;
    }

    @Override
    ConfigDelayedMerge relativized(Path path2) {
        ArrayList<AbstractConfigValue> arrayList = new ArrayList<AbstractConfigValue>();
        for (AbstractConfigValue abstractConfigValue : this.stack) {
            arrayList.add(abstractConfigValue.relativized(path2));
        }
        return new ConfigDelayedMerge(this.origin(), arrayList);
    }

    static boolean stackIgnoresFallbacks(List<AbstractConfigValue> list2) {
        AbstractConfigValue abstractConfigValue = list2.get(list2.size() - 1);
        return abstractConfigValue.ignoresFallbacks();
    }

    @Override
    protected boolean ignoresFallbacks() {
        return ConfigDelayedMerge.stackIgnoresFallbacks(this.stack);
    }

    @Override
    protected AbstractConfigValue newCopy(ConfigOrigin configOrigin) {
        return new ConfigDelayedMerge(configOrigin, this.stack);
    }

    @Override
    protected final ConfigDelayedMerge mergedWithTheUnmergeable(Unmergeable unmergeable) {
        return (ConfigDelayedMerge)this.mergedWithTheUnmergeable(this.stack, unmergeable);
    }

    @Override
    protected final ConfigDelayedMerge mergedWithObject(AbstractConfigObject abstractConfigObject) {
        return (ConfigDelayedMerge)this.mergedWithObject(this.stack, abstractConfigObject);
    }

    @Override
    protected ConfigDelayedMerge mergedWithNonObject(AbstractConfigValue abstractConfigValue) {
        return (ConfigDelayedMerge)this.mergedWithNonObject(this.stack, abstractConfigValue);
    }

    public Collection<AbstractConfigValue> unmergedValues() {
        return this.stack;
    }

    @Override
    protected boolean canEqual(Object object) {
        return object instanceof ConfigDelayedMerge;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ConfigDelayedMerge) {
            return this.canEqual(object) && ((Object)this.stack).equals(((ConfigDelayedMerge)object).stack);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.stack).hashCode();
    }

    @Override
    protected void render(StringBuilder stringBuilder, int n, String string2, ConfigRenderOptions configRenderOptions) {
        ConfigDelayedMerge.render(this.stack, stringBuilder, n, string2, configRenderOptions);
    }

    static void render(List<AbstractConfigValue> list2, StringBuilder stringBuilder, int n, String string2, ConfigRenderOptions configRenderOptions) {
        boolean bl = configRenderOptions.getComments();
        if (bl) {
            stringBuilder.append("# unresolved merge of " + list2.size() + " values follows (\n");
            if (string2 == null) {
                ConfigDelayedMerge.indent(stringBuilder, n, configRenderOptions);
                stringBuilder.append("# this unresolved merge will not be parseable because it's at the root of the object\n");
                ConfigDelayedMerge.indent(stringBuilder, n, configRenderOptions);
                stringBuilder.append("# the HOCON format has no way to list multiple root objects in a single file\n");
            }
        }
        ArrayList<AbstractConfigValue> arrayList = new ArrayList<AbstractConfigValue>();
        arrayList.addAll(list2);
        Collections.reverse(arrayList);
        int n2 = 0;
        for (AbstractConfigValue abstractConfigValue : arrayList) {
            if (bl) {
                ConfigDelayedMerge.indent(stringBuilder, n, configRenderOptions);
                if (string2 != null) {
                    stringBuilder.append("#     unmerged value " + n2 + " for key " + ConfigImplUtil.renderJsonString(string2) + " from ");
                } else {
                    stringBuilder.append("#     unmerged value " + n2 + " from ");
                }
                ++n2;
                stringBuilder.append(abstractConfigValue.origin().description());
                stringBuilder.append("\n");
                for (String string3 : abstractConfigValue.origin().comments()) {
                    ConfigDelayedMerge.indent(stringBuilder, n, configRenderOptions);
                    stringBuilder.append("# ");
                    stringBuilder.append(string3);
                    stringBuilder.append("\n");
                }
            }
            ConfigDelayedMerge.indent(stringBuilder, n, configRenderOptions);
            if (string2 != null) {
                stringBuilder.append(ConfigImplUtil.renderJsonString(string2));
                if (configRenderOptions.getFormatted()) {
                    stringBuilder.append(" : ");
                } else {
                    stringBuilder.append(":");
                }
            }
            abstractConfigValue.render(stringBuilder, n, configRenderOptions);
            stringBuilder.append(",");
            if (!configRenderOptions.getFormatted()) continue;
            stringBuilder.append('\n');
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        if (configRenderOptions.getFormatted()) {
            stringBuilder.setLength(stringBuilder.length() - 1);
            stringBuilder.append("\n");
        }
        if (bl) {
            ConfigDelayedMerge.indent(stringBuilder, n, configRenderOptions);
            stringBuilder.append("# ) end of unresolved merge\n");
        }
    }
}

