/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.SerializedConfigValue;
import com.typesafe.config.impl.SimpleConfigOrigin;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public final class ConfigImplUtil {
    static boolean equalsHandlingNull(Object object, Object object2) {
        if (object == null && object2 != null) {
            return false;
        }
        if (object != null && object2 == null) {
            return false;
        }
        if (object == object2) {
            return true;
        }
        return object.equals(object2);
    }

    public static String renderJsonString(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\"');
        block9: for (int i = 0; i < string2.length(); ++i) {
            char c2 = string2.charAt(i);
            switch (c2) {
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block9;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block9;
                }
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block9;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block9;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block9;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block9;
                }
                default: {
                    if (Character.isISOControl(c2)) {
                        stringBuilder.append(String.format("\\u%04x", c2));
                        continue block9;
                    }
                    stringBuilder.append(c2);
                }
            }
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    static String renderStringUnquotedIfPossible(String string2) {
        if (string2.length() == 0) {
            return ConfigImplUtil.renderJsonString(string2);
        }
        int n = string2.codePointAt(0);
        if (Character.isDigit(n)) {
            return ConfigImplUtil.renderJsonString(string2);
        }
        if (string2.startsWith("include") || string2.startsWith("true") || string2.startsWith("false") || string2.startsWith("null") || string2.contains("//")) {
            return ConfigImplUtil.renderJsonString(string2);
        }
        for (int i = 0; i < string2.length(); ++i) {
            char c2 = string2.charAt(i);
            if (Character.isLetter(c2) || Character.isDigit(c2)) continue;
            return ConfigImplUtil.renderJsonString(string2);
        }
        return string2;
    }

    static boolean isWhitespace(int n) {
        switch (n) {
            case 10: 
            case 32: 
            case 160: 
            case 8199: 
            case 8239: {
                return true;
            }
        }
        return Character.isWhitespace(n);
    }

    public static String unicodeTrim(String string2) {
        int n;
        int n2;
        int n3 = string2.length();
        if (n3 == 0) {
            return string2;
        }
        int n4 = 0;
        while (n4 < n3) {
            n2 = string2.charAt(n4);
            if (n2 == 32 || n2 == 10) {
                ++n4;
                continue;
            }
            n = string2.codePointAt(n4);
            if (!ConfigImplUtil.isWhitespace(n)) break;
            n4 += Character.charCount(n);
        }
        n2 = n3;
        while (n2 > n4) {
            int n5;
            int n6;
            n = string2.charAt(n2 - 1);
            if (n == 32 || n == 10) {
                --n2;
                continue;
            }
            if (Character.isLowSurrogate((char)n)) {
                n6 = string2.codePointAt(n2 - 2);
                n5 = 2;
            } else {
                n6 = string2.codePointAt(n2 - 1);
                n5 = 1;
            }
            if (!ConfigImplUtil.isWhitespace(n6)) break;
            n2 -= n5;
        }
        return string2.substring(n4, n2);
    }

    public static ConfigException extractInitializerError(ExceptionInInitializerError exceptionInInitializerError) {
        Throwable throwable2 = exceptionInInitializerError.getCause();
        if (throwable2 != null && throwable2 instanceof ConfigException) {
            return (ConfigException)throwable2;
        }
        throw exceptionInInitializerError;
    }

    static File urlToFile(URL uRL) {
        try {
            return new File(uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            return new File(uRL.getPath());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new File(uRL.getPath());
        }
    }

    public static String joinPath(String ... stringArray) {
        return new Path(stringArray).render();
    }

    public static String joinPath(List<String> list2) {
        return ConfigImplUtil.joinPath(list2.toArray(new String[0]));
    }

    public static List<String> splitPath(String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Path path2 = Path.newPath(string2); path2 != null; path2 = path2.remainder()) {
            arrayList.add(path2.first());
        }
        return arrayList;
    }

    public static ConfigOrigin readOrigin(ObjectInputStream objectInputStream) throws IOException {
        return SerializedConfigValue.readOrigin(objectInputStream, null);
    }

    public static void writeOrigin(ObjectOutputStream objectOutputStream, ConfigOrigin configOrigin) throws IOException {
        SerializedConfigValue.writeOrigin(new DataOutputStream(objectOutputStream), (SimpleConfigOrigin)configOrigin, null);
    }
}

