/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.Parser;
import com.typesafe.config.impl.PathBuilder;
import java.util.Iterator;
import java.util.List;

final class Path {
    private final String first;
    private final Path remainder;

    Path(String string2, Path path2) {
        this.first = string2;
        this.remainder = path2;
    }

    Path(String ... stringArray) {
        if (stringArray.length == 0) {
            throw new ConfigException.BugOrBroken("empty path");
        }
        this.first = stringArray[0];
        if (stringArray.length > 1) {
            PathBuilder pathBuilder = new PathBuilder();
            for (int i = 1; i < stringArray.length; ++i) {
                pathBuilder.appendKey(stringArray[i]);
            }
            this.remainder = pathBuilder.result();
        } else {
            this.remainder = null;
        }
    }

    Path(List<Path> list2) {
        if (list2.isEmpty()) {
            throw new ConfigException.BugOrBroken("empty path");
        }
        Iterator<Path> iterator2 = list2.iterator();
        Path path2 = iterator2.next();
        this.first = path2.first;
        PathBuilder pathBuilder = new PathBuilder();
        if (path2.remainder != null) {
            pathBuilder.appendPath(path2.remainder);
        }
        while (iterator2.hasNext()) {
            pathBuilder.appendPath(iterator2.next());
        }
        this.remainder = pathBuilder.result();
    }

    String first() {
        return this.first;
    }

    Path remainder() {
        return this.remainder;
    }

    Path parent() {
        if (this.remainder == null) {
            return null;
        }
        PathBuilder pathBuilder = new PathBuilder();
        Path path2 = this;
        while (path2.remainder != null) {
            pathBuilder.appendKey(path2.first);
            path2 = path2.remainder;
        }
        return pathBuilder.result();
    }

    String last() {
        Path path2 = this;
        while (path2.remainder != null) {
            path2 = path2.remainder;
        }
        return path2.first;
    }

    Path prepend(Path path2) {
        PathBuilder pathBuilder = new PathBuilder();
        pathBuilder.appendPath(path2);
        pathBuilder.appendPath(this);
        return pathBuilder.result();
    }

    int length() {
        int n = 1;
        Path path2 = this.remainder;
        while (path2 != null) {
            ++n;
            path2 = path2.remainder;
        }
        return n;
    }

    Path subPath(int n) {
        Path path2 = this;
        for (int i = n; path2 != null && i > 0; --i) {
            path2 = path2.remainder;
        }
        return path2;
    }

    Path subPath(int n, int n2) {
        if (n2 < n) {
            throw new ConfigException.BugOrBroken("bad call to subPath");
        }
        Path path2 = this.subPath(n);
        PathBuilder pathBuilder = new PathBuilder();
        for (int i = n2 - n; i > 0; --i) {
            pathBuilder.appendKey(path2.first());
            if ((path2 = path2.remainder()) != null) continue;
            throw new ConfigException.BugOrBroken("subPath lastIndex out of range " + n2);
        }
        return pathBuilder.result();
    }

    public boolean equals(Object object) {
        if (object instanceof Path) {
            Path path2 = (Path)object;
            return this.first.equals(path2.first) && ConfigImplUtil.equalsHandlingNull(this.remainder, path2.remainder);
        }
        return false;
    }

    public int hashCode() {
        return 41 * (41 + this.first.hashCode()) + (this.remainder == null ? 0 : this.remainder.hashCode());
    }

    static boolean hasFunkyChars(String string2) {
        int n = string2.length();
        if (n == 0) {
            return false;
        }
        char c2 = string2.charAt(0);
        if (!Character.isLetter(c2)) {
            return true;
        }
        for (int i = 1; i < n; ++i) {
            char c3 = string2.charAt(i);
            if (Character.isLetterOrDigit(c3) || c3 == '-' || c3 == '_') continue;
            return true;
        }
        return false;
    }

    private void appendToStringBuilder(StringBuilder stringBuilder) {
        if (Path.hasFunkyChars(this.first) || this.first.isEmpty()) {
            stringBuilder.append(ConfigImplUtil.renderJsonString(this.first));
        } else {
            stringBuilder.append(this.first);
        }
        if (this.remainder != null) {
            stringBuilder.append(".");
            this.remainder.appendToStringBuilder(stringBuilder);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Path(");
        this.appendToStringBuilder(stringBuilder);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    String render() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendToStringBuilder(stringBuilder);
        return stringBuilder.toString();
    }

    static Path newKey(String string2) {
        return new Path(string2, null);
    }

    static Path newPath(String string2) {
        return Parser.parsePath(string2);
    }
}

