/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.impl.Path;
import java.util.Stack;

final class PathBuilder {
    private final Stack<String> keys = new Stack();
    private Path result;

    PathBuilder() {
    }

    private void checkCanAppend() {
        if (this.result != null) {
            throw new ConfigException.BugOrBroken("Adding to PathBuilder after getting result");
        }
    }

    void appendKey(String string2) {
        this.checkCanAppend();
        this.keys.push(string2);
    }

    void appendPath(Path path2) {
        this.checkCanAppend();
        String string2 = path2.first();
        Path path3 = path2.remainder();
        while (true) {
            this.keys.push(string2);
            if (path3 == null) break;
            string2 = path3.first();
            path3 = path3.remainder();
        }
    }

    Path result() {
        if (this.result == null) {
            Path path2 = null;
            while (!this.keys.isEmpty()) {
                String string2 = this.keys.pop();
                path2 = new Path(string2, path2);
            }
            this.result = path2;
        }
        return this.result;
    }
}

