/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigImpl;
import com.typesafe.config.impl.ConfigString;
import com.typesafe.config.impl.FromMapMode;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SimpleConfigObject;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

final class PropertiesParser {
    PropertiesParser() {
    }

    static AbstractConfigObject parse(Reader reader2, ConfigOrigin configOrigin) throws IOException {
        Properties properties2 = new Properties();
        properties2.load(reader2);
        return PropertiesParser.fromProperties(configOrigin, properties2);
    }

    static String lastElement(String string2) {
        int n = string2.lastIndexOf(46);
        if (n < 0) {
            return string2;
        }
        return string2.substring(n + 1);
    }

    static String exceptLastElement(String string2) {
        int n = string2.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        return string2.substring(0, n);
    }

    static Path pathFromPropertyKey(String string2) {
        String string3 = PropertiesParser.lastElement(string2);
        String string4 = PropertiesParser.exceptLastElement(string2);
        Path path2 = new Path(string3, null);
        while (string4 != null) {
            string3 = PropertiesParser.lastElement(string4);
            string4 = PropertiesParser.exceptLastElement(string4);
            path2 = new Path(string3, path2);
        }
        return path2;
    }

    static AbstractConfigObject fromProperties(ConfigOrigin configOrigin, Properties properties2) {
        HashMap<Path, Object> hashMap = new HashMap<Path, Object>();
        for (Map.Entry<Object, Object> entry2 : properties2.entrySet()) {
            Object object = entry2.getKey();
            if (!(object instanceof String)) continue;
            Path path2 = PropertiesParser.pathFromPropertyKey((String)object);
            hashMap.put(path2, entry2.getValue());
        }
        return PropertiesParser.fromPathMap(configOrigin, hashMap, true);
    }

    static AbstractConfigObject fromPathMap(ConfigOrigin configOrigin, Map<?, ?> map3) {
        HashMap<Path, Object> hashMap = new HashMap<Path, Object>();
        for (Map.Entry<?, ?> entry2 : map3.entrySet()) {
            Object obj = entry2.getKey();
            if (!(obj instanceof String)) {
                throw new ConfigException.BugOrBroken("Map has a non-string as a key, expecting a path expression as a String");
            }
            Path path2 = Path.newPath((String)obj);
            hashMap.put(path2, entry2.getValue());
        }
        return PropertiesParser.fromPathMap(configOrigin, hashMap, false);
    }

    private static AbstractConfigObject fromPathMap(ConfigOrigin configOrigin, Map<Path, Object> map3, boolean bl) {
        AbstractConfigValue abstractConfigValue;
        Object object;
        Object object2;
        HashMap hashMap;
        Object object3;
        Object object4;
        HashSet<Path> hashSet = new HashSet<Path>();
        HashSet<Path> hashSet2 = new HashSet<Path>();
        for (Path object62 : map3.keySet()) {
            hashSet2.add(object62);
            for (object4 = object62.parent(); object4 != null; object4 = ((Path)object4).parent()) {
                hashSet.add((Path)object4);
            }
        }
        if (bl) {
            hashSet2.removeAll(hashSet);
        } else {
            for (Path path2 : hashSet2) {
                if (!hashSet.contains(path2)) continue;
                throw new ConfigException.BugOrBroken("In the map, path '" + path2.render() + "' occurs as both the parent object of a value and as a value. " + "Because Map has no defined ordering, this is a broken situation.");
            }
        }
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        for (Path path3 : hashSet) {
            object3 = new HashMap();
            hashMap3.put(path3, object3);
        }
        for (Path path4 : hashSet2) {
            object3 = path4.parent();
            hashMap = object3 != null ? (Map)hashMap3.get(object3) : hashMap2;
            object2 = path4.last();
            object = map3.get(path4);
            abstractConfigValue = bl ? new ConfigString(configOrigin, (String)object) : ConfigImpl.fromAnyRef(map3.get(path4), configOrigin, FromMapMode.KEYS_ARE_PATHS);
            hashMap.put(object2, abstractConfigValue);
        }
        object4 = new ArrayList();
        object4.addAll(hashSet);
        Collections.sort(object4, new Comparator<Path>(){

            @Override
            public int compare(Path path2, Path path3) {
                return path3.length() - path2.length();
            }
        });
        Iterator iterator2 = object4.iterator();
        while (iterator2.hasNext()) {
            object3 = (Path)iterator2.next();
            hashMap = (Map)hashMap3.get(object3);
            object2 = ((Path)object3).parent();
            object = object2 != null ? (Map)hashMap3.get(object2) : hashMap2;
            abstractConfigValue = new SimpleConfigObject(configOrigin, hashMap, ResolveStatus.RESOLVED, false);
            object.put(((Path)object3).last(), abstractConfigValue);
        }
        return new SimpleConfigObject(configOrigin, hashMap2, ResolveStatus.RESOLVED, false);
    }
}

