/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigImpl;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.ConfigNull;
import com.typesafe.config.impl.ConfigNumber;
import com.typesafe.config.impl.ConfigString;
import com.typesafe.config.impl.DefaultTransformer;
import com.typesafe.config.impl.MergeableValue;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveContext;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SerializedConfigValue;
import com.typesafe.config.impl.SimpleConfigList;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

final class SimpleConfig
implements Config,
MergeableValue,
Serializable {
    private static final long serialVersionUID = 1L;
    private final AbstractConfigObject object;

    SimpleConfig(AbstractConfigObject abstractConfigObject) {
        this.object = abstractConfigObject;
    }

    @Override
    public AbstractConfigObject root() {
        return this.object;
    }

    @Override
    public ConfigOrigin origin() {
        return this.object.origin();
    }

    @Override
    public SimpleConfig resolve() {
        return this.resolve(ConfigResolveOptions.defaults());
    }

    @Override
    public SimpleConfig resolve(ConfigResolveOptions configResolveOptions) {
        AbstractConfigValue abstractConfigValue = ResolveContext.resolve(this.object, this.object, configResolveOptions);
        if (abstractConfigValue == this.object) {
            return this;
        }
        return new SimpleConfig((AbstractConfigObject)abstractConfigValue);
    }

    @Override
    public boolean hasPath(String string2) {
        AbstractConfigValue abstractConfigValue;
        Path path2 = Path.newPath(string2);
        try {
            abstractConfigValue = this.object.peekPath(path2);
        }
        catch (ConfigException.NotResolved notResolved) {
            throw ConfigImpl.improveNotResolved(path2, notResolved);
        }
        return abstractConfigValue != null && abstractConfigValue.valueType() != ConfigValueType.NULL;
    }

    @Override
    public boolean isEmpty() {
        return this.object.isEmpty();
    }

    private static void findPaths(Set<Map.Entry<String, ConfigValue>> set2, Path path2, AbstractConfigObject abstractConfigObject) {
        for (Map.Entry entry2 : abstractConfigObject.entrySet()) {
            String string2 = (String)entry2.getKey();
            ConfigValue configValue = (ConfigValue)entry2.getValue();
            Path path3 = Path.newKey(string2);
            if (path2 != null) {
                path3 = path3.prepend(path2);
            }
            if (configValue instanceof AbstractConfigObject) {
                SimpleConfig.findPaths(set2, path3, (AbstractConfigObject)configValue);
                continue;
            }
            if (configValue instanceof ConfigNull) continue;
            set2.add(new AbstractMap.SimpleImmutableEntry<String, ConfigValue>(path3.render(), configValue));
        }
    }

    @Override
    public Set<Map.Entry<String, ConfigValue>> entrySet() {
        HashSet<Map.Entry<String, ConfigValue>> hashSet = new HashSet<Map.Entry<String, ConfigValue>>();
        SimpleConfig.findPaths(hashSet, null, this.object);
        return hashSet;
    }

    private static AbstractConfigValue findKey(AbstractConfigObject abstractConfigObject, String string2, ConfigValueType configValueType, Path path2) {
        AbstractConfigValue abstractConfigValue = abstractConfigObject.peekAssumingResolved(string2, path2);
        if (abstractConfigValue == null) {
            throw new ConfigException.Missing(path2.render());
        }
        if (configValueType != null) {
            abstractConfigValue = DefaultTransformer.transform(abstractConfigValue, configValueType);
        }
        if (abstractConfigValue.valueType() == ConfigValueType.NULL) {
            throw new ConfigException.Null((ConfigOrigin)abstractConfigValue.origin(), path2.render(), configValueType != null ? configValueType.name() : null);
        }
        if (configValueType != null && abstractConfigValue.valueType() != configValueType) {
            throw new ConfigException.WrongType(abstractConfigValue.origin(), path2.render(), configValueType.name(), abstractConfigValue.valueType().name());
        }
        return abstractConfigValue;
    }

    private static AbstractConfigValue find(AbstractConfigObject abstractConfigObject, Path path2, ConfigValueType configValueType, Path path3) {
        try {
            String string2 = path2.first();
            Path path4 = path2.remainder();
            if (path4 == null) {
                return SimpleConfig.findKey(abstractConfigObject, string2, configValueType, path3);
            }
            AbstractConfigObject abstractConfigObject2 = (AbstractConfigObject)SimpleConfig.findKey(abstractConfigObject, string2, ConfigValueType.OBJECT, path3.subPath(0, path3.length() - path4.length()));
            assert (abstractConfigObject2 != null);
            return SimpleConfig.find(abstractConfigObject2, path4, configValueType, path3);
        }
        catch (ConfigException.NotResolved notResolved) {
            throw ConfigImpl.improveNotResolved(path2, notResolved);
        }
    }

    AbstractConfigValue find(Path path2, ConfigValueType configValueType, Path path3) {
        return SimpleConfig.find(this.object, path2, configValueType, path3);
    }

    AbstractConfigValue find(String string2, ConfigValueType configValueType) {
        Path path2 = Path.newPath(string2);
        return this.find(path2, configValueType, path2);
    }

    @Override
    public AbstractConfigValue getValue(String string2) {
        return this.find(string2, null);
    }

    @Override
    public boolean getBoolean(String string2) {
        AbstractConfigValue abstractConfigValue = this.find(string2, ConfigValueType.BOOLEAN);
        return (Boolean)abstractConfigValue.unwrapped();
    }

    private ConfigNumber getConfigNumber(String string2) {
        AbstractConfigValue abstractConfigValue = this.find(string2, ConfigValueType.NUMBER);
        return (ConfigNumber)abstractConfigValue;
    }

    @Override
    public Number getNumber(String string2) {
        return this.getConfigNumber(string2).unwrapped();
    }

    @Override
    public int getInt(String string2) {
        ConfigNumber configNumber = this.getConfigNumber(string2);
        return configNumber.intValueRangeChecked(string2);
    }

    @Override
    public long getLong(String string2) {
        return this.getNumber(string2).longValue();
    }

    @Override
    public double getDouble(String string2) {
        return this.getNumber(string2).doubleValue();
    }

    @Override
    public String getString(String string2) {
        AbstractConfigValue abstractConfigValue = this.find(string2, ConfigValueType.STRING);
        return (String)abstractConfigValue.unwrapped();
    }

    @Override
    public ConfigList getList(String string2) {
        AbstractConfigValue abstractConfigValue = this.find(string2, ConfigValueType.LIST);
        return (ConfigList)((Object)abstractConfigValue);
    }

    @Override
    public AbstractConfigObject getObject(String string2) {
        AbstractConfigObject abstractConfigObject = (AbstractConfigObject)this.find(string2, ConfigValueType.OBJECT);
        return abstractConfigObject;
    }

    @Override
    public SimpleConfig getConfig(String string2) {
        return this.getObject(string2).toConfig();
    }

    @Override
    public Object getAnyRef(String string2) {
        AbstractConfigValue abstractConfigValue = this.find(string2, null);
        return abstractConfigValue.unwrapped();
    }

    @Override
    public Long getBytes(String string2) {
        Long l = null;
        try {
            l = this.getLong(string2);
        }
        catch (ConfigException.WrongType wrongType) {
            AbstractConfigValue abstractConfigValue = this.find(string2, ConfigValueType.STRING);
            l = SimpleConfig.parseBytes((String)abstractConfigValue.unwrapped(), abstractConfigValue.origin(), string2);
        }
        return l;
    }

    @Override
    public Long getMilliseconds(String string2) {
        long l = this.getNanoseconds(string2);
        long l2 = TimeUnit.NANOSECONDS.toMillis(l);
        return l2;
    }

    @Override
    public Long getNanoseconds(String string2) {
        Long l = null;
        try {
            l = TimeUnit.MILLISECONDS.toNanos(this.getLong(string2));
        }
        catch (ConfigException.WrongType wrongType) {
            AbstractConfigValue abstractConfigValue = this.find(string2, ConfigValueType.STRING);
            l = SimpleConfig.parseDuration((String)abstractConfigValue.unwrapped(), abstractConfigValue.origin(), string2);
        }
        return l;
    }

    private <T> List<T> getHomogeneousUnwrappedList(String string2, ConfigValueType configValueType) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ConfigList configList = this.getList(string2);
        for (ConfigValue configValue : configList) {
            AbstractConfigValue abstractConfigValue = (AbstractConfigValue)configValue;
            if (configValueType != null) {
                abstractConfigValue = DefaultTransformer.transform(abstractConfigValue, configValueType);
            }
            if (abstractConfigValue.valueType() != configValueType) {
                throw new ConfigException.WrongType(abstractConfigValue.origin(), string2, "list of " + configValueType.name(), "list of " + abstractConfigValue.valueType().name());
            }
            arrayList.add(abstractConfigValue.unwrapped());
        }
        return arrayList;
    }

    @Override
    public List<Boolean> getBooleanList(String string2) {
        return this.getHomogeneousUnwrappedList(string2, ConfigValueType.BOOLEAN);
    }

    @Override
    public List<Number> getNumberList(String string2) {
        return this.getHomogeneousUnwrappedList(string2, ConfigValueType.NUMBER);
    }

    @Override
    public List<Integer> getIntList(String string2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        List list2 = this.getHomogeneousWrappedList(string2, ConfigValueType.NUMBER);
        for (AbstractConfigValue abstractConfigValue : list2) {
            arrayList.add(((ConfigNumber)abstractConfigValue).intValueRangeChecked(string2));
        }
        return arrayList;
    }

    @Override
    public List<Long> getLongList(String string2) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        List<Number> list2 = this.getNumberList(string2);
        for (Number number2 : list2) {
            arrayList.add(number2.longValue());
        }
        return arrayList;
    }

    @Override
    public List<Double> getDoubleList(String string2) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        List<Number> list2 = this.getNumberList(string2);
        for (Number number2 : list2) {
            arrayList.add(number2.doubleValue());
        }
        return arrayList;
    }

    @Override
    public List<String> getStringList(String string2) {
        return this.getHomogeneousUnwrappedList(string2, ConfigValueType.STRING);
    }

    private <T extends ConfigValue> List<T> getHomogeneousWrappedList(String string2, ConfigValueType configValueType) {
        ArrayList<AbstractConfigValue> arrayList = new ArrayList<AbstractConfigValue>();
        ConfigList configList = this.getList(string2);
        for (ConfigValue configValue : configList) {
            AbstractConfigValue abstractConfigValue = (AbstractConfigValue)configValue;
            if (configValueType != null) {
                abstractConfigValue = DefaultTransformer.transform(abstractConfigValue, configValueType);
            }
            if (abstractConfigValue.valueType() != configValueType) {
                throw new ConfigException.WrongType(abstractConfigValue.origin(), string2, "list of " + configValueType.name(), "list of " + abstractConfigValue.valueType().name());
            }
            arrayList.add(abstractConfigValue);
        }
        return arrayList;
    }

    public List<ConfigObject> getObjectList(String string2) {
        return this.getHomogeneousWrappedList(string2, ConfigValueType.OBJECT);
    }

    @Override
    public List<? extends Config> getConfigList(String string2) {
        List<ConfigObject> list2 = this.getObjectList(string2);
        ArrayList<Config> arrayList = new ArrayList<Config>();
        for (ConfigObject configObject : list2) {
            arrayList.add(configObject.toConfig());
        }
        return arrayList;
    }

    @Override
    public List<? extends Object> getAnyRefList(String string2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ConfigList configList = this.getList(string2);
        for (ConfigValue configValue : configList) {
            arrayList.add(configValue.unwrapped());
        }
        return arrayList;
    }

    @Override
    public List<Long> getBytesList(String string2) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        ConfigList configList = this.getList(string2);
        for (ConfigValue configValue : configList) {
            if (configValue.valueType() == ConfigValueType.NUMBER) {
                arrayList.add(((Number)configValue.unwrapped()).longValue());
                continue;
            }
            if (configValue.valueType() == ConfigValueType.STRING) {
                String string3 = (String)configValue.unwrapped();
                Long l = SimpleConfig.parseBytes(string3, configValue.origin(), string2);
                arrayList.add(l);
                continue;
            }
            throw new ConfigException.WrongType(configValue.origin(), string2, "memory size string or number of bytes", configValue.valueType().name());
        }
        return arrayList;
    }

    @Override
    public List<Long> getMillisecondsList(String string2) {
        List<Long> list2 = this.getNanosecondsList(string2);
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (Long l : list2) {
            arrayList.add(TimeUnit.NANOSECONDS.toMillis(l));
        }
        return arrayList;
    }

    @Override
    public List<Long> getNanosecondsList(String string2) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        ConfigList configList = this.getList(string2);
        for (ConfigValue configValue : configList) {
            if (configValue.valueType() == ConfigValueType.NUMBER) {
                arrayList.add(TimeUnit.MILLISECONDS.toNanos(((Number)configValue.unwrapped()).longValue()));
                continue;
            }
            if (configValue.valueType() == ConfigValueType.STRING) {
                String string3 = (String)configValue.unwrapped();
                Long l = SimpleConfig.parseDuration(string3, configValue.origin(), string2);
                arrayList.add(l);
                continue;
            }
            throw new ConfigException.WrongType(configValue.origin(), string2, "duration string or number of nanoseconds", configValue.valueType().name());
        }
        return arrayList;
    }

    @Override
    public AbstractConfigObject toFallbackValue() {
        return this.object;
    }

    @Override
    public SimpleConfig withFallback(ConfigMergeable configMergeable) {
        return this.object.withFallback(configMergeable).toConfig();
    }

    public final boolean equals(Object object) {
        if (object instanceof SimpleConfig) {
            return this.object.equals(((SimpleConfig)object).object);
        }
        return false;
    }

    public final int hashCode() {
        return 41 * this.object.hashCode();
    }

    public String toString() {
        return "Config(" + this.object.toString() + ")";
    }

    private static String getUnits(String string2) {
        char c2;
        int n;
        for (n = string2.length() - 1; n >= 0 && Character.isLetter(c2 = string2.charAt(n)); --n) {
        }
        return string2.substring(n + 1);
    }

    public static long parseDuration(String string2, ConfigOrigin configOrigin, String string3) {
        String string4;
        String string5 = ConfigImplUtil.unicodeTrim(string2);
        String string6 = string4 = SimpleConfig.getUnits(string5);
        String string7 = ConfigImplUtil.unicodeTrim(string5.substring(0, string5.length() - string6.length()));
        TimeUnit timeUnit = null;
        if (string7.length() == 0) {
            throw new ConfigException.BadValue(configOrigin, string3, "No number in duration value '" + string2 + "'");
        }
        if (string6.length() > 2 && !string6.endsWith("s")) {
            string6 = string6 + "s";
        }
        if (string6.equals("") || string6.equals("ms") || string6.equals("milliseconds")) {
            timeUnit = TimeUnit.MILLISECONDS;
        } else if (string6.equals("us") || string6.equals("microseconds")) {
            timeUnit = TimeUnit.MICROSECONDS;
        } else if (string6.equals("ns") || string6.equals("nanoseconds")) {
            timeUnit = TimeUnit.NANOSECONDS;
        } else if (string6.equals("d") || string6.equals("days")) {
            timeUnit = TimeUnit.DAYS;
        } else if (string6.equals("h") || string6.equals("hours")) {
            timeUnit = TimeUnit.HOURS;
        } else if (string6.equals("s") || string6.equals("seconds")) {
            timeUnit = TimeUnit.SECONDS;
        } else if (string6.equals("m") || string6.equals("minutes")) {
            timeUnit = TimeUnit.MINUTES;
        } else {
            throw new ConfigException.BadValue(configOrigin, string3, "Could not parse time unit '" + string4 + "' (try ns, us, ms, s, m, d)");
        }
        try {
            if (string7.matches("[0-9]+")) {
                return timeUnit.toNanos(Long.parseLong(string7));
            }
            long l = timeUnit.toNanos(1L);
            return (long)(Double.parseDouble(string7) * (double)l);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigException.BadValue(configOrigin, string3, "Could not parse duration number '" + string7 + "'");
        }
    }

    public static long parseBytes(String string2, ConfigOrigin configOrigin, String string3) {
        String string4 = ConfigImplUtil.unicodeTrim(string2);
        String string5 = SimpleConfig.getUnits(string4);
        String string6 = ConfigImplUtil.unicodeTrim(string4.substring(0, string4.length() - string5.length()));
        if (string6.length() == 0) {
            throw new ConfigException.BadValue(configOrigin, string3, "No number in size-in-bytes value '" + string2 + "'");
        }
        MemoryUnit memoryUnit = MemoryUnit.parseUnit(string5);
        if (memoryUnit == null) {
            throw new ConfigException.BadValue(configOrigin, string3, "Could not parse size-in-bytes unit '" + string5 + "' (try k, K, kB, KiB, kilobytes, kibibytes)");
        }
        try {
            if (string6.matches("[0-9]+")) {
                return Long.parseLong(string6) * memoryUnit.bytes;
            }
            return (long)(Double.parseDouble(string6) * (double)memoryUnit.bytes);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigException.BadValue(configOrigin, string3, "Could not parse size-in-bytes number '" + string6 + "'");
        }
    }

    private AbstractConfigValue peekPath(Path path2) {
        return this.root().peekPath(path2);
    }

    private static void addProblem(List<ConfigException.ValidationProblem> list2, Path path2, ConfigOrigin configOrigin, String string2) {
        list2.add(new ConfigException.ValidationProblem(path2.render(), configOrigin, string2));
    }

    private static String getDesc(ConfigValue configValue) {
        if (configValue instanceof AbstractConfigObject) {
            AbstractConfigObject abstractConfigObject = (AbstractConfigObject)configValue;
            if (abstractConfigObject.isEmpty()) {
                return "object";
            }
            return "object with keys " + abstractConfigObject.keySet();
        }
        if (configValue instanceof SimpleConfigList) {
            return "list";
        }
        return configValue.valueType().name().toLowerCase();
    }

    private static void addMissing(List<ConfigException.ValidationProblem> list2, ConfigValue configValue, Path path2, ConfigOrigin configOrigin) {
        SimpleConfig.addProblem(list2, path2, configOrigin, "No setting at '" + path2.render() + "', expecting: " + SimpleConfig.getDesc(configValue));
    }

    private static void addWrongType(List<ConfigException.ValidationProblem> list2, ConfigValue configValue, AbstractConfigValue abstractConfigValue, Path path2) {
        SimpleConfig.addProblem(list2, path2, abstractConfigValue.origin(), "Wrong value type at '" + path2.render() + "', expecting: " + SimpleConfig.getDesc(configValue) + " but got: " + SimpleConfig.getDesc(abstractConfigValue));
    }

    private static boolean couldBeNull(AbstractConfigValue abstractConfigValue) {
        return DefaultTransformer.transform(abstractConfigValue, ConfigValueType.NULL).valueType() == ConfigValueType.NULL;
    }

    private static boolean haveCompatibleTypes(ConfigValue configValue, AbstractConfigValue abstractConfigValue) {
        if (SimpleConfig.couldBeNull((AbstractConfigValue)configValue) || SimpleConfig.couldBeNull(abstractConfigValue)) {
            return true;
        }
        if (configValue instanceof AbstractConfigObject) {
            return abstractConfigValue instanceof AbstractConfigObject;
        }
        if (configValue instanceof SimpleConfigList) {
            return abstractConfigValue instanceof SimpleConfigList;
        }
        if (configValue instanceof ConfigString) {
            return true;
        }
        if (abstractConfigValue instanceof ConfigString) {
            return true;
        }
        return configValue.valueType() == abstractConfigValue.valueType();
    }

    private static void checkValidObject(Path path2, AbstractConfigObject abstractConfigObject, AbstractConfigObject abstractConfigObject2, List<ConfigException.ValidationProblem> list2) {
        for (Map.Entry entry2 : abstractConfigObject.entrySet()) {
            String string2 = (String)entry2.getKey();
            Path path3 = path2 != null ? Path.newKey(string2).prepend(path2) : Path.newKey(string2);
            AbstractConfigValue abstractConfigValue = abstractConfigObject2.get(string2);
            if (abstractConfigValue == null) {
                SimpleConfig.addMissing(list2, (ConfigValue)entry2.getValue(), path3, abstractConfigObject2.origin());
                continue;
            }
            SimpleConfig.checkValid(path3, (ConfigValue)entry2.getValue(), abstractConfigValue, list2);
        }
    }

    private static void checkValid(Path path2, ConfigValue configValue, AbstractConfigValue abstractConfigValue, List<ConfigException.ValidationProblem> list2) {
        if (SimpleConfig.haveCompatibleTypes(configValue, abstractConfigValue)) {
            if (configValue instanceof AbstractConfigObject && abstractConfigValue instanceof AbstractConfigObject) {
                SimpleConfig.checkValidObject(path2, (AbstractConfigObject)configValue, (AbstractConfigObject)abstractConfigValue, list2);
            } else if (configValue instanceof SimpleConfigList && abstractConfigValue instanceof SimpleConfigList) {
                SimpleConfigList simpleConfigList = (SimpleConfigList)configValue;
                SimpleConfigList simpleConfigList2 = (SimpleConfigList)abstractConfigValue;
                if (!simpleConfigList.isEmpty() && !simpleConfigList2.isEmpty()) {
                    AbstractConfigValue abstractConfigValue2 = simpleConfigList.get(0);
                    for (ConfigValue configValue2 : simpleConfigList2) {
                        AbstractConfigValue abstractConfigValue3 = (AbstractConfigValue)configValue2;
                        if (SimpleConfig.haveCompatibleTypes(abstractConfigValue2, abstractConfigValue3)) continue;
                        SimpleConfig.addProblem(list2, path2, abstractConfigValue3.origin(), "List at '" + path2.render() + "' contains wrong value type, expecting list of " + SimpleConfig.getDesc(abstractConfigValue2) + " but got element of type " + SimpleConfig.getDesc(abstractConfigValue3));
                        break;
                    }
                }
            }
        } else {
            SimpleConfig.addWrongType(list2, configValue, abstractConfigValue, path2);
        }
    }

    @Override
    public void checkValid(Config config, String ... stringArray) {
        SimpleConfig simpleConfig = (SimpleConfig)config;
        if (simpleConfig.root().resolveStatus() != ResolveStatus.RESOLVED) {
            throw new ConfigException.BugOrBroken("do not call checkValid() with an unresolved reference config, call Config#resolve(), see Config#resolve() API docs");
        }
        if (this.root().resolveStatus() != ResolveStatus.RESOLVED) {
            throw new ConfigException.NotResolved("need to Config#resolve() each config before using it, see the API docs for Config#resolve()");
        }
        ArrayList<ConfigException.ValidationProblem> arrayList = new ArrayList<ConfigException.ValidationProblem>();
        if (stringArray.length == 0) {
            SimpleConfig.checkValidObject(null, simpleConfig.root(), this.root(), arrayList);
        } else {
            for (String string2 : stringArray) {
                Path path2 = Path.newPath(string2);
                AbstractConfigValue abstractConfigValue = simpleConfig.peekPath(path2);
                if (abstractConfigValue == null) continue;
                AbstractConfigValue abstractConfigValue2 = this.peekPath(path2);
                if (abstractConfigValue2 != null) {
                    SimpleConfig.checkValid(path2, abstractConfigValue, abstractConfigValue2, arrayList);
                    continue;
                }
                SimpleConfig.addMissing(arrayList, abstractConfigValue, path2, this.origin());
            }
        }
        if (!arrayList.isEmpty()) {
            throw new ConfigException.ValidationFailed(arrayList);
        }
    }

    @Override
    public SimpleConfig withOnlyPath(String string2) {
        Path path2 = Path.newPath(string2);
        return new SimpleConfig(this.root().withOnlyPath(path2));
    }

    @Override
    public SimpleConfig withoutPath(String string2) {
        Path path2 = Path.newPath(string2);
        return new SimpleConfig(this.root().withoutPath(path2));
    }

    @Override
    public SimpleConfig withValue(String string2, ConfigValue configValue) {
        Path path2 = Path.newPath(string2);
        return new SimpleConfig(this.root().withValue(path2, configValue));
    }

    SimpleConfig atKey(ConfigOrigin configOrigin, String string2) {
        return this.root().atKey(configOrigin, string2);
    }

    @Override
    public SimpleConfig atKey(String string2) {
        return this.root().atKey(string2);
    }

    @Override
    public Config atPath(String string2) {
        return this.root().atPath(string2);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializedConfigValue(this);
    }

    private static enum MemoryUnit {
        BYTES("", 1024, 0),
        KILOBYTES("kilo", 1000, 1),
        MEGABYTES("mega", 1000, 2),
        GIGABYTES("giga", 1000, 3),
        TERABYTES("tera", 1000, 4),
        PETABYTES("peta", 1000, 5),
        EXABYTES("exa", 1000, 6),
        ZETTABYTES("zetta", 1000, 7),
        YOTTABYTES("yotta", 1000, 8),
        KIBIBYTES("kibi", 1024, 1),
        MEBIBYTES("mebi", 1024, 2),
        GIBIBYTES("gibi", 1024, 3),
        TEBIBYTES("tebi", 1024, 4),
        PEBIBYTES("pebi", 1024, 5),
        EXBIBYTES("exbi", 1024, 6),
        ZEBIBYTES("zebi", 1024, 7),
        YOBIBYTES("yobi", 1024, 8);

        final String prefix;
        final int powerOf;
        final int power;
        final long bytes;
        private static Map<String, MemoryUnit> unitsMap;

        private MemoryUnit(String string3, int n2, int n3) {
            this.prefix = string3;
            this.powerOf = n2;
            this.power = n3;
            long l = 1L;
            for (int i = n3; i > 0; --i) {
                l *= (long)n2;
            }
            this.bytes = l;
        }

        private static Map<String, MemoryUnit> makeUnitsMap() {
            HashMap<String, MemoryUnit> hashMap = new HashMap<String, MemoryUnit>();
            for (MemoryUnit memoryUnit : MemoryUnit.values()) {
                hashMap.put(memoryUnit.prefix + "byte", memoryUnit);
                hashMap.put(memoryUnit.prefix + "bytes", memoryUnit);
                if (memoryUnit.prefix.length() == 0) {
                    hashMap.put("b", memoryUnit);
                    hashMap.put("B", memoryUnit);
                    hashMap.put("", memoryUnit);
                    continue;
                }
                String string2 = memoryUnit.prefix.substring(0, 1);
                String string3 = string2.toUpperCase();
                if (memoryUnit.powerOf == 1024) {
                    hashMap.put(string2, memoryUnit);
                    hashMap.put(string3, memoryUnit);
                    hashMap.put(string3 + "i", memoryUnit);
                    hashMap.put(string3 + "iB", memoryUnit);
                    continue;
                }
                if (memoryUnit.powerOf == 1000) {
                    if (memoryUnit.power == 1) {
                        hashMap.put(string2 + "B", memoryUnit);
                        continue;
                    }
                    hashMap.put(string3 + "B", memoryUnit);
                    continue;
                }
                throw new RuntimeException("broken MemoryUnit enum");
            }
            return hashMap;
        }

        static MemoryUnit parseUnit(String string2) {
            return unitsMap.get(string2);
        }

        static {
            unitsMap = MemoryUnit.makeUnitsMap();
        }
    }
}

