/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigIncludeContext;
import com.typesafe.config.ConfigIncluder;
import com.typesafe.config.ConfigIncluderClasspath;
import com.typesafe.config.ConfigIncluderFile;
import com.typesafe.config.ConfigIncluderURL;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigParseable;
import com.typesafe.config.ConfigSyntax;
import com.typesafe.config.impl.FullIncluder;
import com.typesafe.config.impl.Parseable;
import com.typesafe.config.impl.SimpleConfigObject;
import com.typesafe.config.impl.SimpleConfigOrigin;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

class SimpleIncluder
implements FullIncluder {
    private ConfigIncluder fallback;

    SimpleIncluder(ConfigIncluder configIncluder) {
        this.fallback = configIncluder;
    }

    static ConfigParseOptions clearForInclude(ConfigParseOptions configParseOptions) {
        return configParseOptions.setSyntax(null).setOriginDescription(null).setAllowMissing(true);
    }

    @Override
    public ConfigObject include(ConfigIncludeContext configIncludeContext, String string2) {
        ConfigObject configObject = SimpleIncluder.includeWithoutFallback(configIncludeContext, string2);
        if (this.fallback != null) {
            return configObject.withFallback(this.fallback.include(configIncludeContext, string2));
        }
        return configObject;
    }

    static ConfigObject includeWithoutFallback(ConfigIncludeContext configIncludeContext, String string2) {
        URL uRL;
        try {
            uRL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
        }
        if (uRL != null) {
            return SimpleIncluder.includeURLWithoutFallback(configIncludeContext, uRL);
        }
        RelativeNameSource relativeNameSource = new RelativeNameSource(configIncludeContext);
        return SimpleIncluder.fromBasename(relativeNameSource, string2, configIncludeContext.parseOptions());
    }

    @Override
    public ConfigObject includeURL(ConfigIncludeContext configIncludeContext, URL uRL) {
        ConfigObject configObject = SimpleIncluder.includeURLWithoutFallback(configIncludeContext, uRL);
        if (this.fallback != null && this.fallback instanceof ConfigIncluderURL) {
            return configObject.withFallback(((ConfigIncluderURL)((Object)this.fallback)).includeURL(configIncludeContext, uRL));
        }
        return configObject;
    }

    static ConfigObject includeURLWithoutFallback(ConfigIncludeContext configIncludeContext, URL uRL) {
        return ConfigFactory.parseURL(uRL, configIncludeContext.parseOptions()).root();
    }

    @Override
    public ConfigObject includeFile(ConfigIncludeContext configIncludeContext, File file) {
        ConfigObject configObject = SimpleIncluder.includeFileWithoutFallback(configIncludeContext, file);
        if (this.fallback != null && this.fallback instanceof ConfigIncluderFile) {
            return configObject.withFallback(((ConfigIncluderFile)((Object)this.fallback)).includeFile(configIncludeContext, file));
        }
        return configObject;
    }

    static ConfigObject includeFileWithoutFallback(ConfigIncludeContext configIncludeContext, File file) {
        return ConfigFactory.parseFileAnySyntax(file, configIncludeContext.parseOptions()).root();
    }

    @Override
    public ConfigObject includeResources(ConfigIncludeContext configIncludeContext, String string2) {
        ConfigObject configObject = SimpleIncluder.includeResourceWithoutFallback(configIncludeContext, string2);
        if (this.fallback != null && this.fallback instanceof ConfigIncluderClasspath) {
            return configObject.withFallback(((ConfigIncluderClasspath)((Object)this.fallback)).includeResources(configIncludeContext, string2));
        }
        return configObject;
    }

    static ConfigObject includeResourceWithoutFallback(ConfigIncludeContext configIncludeContext, String string2) {
        return ConfigFactory.parseResourcesAnySyntax(string2, configIncludeContext.parseOptions()).root();
    }

    @Override
    public ConfigIncluder withFallback(ConfigIncluder configIncluder) {
        if (this == configIncluder) {
            throw new ConfigException.BugOrBroken("trying to create includer cycle");
        }
        if (this.fallback == configIncluder) {
            return this;
        }
        if (this.fallback != null) {
            return new SimpleIncluder(this.fallback.withFallback(configIncluder));
        }
        return new SimpleIncluder(configIncluder);
    }

    static ConfigObject fromBasename(NameSource nameSource, String string2, ConfigParseOptions configParseOptions) {
        ConfigObject configObject;
        if (string2.endsWith(".conf") || string2.endsWith(".json") || string2.endsWith(".properties")) {
            ConfigParseable configParseable = nameSource.nameToParseable(string2, configParseOptions);
            configObject = configParseable.parse(configParseable.options().setAllowMissing(configParseOptions.getAllowMissing()));
        } else {
            Object object;
            ConfigParseable configParseable = nameSource.nameToParseable(string2 + ".conf", configParseOptions);
            ConfigParseable configParseable2 = nameSource.nameToParseable(string2 + ".json", configParseOptions);
            ConfigParseable configParseable3 = nameSource.nameToParseable(string2 + ".properties", configParseOptions);
            boolean bl = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            ConfigSyntax configSyntax = configParseOptions.getSyntax();
            configObject = SimpleConfigObject.empty(SimpleConfigOrigin.newSimple(string2));
            if (configSyntax == null || configSyntax == ConfigSyntax.CONF) {
                try {
                    configObject = configParseable.parse(configParseable.options().setAllowMissing(false).setSyntax(ConfigSyntax.CONF));
                    bl = true;
                }
                catch (ConfigException.IO iO) {
                    arrayList.add(iO.getMessage());
                }
            }
            if (configSyntax == null || configSyntax == ConfigSyntax.JSON) {
                try {
                    object = configParseable2.parse(configParseable2.options().setAllowMissing(false).setSyntax(ConfigSyntax.JSON));
                    configObject = configObject.withFallback((ConfigMergeable)object);
                    bl = true;
                }
                catch (ConfigException.IO iO) {
                    arrayList.add(iO.getMessage());
                }
            }
            if (configSyntax == null || configSyntax == ConfigSyntax.PROPERTIES) {
                try {
                    object = configParseable3.parse(configParseable3.options().setAllowMissing(false).setSyntax(ConfigSyntax.PROPERTIES));
                    configObject = configObject.withFallback((ConfigMergeable)object);
                    bl = true;
                }
                catch (ConfigException.IO iO) {
                    arrayList.add(iO.getMessage());
                }
            }
            if (!configParseOptions.getAllowMissing() && !bl) {
                if (arrayList.isEmpty()) {
                    throw new ConfigException.BugOrBroken("should not be reached: nothing found but no exceptions thrown");
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (String string3 : arrayList) {
                    stringBuilder.append(string3);
                    stringBuilder.append(", ");
                }
                stringBuilder.setLength(stringBuilder.length() - 2);
                object = stringBuilder.toString();
                throw new ConfigException.IO(SimpleConfigOrigin.newSimple(string2), (String)object);
            }
        }
        return configObject;
    }

    static FullIncluder makeFull(ConfigIncluder configIncluder) {
        if (configIncluder instanceof FullIncluder) {
            return (FullIncluder)configIncluder;
        }
        return new Proxy(configIncluder);
    }

    private static class Proxy
    implements FullIncluder {
        final ConfigIncluder delegate;

        Proxy(ConfigIncluder configIncluder) {
            this.delegate = configIncluder;
        }

        @Override
        public ConfigIncluder withFallback(ConfigIncluder configIncluder) {
            return this;
        }

        @Override
        public ConfigObject include(ConfigIncludeContext configIncludeContext, String string2) {
            return this.delegate.include(configIncludeContext, string2);
        }

        @Override
        public ConfigObject includeResources(ConfigIncludeContext configIncludeContext, String string2) {
            if (this.delegate instanceof ConfigIncluderClasspath) {
                return ((ConfigIncluderClasspath)((Object)this.delegate)).includeResources(configIncludeContext, string2);
            }
            return SimpleIncluder.includeResourceWithoutFallback(configIncludeContext, string2);
        }

        @Override
        public ConfigObject includeURL(ConfigIncludeContext configIncludeContext, URL uRL) {
            if (this.delegate instanceof ConfigIncluderURL) {
                return ((ConfigIncluderURL)((Object)this.delegate)).includeURL(configIncludeContext, uRL);
            }
            return SimpleIncluder.includeURLWithoutFallback(configIncludeContext, uRL);
        }

        @Override
        public ConfigObject includeFile(ConfigIncludeContext configIncludeContext, File file) {
            if (this.delegate instanceof ConfigIncluderFile) {
                return ((ConfigIncluderFile)((Object)this.delegate)).includeFile(configIncludeContext, file);
            }
            return SimpleIncluder.includeFileWithoutFallback(configIncludeContext, file);
        }
    }

    private static class RelativeNameSource
    implements NameSource {
        private final ConfigIncludeContext context;

        RelativeNameSource(ConfigIncludeContext configIncludeContext) {
            this.context = configIncludeContext;
        }

        @Override
        public ConfigParseable nameToParseable(String string2, ConfigParseOptions configParseOptions) {
            ConfigParseable configParseable = this.context.relativeTo(string2);
            if (configParseable == null) {
                return Parseable.newNotFound(string2, "include was not found: '" + string2 + "'", configParseOptions);
            }
            return configParseable;
        }
    }

    static interface NameSource {
        public ConfigParseable nameToParseable(String var1, ConfigParseOptions var2);
    }
}

