/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigBoolean;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.ConfigNull;
import com.typesafe.config.impl.ConfigNumber;
import com.typesafe.config.impl.ConfigString;
import com.typesafe.config.impl.Token;
import com.typesafe.config.impl.TokenType;
import java.util.List;

final class Tokens {
    static final Token START = Token.newWithoutOrigin(TokenType.START, "start of file");
    static final Token END = Token.newWithoutOrigin(TokenType.END, "end of file");
    static final Token COMMA = Token.newWithoutOrigin(TokenType.COMMA, "','");
    static final Token EQUALS = Token.newWithoutOrigin(TokenType.EQUALS, "'='");
    static final Token COLON = Token.newWithoutOrigin(TokenType.COLON, "':'");
    static final Token OPEN_CURLY = Token.newWithoutOrigin(TokenType.OPEN_CURLY, "'{'");
    static final Token CLOSE_CURLY = Token.newWithoutOrigin(TokenType.CLOSE_CURLY, "'}'");
    static final Token OPEN_SQUARE = Token.newWithoutOrigin(TokenType.OPEN_SQUARE, "'['");
    static final Token CLOSE_SQUARE = Token.newWithoutOrigin(TokenType.CLOSE_SQUARE, "']'");
    static final Token PLUS_EQUALS = Token.newWithoutOrigin(TokenType.PLUS_EQUALS, "'+='");

    Tokens() {
    }

    static boolean isValue(Token token2) {
        return token2 instanceof Value;
    }

    static AbstractConfigValue getValue(Token token2) {
        if (token2 instanceof Value) {
            return ((Value)token2).value();
        }
        throw new ConfigException.BugOrBroken("tried to get value of non-value token " + token2);
    }

    static boolean isValueWithType(Token token2, ConfigValueType configValueType) {
        return Tokens.isValue(token2) && Tokens.getValue(token2).valueType() == configValueType;
    }

    static boolean isNewline(Token token2) {
        return token2 instanceof Line;
    }

    static boolean isProblem(Token token2) {
        return token2 instanceof Problem;
    }

    static String getProblemWhat(Token token2) {
        if (token2 instanceof Problem) {
            return ((Problem)token2).what();
        }
        throw new ConfigException.BugOrBroken("tried to get problem what from " + token2);
    }

    static String getProblemMessage(Token token2) {
        if (token2 instanceof Problem) {
            return ((Problem)token2).message();
        }
        throw new ConfigException.BugOrBroken("tried to get problem message from " + token2);
    }

    static boolean getProblemSuggestQuotes(Token token2) {
        if (token2 instanceof Problem) {
            return ((Problem)token2).suggestQuotes();
        }
        throw new ConfigException.BugOrBroken("tried to get problem suggestQuotes from " + token2);
    }

    static Throwable getProblemCause(Token token2) {
        if (token2 instanceof Problem) {
            return ((Problem)token2).cause();
        }
        throw new ConfigException.BugOrBroken("tried to get problem cause from " + token2);
    }

    static boolean isComment(Token token2) {
        return token2 instanceof Comment;
    }

    static String getCommentText(Token token2) {
        if (token2 instanceof Comment) {
            return ((Comment)token2).text();
        }
        throw new ConfigException.BugOrBroken("tried to get comment text from " + token2);
    }

    static boolean isUnquotedText(Token token2) {
        return token2 instanceof UnquotedText;
    }

    static String getUnquotedText(Token token2) {
        if (token2 instanceof UnquotedText) {
            return ((UnquotedText)token2).value();
        }
        throw new ConfigException.BugOrBroken("tried to get unquoted text from " + token2);
    }

    static boolean isSubstitution(Token token2) {
        return token2 instanceof Substitution;
    }

    static List<Token> getSubstitutionPathExpression(Token token2) {
        if (token2 instanceof Substitution) {
            return ((Substitution)token2).value();
        }
        throw new ConfigException.BugOrBroken("tried to get substitution from " + token2);
    }

    static boolean getSubstitutionOptional(Token token2) {
        if (token2 instanceof Substitution) {
            return ((Substitution)token2).optional();
        }
        throw new ConfigException.BugOrBroken("tried to get substitution optionality from " + token2);
    }

    static Token newLine(ConfigOrigin configOrigin) {
        return new Line(configOrigin);
    }

    static Token newProblem(ConfigOrigin configOrigin, String string2, String string3, boolean bl, Throwable throwable2) {
        return new Problem(configOrigin, string2, string3, bl, throwable2);
    }

    static Token newComment(ConfigOrigin configOrigin, String string2) {
        return new Comment(configOrigin, string2);
    }

    static Token newUnquotedText(ConfigOrigin configOrigin, String string2) {
        return new UnquotedText(configOrigin, string2);
    }

    static Token newSubstitution(ConfigOrigin configOrigin, boolean bl, List<Token> list2) {
        return new Substitution(configOrigin, bl, list2);
    }

    static Token newValue(AbstractConfigValue abstractConfigValue) {
        return new Value(abstractConfigValue);
    }

    static Token newString(ConfigOrigin configOrigin, String string2) {
        return Tokens.newValue(new ConfigString(configOrigin, string2));
    }

    static Token newInt(ConfigOrigin configOrigin, int n, String string2) {
        return Tokens.newValue(ConfigNumber.newNumber(configOrigin, n, string2));
    }

    static Token newDouble(ConfigOrigin configOrigin, double d, String string2) {
        return Tokens.newValue(ConfigNumber.newNumber(configOrigin, d, string2));
    }

    static Token newLong(ConfigOrigin configOrigin, long l, String string2) {
        return Tokens.newValue(ConfigNumber.newNumber(configOrigin, l, string2));
    }

    static Token newNull(ConfigOrigin configOrigin) {
        return Tokens.newValue(new ConfigNull(configOrigin));
    }

    static Token newBoolean(ConfigOrigin configOrigin, boolean bl) {
        return Tokens.newValue(new ConfigBoolean(configOrigin, bl));
    }

    private static class Substitution
    extends Token {
        private final boolean optional;
        private final List<Token> value;

        Substitution(ConfigOrigin configOrigin, boolean bl, List<Token> list2) {
            super(TokenType.SUBSTITUTION, configOrigin);
            this.optional = bl;
            this.value = list2;
        }

        boolean optional() {
            return this.optional;
        }

        List<Token> value() {
            return this.value;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (Token token2 : this.value) {
                stringBuilder.append(token2.toString());
            }
            return "'${" + stringBuilder.toString() + "}'";
        }

        @Override
        protected boolean canEqual(Object object) {
            return object instanceof Substitution;
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object) && ((Object)((Substitution)object).value).equals(this.value);
        }

        @Override
        public int hashCode() {
            return 41 * (41 + super.hashCode()) + ((Object)this.value).hashCode();
        }
    }

    private static class Comment
    extends Token {
        private final String text;

        Comment(ConfigOrigin configOrigin, String string2) {
            super(TokenType.COMMENT, configOrigin);
            this.text = string2;
        }

        String text() {
            return this.text;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("'#");
            stringBuilder.append(this.text);
            stringBuilder.append("' (COMMENT)");
            return stringBuilder.toString();
        }

        @Override
        protected boolean canEqual(Object object) {
            return object instanceof Comment;
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object) && ((Comment)object).text.equals(this.text);
        }

        @Override
        public int hashCode() {
            int n = 41 * (41 + super.hashCode());
            n = 41 * (n + this.text.hashCode());
            return n;
        }
    }

    private static class Problem
    extends Token {
        private final String what;
        private final String message;
        private final boolean suggestQuotes;
        private final Throwable cause;

        Problem(ConfigOrigin configOrigin, String string2, String string3, boolean bl, Throwable throwable2) {
            super(TokenType.PROBLEM, configOrigin);
            this.what = string2;
            this.message = string3;
            this.suggestQuotes = bl;
            this.cause = throwable2;
        }

        String what() {
            return this.what;
        }

        String message() {
            return this.message;
        }

        boolean suggestQuotes() {
            return this.suggestQuotes;
        }

        Throwable cause() {
            return this.cause;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('\'');
            stringBuilder.append(this.what);
            stringBuilder.append('\'');
            stringBuilder.append(" (");
            stringBuilder.append(this.message);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        @Override
        protected boolean canEqual(Object object) {
            return object instanceof Problem;
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object) && ((Problem)object).what.equals(this.what) && ((Problem)object).message.equals(this.message) && ((Problem)object).suggestQuotes == this.suggestQuotes && ConfigImplUtil.equalsHandlingNull(((Problem)object).cause, this.cause);
        }

        @Override
        public int hashCode() {
            int n = 41 * (41 + super.hashCode());
            n = 41 * (n + this.what.hashCode());
            n = 41 * (n + this.message.hashCode());
            n = 41 * (n + Boolean.valueOf(this.suggestQuotes).hashCode());
            if (this.cause != null) {
                n = 41 * (n + this.cause.hashCode());
            }
            return n;
        }
    }

    private static class UnquotedText
    extends Token {
        private final String value;

        UnquotedText(ConfigOrigin configOrigin, String string2) {
            super(TokenType.UNQUOTED_TEXT, configOrigin);
            this.value = string2;
        }

        String value() {
            return this.value;
        }

        @Override
        public String toString() {
            return "'" + this.value + "'";
        }

        @Override
        protected boolean canEqual(Object object) {
            return object instanceof UnquotedText;
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object) && ((UnquotedText)object).value.equals(this.value);
        }

        @Override
        public int hashCode() {
            return 41 * (41 + super.hashCode()) + this.value.hashCode();
        }
    }

    private static class Line
    extends Token {
        Line(ConfigOrigin configOrigin) {
            super(TokenType.NEWLINE, configOrigin);
        }

        @Override
        public String toString() {
            return "'\\n'@" + this.lineNumber();
        }

        @Override
        protected boolean canEqual(Object object) {
            return object instanceof Line;
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object) && ((Line)object).lineNumber() == this.lineNumber();
        }

        @Override
        public int hashCode() {
            return 41 * (41 + super.hashCode()) + this.lineNumber();
        }
    }

    private static class Value
    extends Token {
        private final AbstractConfigValue value;

        Value(AbstractConfigValue abstractConfigValue) {
            super(TokenType.VALUE, abstractConfigValue.origin());
            this.value = abstractConfigValue;
        }

        AbstractConfigValue value() {
            return this.value;
        }

        @Override
        public String toString() {
            return "'" + this.value().unwrapped() + "' (" + this.value.valueType().name() + ")";
        }

        @Override
        protected boolean canEqual(Object object) {
            return object instanceof Value;
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object) && ((Value)object).value.equals(this.value);
        }

        @Override
        public int hashCode() {
            return 41 * (41 + super.hashCode()) + this.value.hashCode();
        }
    }
}

