/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.io.Serializable;
import java.util.Hashtable;

public class Flags
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 6243590407214169028L;
    private int system_flags;
    private final Hashtable user_flags;

    public Flags() {
        this.user_flags = new Hashtable();
    }

    public Flags(Flag flag) {
        this.system_flags = flag.mask;
        this.user_flags = new Hashtable();
    }

    public Flags(Flags flags2) {
        this.system_flags = flags2.system_flags;
        this.user_flags = new Hashtable(flags2.user_flags);
    }

    public Flags(String name) {
        this.user_flags = new Hashtable();
        this.user_flags.put(name.toLowerCase(), name);
    }

    public void add(Flag flag) {
        this.system_flags |= flag.mask;
    }

    public void add(Flags flags2) {
        this.system_flags |= flags2.system_flags;
        this.user_flags.putAll(flags2.user_flags);
    }

    public void add(String name) {
        this.user_flags.put(name.toLowerCase(), name);
    }

    public Object clone() {
        return new Flags(this);
    }

    public boolean contains(Flag flag) {
        return (this.system_flags & flag.mask) != 0;
    }

    public boolean contains(Flags flags2) {
        return (this.system_flags & flags2.system_flags) == flags2.system_flags && this.user_flags.keySet().containsAll(flags2.user_flags.keySet());
    }

    public boolean contains(String name) {
        return this.user_flags.containsKey(name.toLowerCase());
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Flags)) {
            return false;
        }
        Flags flags2 = (Flags)other;
        return this.system_flags == flags2.system_flags && ((Object)this.user_flags.keySet()).equals(flags2.user_flags.keySet());
    }

    public int hashCode() {
        return this.system_flags ^ ((Object)this.user_flags.keySet()).hashCode();
    }

    public Flag[] getSystemFlags() {
        int size2 = 0;
        if ((this.system_flags & Flag.ANSWERED.mask) != 0) {
            ++size2;
        }
        if ((this.system_flags & Flag.DELETED.mask) != 0) {
            ++size2;
        }
        if ((this.system_flags & Flag.DRAFT.mask) != 0) {
            ++size2;
        }
        if ((this.system_flags & Flag.FLAGGED.mask) != 0) {
            ++size2;
        }
        if ((this.system_flags & Flag.RECENT.mask) != 0) {
            ++size2;
        }
        if ((this.system_flags & Flag.SEEN.mask) != 0) {
            ++size2;
        }
        if ((this.system_flags & Flag.USER.mask) != 0) {
            ++size2;
        }
        Flag[] result2 = new Flag[size2];
        if ((this.system_flags & Flag.USER.mask) != 0) {
            result2[--size2] = Flag.USER;
        }
        if ((this.system_flags & Flag.SEEN.mask) != 0) {
            result2[--size2] = Flag.SEEN;
        }
        if ((this.system_flags & Flag.RECENT.mask) != 0) {
            result2[--size2] = Flag.RECENT;
        }
        if ((this.system_flags & Flag.FLAGGED.mask) != 0) {
            result2[--size2] = Flag.FLAGGED;
        }
        if ((this.system_flags & Flag.DRAFT.mask) != 0) {
            result2[--size2] = Flag.DRAFT;
        }
        if ((this.system_flags & Flag.DELETED.mask) != 0) {
            result2[--size2] = Flag.DELETED;
        }
        if ((this.system_flags & Flag.ANSWERED.mask) != 0) {
            result2[--size2] = Flag.ANSWERED;
        }
        return result2;
    }

    public String[] getUserFlags() {
        return this.user_flags.values().toArray(new String[this.user_flags.values().size()]);
    }

    public void remove(Flag flag) {
        this.system_flags &= ~flag.mask;
    }

    public void remove(Flags flags2) {
        this.system_flags &= ~flags2.system_flags;
        this.user_flags.keySet().removeAll(flags2.user_flags.keySet());
    }

    public void remove(String name) {
        this.user_flags.remove(name.toLowerCase());
    }

    public static final class Flag {
        public static final Flag ANSWERED = new Flag(1);
        public static final Flag DELETED = new Flag(2);
        public static final Flag DRAFT = new Flag(4);
        public static final Flag FLAGGED = new Flag(8);
        public static final Flag RECENT = new Flag(16);
        public static final Flag SEEN = new Flag(32);
        public static final Flag USER = new Flag(Integer.MIN_VALUE);
        private final int mask;

        private Flag(int mask) {
            this.mask = mask;
        }
    }
}

