/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.MultipartDataSource;
import javax.mail.Part;

public abstract class Multipart {
    protected Vector parts = new Vector();
    protected String contentType = "multipart/mixed";
    protected Part parent;

    protected Multipart() {
    }

    protected void setMultipartDataSource(MultipartDataSource mds) throws MessagingException {
        this.parts.clear();
        this.contentType = mds.getContentType();
        int size2 = mds.getCount();
        for (int i = 0; i < size2; ++i) {
            this.parts.add(mds.getBodyPart(i));
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getCount() throws MessagingException {
        return this.parts.size();
    }

    public BodyPart getBodyPart(int index2) throws MessagingException {
        return (BodyPart)this.parts.get(index2);
    }

    public boolean removeBodyPart(BodyPart part) throws MessagingException {
        return this.parts.remove(part);
    }

    public void removeBodyPart(int index2) throws MessagingException {
        this.parts.remove(index2);
    }

    public void addBodyPart(BodyPart part) throws MessagingException {
        this.parts.add(part);
    }

    public void addBodyPart(BodyPart part, int pos) throws MessagingException {
        this.parts.add(pos, part);
    }

    public abstract void writeTo(OutputStream var1) throws IOException, MessagingException;

    public Part getParent() {
        return this.parent;
    }

    public void setParent(Part part) {
        this.parent = part;
    }
}

