/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Vector;
import javax.mail.AuthenticationFailedException;
import javax.mail.EventQueue;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.event.ConnectionEvent;
import javax.mail.event.ConnectionListener;
import javax.mail.event.MailEvent;

public abstract class Service {
    protected Session session;
    protected URLName url;
    protected boolean debug;
    private boolean connected;
    private final Vector connectionListeners = new Vector(2);
    private EventQueue queue = null;
    private URLName exposedUrl;

    protected Service(Session session, URLName url) {
        this.session = session;
        this.url = url;
        this.debug = session.getDebug();
    }

    public void connect() throws MessagingException {
        this.connect(null, null, null);
    }

    public void connect(String host, String user, String password) throws MessagingException {
        this.connect(host, -1, user, password);
    }

    public void connect(String user, String password) throws MessagingException {
        this.connect(null, -1, user, password);
    }

    public void connect(String host, int port, String user, String password) throws MessagingException {
        if (this.isConnected()) {
            throw new IllegalStateException("Already connected");
        }
        String protocol = null;
        if (this.url != null) {
            protocol = this.url.getProtocol();
        }
        if (port == -1 && protocol != null) {
            port = this.url.getPort();
        }
        if (host == null) {
            if (this.url != null && (host = this.url.getHost()) == null && protocol != null) {
                host = this.session.getProperty("mail." + protocol + ".host");
            }
            if (host == null) {
                host = this.session.getProperty("mail.host");
            }
        }
        if (user == null) {
            if (this.url != null) {
                user = this.url.getUsername();
                if (password == null) {
                    password = this.url.getPassword();
                }
            }
            if (user == null) {
                if (protocol != null) {
                    user = this.session.getProperty("mail." + protocol + ".user");
                }
                if (user == null && (user = this.session.getProperty("mail.user")) == null) {
                    try {
                        user = System.getProperty("user.name");
                    }
                    catch (SecurityException e2) {}
                }
            }
        } else if (this.url != null && user.equals(this.url.getUsername())) {
            password = this.url.getPassword();
        }
        String file = null;
        if (this.url != null) {
            file = this.url.getFile();
        }
        boolean cachePassword = false;
        if (password == null && this.url != null) {
            this.setURLName(new URLName(protocol, host, port, file, user, password));
            PasswordAuthentication cachedPassword = this.session.getPasswordAuthentication(this.getURLName());
            if (cachedPassword != null) {
                if (user == null) {
                    user = cachedPassword.getUserName();
                    password = cachedPassword.getPassword();
                } else if (user.equals(cachedPassword.getUserName())) {
                    password = cachedPassword.getPassword();
                }
            } else {
                cachePassword = true;
            }
        }
        try {
            this.connected = this.protocolConnect(host, port, user, password);
        }
        catch (AuthenticationFailedException e3) {
            // empty catch block
        }
        if (!this.connected) {
            InetAddress ipAddress = null;
            try {
                ipAddress = InetAddress.getByName(host);
            }
            catch (UnknownHostException e4) {
                // empty catch block
            }
            PasswordAuthentication promptPassword = this.session.requestPasswordAuthentication(ipAddress, port, protocol, null, user);
            if (promptPassword != null) {
                user = promptPassword.getUserName();
                password = promptPassword.getPassword();
            }
            this.connected = this.protocolConnect(host, port, user, password);
        }
        if (!this.connected) {
            throw new AuthenticationFailedException();
        }
        this.setURLName(new URLName(protocol, host, port, file, user, password));
        if (cachePassword) {
            this.session.setPasswordAuthentication(this.getURLName(), new PasswordAuthentication(user, password));
        }
        this.setConnected(this.connected);
        this.notifyConnectionListeners(1);
    }

    protected boolean protocolConnect(String host, int port, String user, String password) throws MessagingException {
        return false;
    }

    public boolean isConnected() {
        return this.connected;
    }

    protected void setConnected(boolean connected) {
        this.connected = connected;
    }

    public void close() throws MessagingException {
        this.setConnected(false);
        this.notifyConnectionListeners(3);
    }

    public URLName getURLName() {
        if (this.exposedUrl == null && this.url != null) {
            this.exposedUrl = new URLName(this.url.getProtocol(), this.url.getHost(), this.url.getPort(), null, this.url.getUsername(), null);
        }
        return this.exposedUrl;
    }

    protected void setURLName(URLName url) {
        this.url = url;
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    protected void notifyConnectionListeners(int type) {
        this.queueEvent(new ConnectionEvent(this, type), this.connectionListeners);
    }

    public String toString() {
        URLName url = this.getURLName();
        return url == null ? super.toString() : url.toString();
    }

    protected void queueEvent(MailEvent event, Vector listeners) {
        if (listeners.isEmpty()) {
            return;
        }
        if (this.queue == null) {
            this.queue = new EventQueue();
        }
        this.queue.queueEvent(event, (List)listeners.clone());
    }

    protected void finalize() throws Throwable {
        if (this.queue != null) {
            this.queue.stop();
        }
        this.connectionListeners.clear();
        super.finalize();
    }

    Session getSession() {
        return this.session;
    }
}

