/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.event.TransportEvent;
import javax.mail.event.TransportListener;

public abstract class Transport
extends Service {
    private Vector transportListeners = new Vector();

    public static void send(Message message) throws MessagingException {
        Transport.send(message, message.getAllRecipients());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void send(Message message, Address[] addresses) throws MessagingException {
        Session session = message.session;
        HashMap<Transport, ArrayList<Address>> msgsByTransport = new HashMap<Transport, ArrayList<Address>>();
        for (int i = 0; i < addresses.length; ++i) {
            Address address = addresses[i];
            Transport transport = session.getTransport(address);
            ArrayList<Address> addrs = (ArrayList<Address>)msgsByTransport.get(transport);
            if (addrs == null) {
                addrs = new ArrayList<Address>();
                msgsByTransport.put(transport, addrs);
            }
            addrs.add(address);
        }
        message.saveChanges();
        MessagingException chainedException = null;
        ArrayList<Address> sentAddresses = new ArrayList<Address>();
        ArrayList<Address> unsentAddresses = new ArrayList<Address>();
        ArrayList<Address> invalidAddresses = new ArrayList<Address>();
        for (Map.Entry entry2 : msgsByTransport.entrySet()) {
            Transport transport = (Transport)entry2.getKey();
            List addrs = (List)entry2.getValue();
            try {
                transport.connect();
                transport.sendMessage(message, addrs.toArray(new Address[addrs.size()]));
                sentAddresses.addAll(addrs);
            }
            catch (SendFailedException e2) {
                int j;
                if (chainedException == null) {
                    chainedException = e2;
                } else {
                    chainedException.setNextException(e2);
                }
                Address[] exAddrs = e2.getValidSentAddresses();
                if (exAddrs != null) {
                    for (j = 0; j < exAddrs.length; ++j) {
                        sentAddresses.add(exAddrs[j]);
                    }
                }
                if ((exAddrs = e2.getValidUnsentAddresses()) != null) {
                    for (j = 0; j < exAddrs.length; ++j) {
                        unsentAddresses.add(exAddrs[j]);
                    }
                }
                if ((exAddrs = e2.getInvalidAddresses()) == null) continue;
                for (j = 0; j < exAddrs.length; ++j) {
                    invalidAddresses.add(exAddrs[j]);
                }
            }
            catch (MessagingException e3) {
                if (chainedException == null) {
                    chainedException = e3;
                    continue;
                }
                chainedException.setNextException(e3);
            }
            finally {
                transport.close();
            }
        }
        if (chainedException != null) {
            if (msgsByTransport.size() == 1 && chainedException instanceof SendFailedException) {
                throw chainedException;
            }
            Address[] sent = sentAddresses.toArray(new Address[0]);
            Address[] unsent = unsentAddresses.toArray(new Address[0]);
            Address[] invalid = invalidAddresses.toArray(new Address[0]);
            throw new SendFailedException("Send failure", chainedException, sent, unsent, invalid);
        }
    }

    public Transport(Session session, URLName name) {
        super(session, name);
    }

    public abstract void sendMessage(Message var1, Address[] var2) throws MessagingException;

    public void addTransportListener(TransportListener listener) {
        this.transportListeners.add(listener);
    }

    public void removeTransportListener(TransportListener listener) {
        this.transportListeners.remove(listener);
    }

    protected void notifyTransportListeners(int type, Address[] validSent, Address[] validUnsent, Address[] invalid, Message message) {
        this.queueEvent(new TransportEvent(this, type, validSent, validUnsent, invalid, message), this.transportListeners);
    }
}

