/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.ParameterList;
import javax.mail.internet.ParseException;

public class ContentDisposition {
    private String _disposition;
    private ParameterList _list;

    public ContentDisposition() {
        this.setDisposition(null);
        this.setParameterList(null);
    }

    public ContentDisposition(String disposition) throws ParseException {
        HeaderTokenizer tokenizer = new HeaderTokenizer(disposition, "()<>@,;:\\\"\t []/?=");
        HeaderTokenizer.Token token2 = tokenizer.next();
        if (token2.getType() != -1) {
            throw new ParseException("Invalid content disposition");
        }
        this._disposition = token2.getValue();
        String remainder = tokenizer.getRemainder();
        if (remainder != null) {
            this._list = new ParameterList(remainder);
        }
    }

    public ContentDisposition(String disposition, ParameterList list2) {
        this.setDisposition(disposition);
        this.setParameterList(list2);
    }

    public String getDisposition() {
        return this._disposition;
    }

    public String getParameter(String name) {
        if (this._list == null) {
            return null;
        }
        return this._list.get(name);
    }

    public ParameterList getParameterList() {
        return this._list;
    }

    public void setDisposition(String string2) {
        this._disposition = string2;
    }

    public void setParameter(String name, String value2) {
        if (this._list == null) {
            this._list = new ParameterList();
        }
        this._list.set(name, value2);
    }

    public void setParameterList(ParameterList list2) {
        this._list = list2 == null ? new ParameterList() : list2;
    }

    public String toString() {
        if (this._disposition == null) {
            return null;
        }
        if (this._list == null) {
            return this._disposition;
        }
        return this._disposition + this._list.toString("Content-Disposition".length() + this._disposition.length());
    }
}

