/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.ParameterList;
import javax.mail.internet.ParseException;

public class ContentType {
    private ParameterList _list;
    private String _minor;
    private String _major;

    public ContentType() {
    }

    public ContentType(String major, String minor, ParameterList list2) {
        this._major = major;
        this._minor = minor;
        this._list = list2;
    }

    public ContentType(String type) throws ParseException {
        HeaderTokenizer tokenizer = new HeaderTokenizer(type, "()<>@,;:\\\"\t []/?=");
        HeaderTokenizer.Token token2 = tokenizer.next();
        if (token2.getType() != -1) {
            throw new ParseException("Invalid content type");
        }
        this._major = token2.getValue();
        token2 = tokenizer.next();
        if (token2.getType() != 47) {
            throw new ParseException("Invalid content type");
        }
        token2 = tokenizer.next();
        if (token2.getType() != -1) {
            throw new ParseException("Invalid content type");
        }
        this._minor = token2.getValue();
        String remainder = tokenizer.getRemainder();
        if (remainder != null) {
            this._list = new ParameterList(remainder);
        }
    }

    public String getPrimaryType() {
        return this._major;
    }

    public String getSubType() {
        return this._minor;
    }

    public String getBaseType() {
        return this._major + "/" + this._minor;
    }

    public String getParameter(String name) {
        return this._list == null ? null : this._list.get(name);
    }

    public ParameterList getParameterList() {
        return this._list;
    }

    public void setPrimaryType(String major) {
        this._major = major;
    }

    public void setSubType(String minor) {
        this._minor = minor;
    }

    public void setParameter(String name, String value2) {
        if (this._list == null) {
            this._list = new ParameterList();
        }
        this._list.set(name, value2);
    }

    public void setParameterList(ParameterList list2) {
        this._list = list2;
    }

    public String toString() {
        if (this._major == null || this._minor == null) {
            return null;
        }
        String baseType = this.getBaseType();
        if (this._list != null) {
            baseType = baseType + this._list.toString(baseType.length() + "Content-Type: ".length());
        }
        return baseType;
    }

    public boolean match(ContentType other) {
        return this._major.equalsIgnoreCase(other._major) && (this._minor.equalsIgnoreCase(other._minor) || this._minor.equals("*") || other._minor.equals("*"));
    }

    public boolean match(String contentType) {
        try {
            return this.match(new ContentType(contentType));
        }
        catch (ParseException e2) {
            return false;
        }
    }
}

