/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import javax.mail.internet.ParseException;

public class HeaderTokenizer {
    private static final Token EOF = new Token(-4, null);
    public static final String MIME = "()<>@,;:\\\"\t []/?=";
    public static final String RFC822 = "()<>@,;:\\\"\t .[]";
    private static final String WHITE = " \t\n\r";
    private String _delimiters;
    private String _header;
    private boolean _skip;
    private int pos;

    public HeaderTokenizer(String header) {
        this(header, RFC822);
    }

    public HeaderTokenizer(String header, String delimiters) {
        this(header, delimiters, true);
    }

    public HeaderTokenizer(String header, String delimiters, boolean skipComments) {
        this._skip = skipComments;
        this._header = header;
        this._delimiters = delimiters;
    }

    public String getRemainder() {
        return this._header.substring(this.pos);
    }

    public Token next() throws ParseException {
        return this.readToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token peek() throws ParseException {
        int start2 = this.pos;
        try {
            Token token2 = this.readToken();
            return token2;
        }
        finally {
            this.pos = start2;
        }
    }

    private Token readAtomicToken() {
        int start2 = this.pos;
        while (++this.pos < this._header.length()) {
            char ch = this._header.charAt(this.pos);
            if (this._delimiters.indexOf(this._header.charAt(this.pos)) == -1 && ch >= ' ' && ch < '\u007f') continue;
            break;
        }
        return new Token(-1, this._header.substring(start2, this.pos));
    }

    private Token readToken() throws ParseException {
        if (this.pos >= this._header.length()) {
            return EOF;
        }
        char c2 = this._header.charAt(this.pos);
        if (c2 == '(') {
            Token comment2 = this.readComment();
            if (this._skip) {
                return this.readToken();
            }
            return comment2;
        }
        if (c2 == '\"') {
            return this.readQuotedString();
        }
        if (WHITE.indexOf(c2) != -1) {
            this.eatWhiteSpace();
            return this.readToken();
        }
        if (c2 < ' ' || c2 >= '\u007f' || this._delimiters.indexOf(c2) != -1) {
            ++this.pos;
            return new Token(c2, String.valueOf(c2));
        }
        return this.readAtomicToken();
    }

    private String getEscapedValue(int start2, int end2) throws ParseException {
        StringBuffer value2 = new StringBuffer();
        for (int i = start2; i < end2; ++i) {
            char ch = this._header.charAt(i);
            if (ch == '\\') {
                if (++i == end2) {
                    throw new ParseException("Invalid escape character");
                }
                value2.append(this._header.charAt(i));
                continue;
            }
            if (ch == '\r') {
                if (i >= end2 - 1 || this._header.charAt(i + 1) != '\n') continue;
                ++i;
                continue;
            }
            value2.append(ch);
        }
        return value2.toString();
    }

    private Token readComment() throws ParseException {
        int start2 = this.pos + 1;
        int nesting = 1;
        boolean requiresEscaping = false;
        while (++this.pos < this._header.length()) {
            char ch = this._header.charAt(this.pos);
            if (ch == ')') {
                if (--nesting != 0) continue;
                break;
            }
            if (ch == '(') {
                ++nesting;
                continue;
            }
            if (ch == '\\') {
                ++this.pos;
                requiresEscaping = true;
                continue;
            }
            if (ch != '\r') continue;
            requiresEscaping = true;
        }
        if (nesting != 0) {
            throw new ParseException("Unbalanced comments");
        }
        String value2 = requiresEscaping ? this.getEscapedValue(start2, this.pos) : this._header.substring(start2, this.pos++);
        return new Token(-3, value2);
    }

    private Token readQuotedString() throws ParseException {
        int start2 = this.pos + 1;
        boolean requiresEscaping = false;
        while (++this.pos < this._header.length()) {
            char ch = this._header.charAt(this.pos);
            if (ch == '\"') {
                String value2 = requiresEscaping ? this.getEscapedValue(start2, this.pos++) : this._header.substring(start2, this.pos++);
                return new Token(-2, value2);
            }
            if (ch == '\\') {
                ++this.pos;
                requiresEscaping = true;
                continue;
            }
            if (ch != '\r') continue;
            requiresEscaping = true;
        }
        throw new ParseException("Missing '\"'");
    }

    private void eatWhiteSpace() {
        while (++this.pos < this._header.length() && WHITE.indexOf(this._header.charAt(this.pos)) != -1) {
        }
    }

    public static class Token {
        public static final int ATOM = -1;
        public static final int COMMENT = -3;
        public static final int EOF = -4;
        public static final int QUOTEDSTRING = -2;
        private int _type;
        private String _value;

        public Token(int type, String value2) {
            this._type = type;
            this._value = value2;
        }

        public int getType() {
            return this._type;
        }

        public String getValue() {
            return this._value;
        }
    }
}

