/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.mail.Address;
import javax.mail.Header;
import javax.mail.MessagingException;

public class InternetHeaders {
    protected List headers = new ArrayList();
    private transient String lastHeaderName;

    public InternetHeaders() {
        this.addHeader("Return-Path", null);
        this.addHeader("Received", null);
        this.addHeader("Resent-Date", null);
        this.addHeader("Resent-From", null);
        this.addHeader("Resent-Sender", null);
        this.addHeader("Resent-To", null);
        this.addHeader("Resent-Cc", null);
        this.addHeader("Resent-Bcc", null);
        this.addHeader("Resent-Message-Id", null);
        this.addHeader("Date", null);
        this.addHeader("From", null);
        this.addHeader("Sender", null);
        this.addHeader("Reply-To", null);
        this.addHeader("To", null);
        this.addHeader("Cc", null);
        this.addHeader("Bcc", null);
        this.addHeader("Message-Id", null);
        this.addHeader("In-Reply-To", null);
        this.addHeader("References", null);
        this.addHeader("Subject", null);
        this.addHeader("Comments", null);
        this.addHeader("Keywords", null);
        this.addHeader("Errors-To", null);
        this.addHeader("MIME-Version", null);
        this.addHeader("Content-Type", null);
        this.addHeader("Content-Transfer-Encoding", null);
        this.addHeader("Content-MD5", null);
        this.addHeader(":", null);
        this.addHeader("Content-Length", null);
        this.addHeader("Status", null);
    }

    public InternetHeaders(InputStream in2) throws MessagingException {
        this.load(in2);
    }

    public void load(InputStream in2) throws MessagingException {
        try {
            String line;
            StringBuffer buffer = new StringBuffer(128);
            while ((line = this.readLine(in2)) != null) {
                if (line.startsWith(" ") || line.startsWith("\t")) {
                    if (buffer.length() == 0) {
                        this.addHeaderLine(line);
                        continue;
                    }
                    buffer.append("\r\n");
                    buffer.append(line);
                    continue;
                }
                if (buffer.length() > 0) {
                    this.addHeaderLine(buffer.toString());
                    buffer.setLength(0);
                }
                buffer.append(line);
            }
            if (buffer.length() > 0) {
                this.addHeaderLine(buffer.toString());
            }
        }
        catch (IOException e2) {
            throw new MessagingException("Error loading headers", e2);
        }
    }

    private String readLine(InputStream in2) throws IOException {
        int c2;
        StringBuffer buffer = new StringBuffer(128);
        while ((c2 = in2.read()) != -1 && c2 != 10) {
            if (c2 == 13) continue;
            buffer.append((char)c2);
        }
        if (buffer.length() == 0) {
            return null;
        }
        return buffer.toString();
    }

    public String[] getHeader(String name) {
        ArrayList<String> accumulator = new ArrayList<String>();
        for (int i = 0; i < this.headers.size(); ++i) {
            InternetHeader header = (InternetHeader)this.headers.get(i);
            if (!header.getName().equalsIgnoreCase(name) || header.getValue() == null) continue;
            accumulator.add(header.getValue());
        }
        if (accumulator.isEmpty()) {
            return null;
        }
        return accumulator.toArray(new String[accumulator.size()]);
    }

    public String getHeader(String name, String delimiter) {
        String[] matches2 = this.getHeader(name);
        if (matches2 == null) {
            return null;
        }
        if (matches2.length == 1 || delimiter == null) {
            return matches2[0];
        }
        StringBuffer result2 = new StringBuffer(matches2[0]);
        for (int i = 1; i < matches2.length; ++i) {
            result2.append(delimiter);
            result2.append(matches2[i]);
        }
        return result2.toString();
    }

    public void setHeader(String name, String value2) {
        for (int i = 0; i < this.headers.size(); ++i) {
            InternetHeader header = (InternetHeader)this.headers.get(i);
            if (!name.equalsIgnoreCase(header.getName())) continue;
            header.setValue(value2);
            header.setName(name);
            this.removeHeaders(name, i + 1);
            return;
        }
        this.addHeader(name, value2);
    }

    private void removeHeaders(String name, int pos) {
        for (int i = pos; i < this.headers.size(); ++i) {
            InternetHeader header = (InternetHeader)this.headers.get(i);
            if (!name.equalsIgnoreCase(header.getName())) continue;
            this.headers.remove(i);
            --i;
        }
    }

    private int findHeader(String name) {
        return this.findHeader(name, 0);
    }

    private int findHeader(String name, int start2) {
        for (int i = start2; i < this.headers.size(); ++i) {
            InternetHeader header = (InternetHeader)this.headers.get(i);
            if (!name.equalsIgnoreCase(header.getName())) continue;
            return i;
        }
        return -1;
    }

    public void addHeader(String name, String value2) {
        InternetHeader newHeader = new InternetHeader(name, value2);
        if (name.equalsIgnoreCase("Received") || name.equalsIgnoreCase("Return-Path")) {
            int pos = this.findHeader(name);
            if (pos != -1) {
                InternetHeader oldHeader = (InternetHeader)this.headers.get(pos);
                if (oldHeader.getValue() == null) {
                    oldHeader.setValue(value2);
                } else {
                    this.headers.add(pos, newHeader);
                }
            } else {
                this.headers.add(0, newHeader);
            }
        } else {
            int pos = this.findHeader(name);
            if (pos != -1) {
                InternetHeader oldHeader = (InternetHeader)this.headers.get(pos);
                if (oldHeader.getValue() == null) {
                    oldHeader.setValue(value2);
                } else {
                    int lastPos = this.findHeader(name, pos + 1);
                    while (lastPos != -1) {
                        pos = lastPos;
                        lastPos = this.findHeader(name, pos + 1);
                    }
                    this.headers.add(pos + 1, newHeader);
                }
            } else {
                pos = this.findHeader(":");
                if (pos == -1) {
                    pos = this.headers.size();
                }
                this.headers.add(pos, newHeader);
            }
        }
    }

    public void removeHeader(String name) {
        int pos = this.findHeader(name);
        if (pos != -1) {
            InternetHeader oldHeader = (InternetHeader)this.headers.get(pos);
            oldHeader.setValue(null);
            this.removeHeaders(name, pos + 1);
        }
    }

    public Enumeration getAllHeaders() {
        ArrayList<InternetHeader> result2 = new ArrayList<InternetHeader>();
        for (int i = 0; i < this.headers.size(); ++i) {
            InternetHeader header = (InternetHeader)this.headers.get(i);
            if (header.getValue() == null) continue;
            result2.add(header);
        }
        return Collections.enumeration(result2);
    }

    private boolean matchHeader(String name, String[] names) {
        if (names == null) {
            return false;
        }
        for (int i = 0; i < names.length; ++i) {
            if (!name.equalsIgnoreCase(names[i])) continue;
            return true;
        }
        return false;
    }

    public Enumeration getMatchingHeaders(String[] names) {
        ArrayList<InternetHeader> result2 = new ArrayList<InternetHeader>();
        for (int i = 0; i < this.headers.size(); ++i) {
            InternetHeader header = (InternetHeader)this.headers.get(i);
            if (header.getValue() == null || !this.matchHeader(header.getName(), names)) continue;
            result2.add(header);
        }
        return Collections.enumeration(result2);
    }

    public Enumeration getNonMatchingHeaders(String[] names) {
        ArrayList<InternetHeader> result2 = new ArrayList<InternetHeader>();
        for (int i = 0; i < this.headers.size(); ++i) {
            InternetHeader header = (InternetHeader)this.headers.get(i);
            if (header.getValue() == null || this.matchHeader(header.getName(), names)) continue;
            result2.add(header);
        }
        return Collections.enumeration(result2);
    }

    public void addHeaderLine(String line) {
        if (line.length() == 0) {
            return;
        }
        char ch = line.charAt(0);
        if (ch == ' ' || ch == '\t') {
            int size2 = this.headers.size();
            if (size2 > 0) {
                InternetHeader header = (InternetHeader)this.headers.get(size2 - 1);
                header.appendValue(line);
            }
        } else {
            this.headers.add(new InternetHeader(line));
        }
    }

    public Enumeration getAllHeaderLines() {
        return new HeaderLineEnumeration(this.getAllHeaders());
    }

    public Enumeration getMatchingHeaderLines(String[] names) {
        return new HeaderLineEnumeration(this.getMatchingHeaders(names));
    }

    public Enumeration getNonMatchingHeaderLines(String[] names) {
        return new HeaderLineEnumeration(this.getNonMatchingHeaders(names));
    }

    void setHeader(String name, Address[] addresses) {
        if (addresses.length == 0) {
            this.removeHeader(name);
        } else {
            this.setHeader(name, addresses[0].toString());
            for (int i = 1; i < addresses.length; ++i) {
                Address address = addresses[i];
                this.addHeader(name, address.toString());
            }
        }
    }

    void writeTo(OutputStream out, String[] ignore2) throws IOException {
        if (ignore2 == null) {
            for (int i = 0; i < this.headers.size(); ++i) {
                InternetHeader header = (InternetHeader)this.headers.get(i);
                if (header.getValue() == null) continue;
                header.writeTo(out);
            }
        } else {
            for (int i = 0; i < this.headers.size(); ++i) {
                InternetHeader header = (InternetHeader)this.headers.get(i);
                if (header.getValue() == null || this.matchHeader(header.getName(), ignore2)) continue;
                header.writeTo(out);
            }
        }
    }

    private static class HeaderLineEnumeration
    implements Enumeration {
        private Enumeration headers;

        public HeaderLineEnumeration(Enumeration headers2) {
            this.headers = headers2;
        }

        public boolean hasMoreElements() {
            return this.headers.hasMoreElements();
        }

        public Object nextElement() {
            Header h = (Header)this.headers.nextElement();
            return h.getName() + ": " + h.getValue();
        }
    }

    protected static final class InternetHeader
    extends Header {
        public InternetHeader(String h) {
            super("", "");
            int separator = h.indexOf(58);
            if (separator == -1) {
                this.name = h.trim();
            } else {
                char ch;
                this.name = h.substring(0, separator);
                ++separator;
                while (separator < h.length() && ((ch = h.charAt(separator)) == ' ' || ch == '\t' || ch == '\r' || ch == '\n')) {
                    ++separator;
                }
                this.value = h.substring(separator);
            }
        }

        public InternetHeader(String name, String value2) {
            super(name, value2);
        }

        void setValue(String value2) {
            this.value = value2;
        }

        void setName(String name) {
            this.name = name;
        }

        void appendValue(String value2) {
            this.value = this.value == null ? value2 : this.value + "\r\n" + value2;
        }

        void writeTo(OutputStream out) throws IOException {
            out.write(this.name.getBytes("ISO8859-1"));
            out.write(58);
            out.write(32);
            out.write(this.value.getBytes("ISO8859-1"));
            out.write(13);
            out.write(10);
        }
    }
}

