/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ContentType;
import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import org.apache.geronimo.mail.util.ASCIIUtil;
import org.apache.geronimo.mail.util.SessionUtil;

public class MimeBodyPart
extends BodyPart
implements MimePart {
    private static final String MIME_DECODEFILENAME = "mail.mime.decodefilename";
    private static final String MIME_ENCODEFILENAME = "mail.mime.encodefilename";
    private static final String MIME_SETDEFAULTTEXTCHARSET = "mail.mime.setdefaulttextcharset";
    private static final String MIME_SETCONTENTTYPEFILENAME = "mail.mime.setcontenttypefilename";
    protected DataHandler dh;
    protected byte[] content;
    protected InputStream contentStream;
    protected InternetHeaders headers;

    public MimeBodyPart() {
        this.headers = new InternetHeaders();
    }

    public MimeBodyPart(InputStream in2) throws MessagingException {
        this.headers = new InternetHeaders(in2);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int count2;
            while ((count2 = in2.read(buffer, 0, 1024)) > 0) {
                baos.write(buffer, 0, count2);
            }
        }
        catch (IOException e2) {
            throw new MessagingException(e2.toString(), e2);
        }
        this.content = baos.toByteArray();
    }

    public MimeBodyPart(InternetHeaders headers2, byte[] content2) throws MessagingException {
        this.headers = headers2;
        this.content = content2;
    }

    public int getSize() throws MessagingException {
        if (this.content != null) {
            return this.content.length;
        }
        if (this.contentStream != null) {
            try {
                int size2 = this.contentStream.available();
                if (size2 > 0) {
                    return size2;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return -1;
    }

    public int getLineCount() throws MessagingException {
        return -1;
    }

    public String getContentType() throws MessagingException {
        String value2 = this.getSingleHeader("Content-Type");
        if (value2 == null) {
            value2 = "text/plain";
        }
        return value2;
    }

    public boolean isMimeType(String type) throws MessagingException {
        return new ContentType(this.getContentType()).match(type);
    }

    public String getDisposition() throws MessagingException {
        String disp = this.getSingleHeader("Content-Disposition");
        if (disp != null) {
            return new ContentDisposition(disp).getDisposition();
        }
        return null;
    }

    public void setDisposition(String disposition) throws MessagingException {
        if (disposition == null) {
            this.removeHeader("Content-Disposition");
        } else {
            String currentHeader = this.getSingleHeader("Content-Disposition");
            if (currentHeader != null) {
                ContentDisposition content2 = new ContentDisposition(currentHeader);
                content2.setDisposition(disposition);
                this.setHeader("Content-Disposition", content2.toString());
            } else {
                this.setHeader("Content-Disposition", disposition);
            }
        }
    }

    public String getEncoding() throws MessagingException {
        String encoding = this.getSingleHeader("Content-Transfer-Encoding");
        if (encoding != null) {
            HeaderTokenizer tokenizer = new HeaderTokenizer(encoding, "()<>@,;:\\\"\t []/?=");
            HeaderTokenizer.Token token2 = tokenizer.next();
            while (token2.getType() != -4) {
                if (token2.getType() != -1) continue;
                return token2.getValue();
            }
            return encoding;
        }
        return null;
    }

    public String getContentID() throws MessagingException {
        return this.getSingleHeader("Content-ID");
    }

    public void setContentID(String cid) throws MessagingException {
        this.setOrRemoveHeader("Content-ID", cid);
    }

    public String getContentMD5() throws MessagingException {
        return this.getSingleHeader("Content-MD5");
    }

    public void setContentMD5(String md5) throws MessagingException {
        this.setHeader("Content-MD5", md5);
    }

    public String[] getContentLanguage() throws MessagingException {
        return this.getHeader("Content-Language");
    }

    public void setContentLanguage(String[] languages) throws MessagingException {
        if (languages == null) {
            this.removeHeader("Content-Language");
        } else if (languages.length == 1) {
            this.setHeader("Content-Language", languages[0]);
        } else {
            StringBuffer buf = new StringBuffer(languages.length * 20);
            buf.append(languages[0]);
            for (int i = 1; i < languages.length; ++i) {
                buf.append(',').append(languages[i]);
            }
            this.setHeader("Content-Language", buf.toString());
        }
    }

    public String getDescription() throws MessagingException {
        String description2 = this.getSingleHeader("Content-Description");
        if (description2 != null) {
            try {
                return MimeUtility.decodeText(MimeUtility.unfold(description2));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return description2;
    }

    public void setDescription(String description2) throws MessagingException {
        this.setDescription(description2, null);
    }

    public void setDescription(String description2, String charset) throws MessagingException {
        if (description2 == null) {
            this.removeHeader("Content-Description");
        } else {
            try {
                this.setHeader("Content-Description", MimeUtility.fold(21, MimeUtility.encodeText(description2, charset, null)));
            }
            catch (UnsupportedEncodingException e2) {
                throw new MessagingException(e2.getMessage(), e2);
            }
        }
    }

    public String getFileName() throws MessagingException {
        String type;
        String disposition = this.getSingleHeader("Content-Disposition");
        String filename = null;
        if (disposition != null) {
            filename = new ContentDisposition(disposition).getParameter("filename");
        }
        if (filename == null && (type = this.getSingleHeader("Content-Type")) != null) {
            try {
                filename = new ContentType(type).getParameter("name");
            }
            catch (ParseException e2) {
                // empty catch block
            }
        }
        if (filename != null && SessionUtil.getBooleanProperty(MIME_DECODEFILENAME, false)) {
            try {
                filename = MimeUtility.decodeText(filename);
            }
            catch (UnsupportedEncodingException e3) {
                throw new MessagingException("Unable to decode filename", e3);
            }
        }
        return filename;
    }

    public void setFileName(String name) throws MessagingException {
        String disposition;
        if (name != null && SessionUtil.getBooleanProperty(MIME_ENCODEFILENAME, false)) {
            try {
                name = MimeUtility.encodeText(name);
            }
            catch (UnsupportedEncodingException e2) {
                throw new MessagingException("Unable to encode filename", e2);
            }
        }
        if ((disposition = this.getDisposition()) == null) {
            disposition = "attachment";
        }
        ContentDisposition contentDisposition = new ContentDisposition(disposition);
        contentDisposition.setParameter("filename", name);
        this.setHeader("Content-Disposition", contentDisposition.toString());
        if (SessionUtil.getBooleanProperty(MIME_SETCONTENTTYPEFILENAME, true)) {
            ContentType type = new ContentType(this.getContentType());
            type.setParameter("name", name);
            this.setHeader("Content-Type", type.toString());
        }
    }

    public InputStream getInputStream() throws MessagingException, IOException {
        return this.getDataHandler().getInputStream();
    }

    protected InputStream getContentStream() throws MessagingException {
        if (this.contentStream != null) {
            return this.contentStream;
        }
        if (this.content != null) {
            return new ByteArrayInputStream(this.content);
        }
        throw new MessagingException("No content");
    }

    public InputStream getRawInputStream() throws MessagingException {
        return this.getContentStream();
    }

    public synchronized DataHandler getDataHandler() throws MessagingException {
        if (this.dh == null) {
            this.dh = new DataHandler((DataSource)new MimePartDataSource(this));
        }
        return this.dh;
    }

    public Object getContent() throws MessagingException, IOException {
        return this.getDataHandler().getContent();
    }

    public void setDataHandler(DataHandler handler) throws MessagingException {
        this.dh = handler;
        this.removeHeader("Content-Type");
        this.removeHeader("Content-Transfer-Encoding");
    }

    public void setContent(Object content2, String type) throws MessagingException {
        if (content2 instanceof Multipart) {
            this.setContent((Multipart)content2);
        } else {
            this.setDataHandler(new DataHandler(content2, type));
        }
    }

    public void setText(String text2) throws MessagingException {
        this.setText(text2, null);
    }

    public void setText(String text2, String charset) throws MessagingException {
        this.setText(text2, charset, "plain");
    }

    public void setText(String text2, String charset, String subtype) throws MessagingException {
        if (charset == null) {
            charset = !ASCIIUtil.isAscii(text2) ? MimeUtility.getDefaultMIMECharset() : "us-ascii";
        }
        this.setContent(text2, "text/plain; charset=" + MimeUtility.quote(charset, "()<>@,;:\\\"\t []/?="));
    }

    public void setContent(Multipart part) throws MessagingException {
        this.setDataHandler(new DataHandler((Object)part, part.getContentType()));
        part.setParent(this);
    }

    public void writeTo(OutputStream out) throws IOException, MessagingException {
        this.headers.writeTo(out, null);
        out.write(13);
        out.write(10);
        OutputStream encodingStream = MimeUtility.encode(out, this.getEncoding());
        this.getDataHandler().writeTo(encodingStream);
        encodingStream.flush();
    }

    public String[] getHeader(String name) throws MessagingException {
        return this.headers.getHeader(name);
    }

    public String getHeader(String name, String delimiter) throws MessagingException {
        return this.headers.getHeader(name, delimiter);
    }

    public void setHeader(String name, String value2) throws MessagingException {
        this.headers.setHeader(name, value2);
    }

    private void setOrRemoveHeader(String name, String value2) throws MessagingException {
        if (value2 == null) {
            this.headers.removeHeader(name);
        } else {
            this.headers.setHeader(name, value2);
        }
    }

    public void addHeader(String name, String value2) throws MessagingException {
        this.headers.addHeader(name, value2);
    }

    public void removeHeader(String name) throws MessagingException {
        this.headers.removeHeader(name);
    }

    public Enumeration getAllHeaders() throws MessagingException {
        return this.headers.getAllHeaders();
    }

    public Enumeration getMatchingHeaders(String[] name) throws MessagingException {
        return this.headers.getMatchingHeaders(name);
    }

    public Enumeration getNonMatchingHeaders(String[] name) throws MessagingException {
        return this.headers.getNonMatchingHeaders(name);
    }

    public void addHeaderLine(String line) throws MessagingException {
        this.headers.addHeaderLine(line);
    }

    public Enumeration getAllHeaderLines() throws MessagingException {
        return this.headers.getAllHeaderLines();
    }

    public Enumeration getMatchingHeaderLines(String[] names) throws MessagingException {
        return this.headers.getMatchingHeaderLines(names);
    }

    public Enumeration getNonMatchingHeaderLines(String[] names) throws MessagingException {
        return this.headers.getNonMatchingHeaderLines(names);
    }

    protected void updateHeaders() throws MessagingException {
        DataHandler handler = this.getDataHandler();
        try {
            String type = this.dh.getContentType();
            ContentType content2 = new ContentType(type);
            String explicitType = this.getSingleHeader("Content-Type");
            if (content2.match("multipart/*")) {
                try {
                    MimeMultipart part = (MimeMultipart)handler.getContent();
                    part.updateHeaders();
                }
                catch (ClassCastException e2) {
                    throw new MessagingException("Message content is not MimeMultipart", e2);
                }
            } else if (!content2.match("message/rfc822")) {
                if (this.getSingleHeader("Content-Transfer-Encoding") == null) {
                    this.setHeader("Content-Transfer-Encoding", MimeUtility.getEncoding(handler));
                }
                if (explicitType == null && SessionUtil.getBooleanProperty(MIME_SETDEFAULTTEXTCHARSET, true) && content2.match("text/*") && content2.getParameter("charset") == null) {
                    String encoding = this.getEncoding();
                    if (encoding != null && encoding.equalsIgnoreCase("7bit")) {
                        content2.setParameter("charset", "us-ascii");
                    } else {
                        content2.setParameter("charset", MimeUtility.getDefaultMIMECharset());
                    }
                    type = content2.toString();
                }
            }
            if (explicitType == null) {
                ContentDisposition disposition;
                String filename;
                String disp = this.getHeader("Content-Disposition", null);
                if (disp != null && (filename = (disposition = new ContentDisposition(disp)).getParameter("filename")) != null) {
                    content2.setParameter("name", filename);
                    type = content2.toString();
                }
                this.setHeader("Content-Type", type);
            }
        }
        catch (IOException e3) {
            throw new MessagingException("Error updating message headers", e3);
        }
    }

    private String getSingleHeader(String name) throws MessagingException {
        String[] values2 = this.getHeader(name);
        if (values2 == null || values2.length == 0) {
            return null;
        }
        return values2[0];
    }

    public void attachFile(File file) throws IOException, MessagingException {
        FileDataSource dataSource = new FileDataSource(file);
        this.setDataHandler(new DataHandler((DataSource)dataSource));
        this.setFileName(dataSource.getName());
    }

    public void attachFile(String file) throws IOException, MessagingException {
        this.attachFile(new File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile(File file) throws IOException, MessagingException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        InputStream in2 = this.getInputStream();
        try {
            int length2;
            byte[] buffer = new byte[8192];
            while ((length2 = in2.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length2);
            }
        }
        finally {
            if (in2 != null) {
                in2.close();
            }
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }

    public void saveFile(String file) throws IOException, MessagingException {
        this.saveFile(new File(file));
    }
}

