/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ContentType;
import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.NewsAddress;
import javax.mail.internet.ParseException;
import org.apache.geronimo.mail.util.ASCIIUtil;
import org.apache.geronimo.mail.util.SessionUtil;

public class MimeMessage
extends Message
implements MimePart {
    private static final String MIME_ADDRESS_STRICT = "mail.mime.address.strict";
    private static final String MIME_DECODEFILENAME = "mail.mime.decodefilename";
    private static final String MIME_ENCODEFILENAME = "mail.mime.encodefilename";
    private static final String MAIL_ALTERNATES = "mail.alternates";
    private static final String MAIL_REPLYALLCC = "mail.replyallcc";
    private static int messageID = 0;
    protected DataHandler dh;
    protected byte[] content;
    protected InputStream contentStream;
    protected InternetHeaders headers;
    protected Flags flags;
    protected boolean modified;
    protected boolean saved;
    private final MailDateFormat dateFormat = new MailDateFormat();

    public MimeMessage(Session session) {
        super(session);
        this.headers = new InternetHeaders();
        this.flags = new Flags();
        this.modified = true;
        this.saved = false;
    }

    public MimeMessage(Session session, InputStream in2) throws MessagingException {
        this(session);
        this.parse(in2);
        this.modified = false;
        this.saved = true;
    }

    public MimeMessage(MimeMessage message) throws MessagingException {
        super(message.session);
        this.flags = message.getFlags();
        ByteArrayOutputStream copy2 = new ByteArrayOutputStream();
        try {
            message.writeTo(copy2);
            copy2.close();
            ByteArrayInputStream inData = new ByteArrayInputStream(copy2.toByteArray());
            inData.close();
            this.parse(inData);
            this.saved = true;
            this.modified = false;
        }
        catch (IOException e2) {
            throw new MessagingException("Error copying MimeMessage data", e2);
        }
    }

    protected MimeMessage(Folder folder, int number2) {
        super(folder, number2);
        this.headers = new InternetHeaders();
        this.flags = new Flags();
        this.saved = true;
        this.modified = true;
    }

    protected MimeMessage(Folder folder, InputStream in2, int number2) throws MessagingException {
        this(folder, number2);
        this.parse(in2);
        this.modified = false;
        this.saved = true;
    }

    protected MimeMessage(Folder folder, InternetHeaders headers2, byte[] content2, int number2) throws MessagingException {
        this(folder, number2);
        this.headers = headers2;
        this.content = content2;
        this.modified = false;
    }

    protected void parse(InputStream in2) throws MessagingException {
        in2 = new BufferedInputStream(in2);
        this.headers = this.createInternetHeaders(in2);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int count2;
            byte[] buffer = new byte[1024];
            while ((count2 = in2.read(buffer, 0, 1024)) != -1) {
                baos.write(buffer, 0, count2);
            }
        }
        catch (Exception e2) {
            throw new MessagingException(e2.toString(), e2);
        }
        this.content = baos.toByteArray();
    }

    public Address[] getFrom() throws MessagingException {
        boolean strict = this.isStrictAddressing();
        Address[] result2 = this.getHeaderAsInternetAddresses("From", strict);
        if (result2 == null) {
            result2 = this.getHeaderAsInternetAddresses("Sender", strict);
        }
        return result2;
    }

    public void setFrom(Address address) throws MessagingException {
        this.setHeader("From", address);
    }

    public void setFrom() throws MessagingException {
        InternetAddress address = InternetAddress.getLocalAddress(this.session);
        if (address == null) {
            throw new MessagingException("No local address defined");
        }
        this.setFrom(address);
    }

    public void addFrom(Address[] addresses) throws MessagingException {
        this.addHeader("From", addresses);
    }

    public Address getSender() throws MessagingException {
        Address[] addrs = this.getHeaderAsInternetAddresses("Sender", this.isStrictAddressing());
        return addrs != null && addrs.length > 0 ? addrs[0] : null;
    }

    public void setSender(Address address) throws MessagingException {
        this.setHeader("Sender", address);
    }

    public Address[] getRecipients(Message.RecipientType type) throws MessagingException {
        if (type == RecipientType.NEWSGROUPS) {
            return this.getHeaderAsNewsAddresses(this.getHeaderForRecipientType(type));
        }
        return this.getHeaderAsInternetAddresses(this.getHeaderForRecipientType(type), this.isStrictAddressing());
    }

    public Address[] getAllRecipients() throws MessagingException {
        ArrayList recipients = new ArrayList();
        this.addRecipientsToList(recipients, RecipientType.TO);
        this.addRecipientsToList(recipients, RecipientType.CC);
        this.addRecipientsToList(recipients, RecipientType.BCC);
        this.addRecipientsToList(recipients, RecipientType.NEWSGROUPS);
        if (recipients.isEmpty()) {
            return null;
        }
        return recipients.toArray(new Address[recipients.size()]);
    }

    private void addRecipientsToList(List list2, Message.RecipientType type) throws MessagingException {
        Address[] recipients = type == RecipientType.NEWSGROUPS ? this.getHeaderAsNewsAddresses(this.getHeaderForRecipientType(type)) : this.getHeaderAsInternetAddresses(this.getHeaderForRecipientType(type), this.isStrictAddressing());
        if (recipients != null) {
            list2.addAll(Arrays.asList(recipients));
        }
    }

    public void setRecipients(Message.RecipientType type, Address[] addresses) throws MessagingException {
        this.setHeader(this.getHeaderForRecipientType(type), addresses);
    }

    public void setRecipients(Message.RecipientType type, String address) throws MessagingException {
        this.setOrRemoveHeader(this.getHeaderForRecipientType(type), address);
    }

    public void addRecipients(Message.RecipientType type, Address[] address) throws MessagingException {
        this.addHeader(this.getHeaderForRecipientType(type), address);
    }

    public void addRecipients(Message.RecipientType type, String address) throws MessagingException {
        this.addHeader(this.getHeaderForRecipientType(type), address);
    }

    public Address[] getReplyTo() throws MessagingException {
        Address[] addresses = this.getHeaderAsInternetAddresses("Reply-To", this.isStrictAddressing());
        if (addresses == null) {
            addresses = this.getFrom();
        }
        return addresses;
    }

    public void setReplyTo(Address[] address) throws MessagingException {
        this.setHeader("Reply-To", address);
    }

    public String getSubject() throws MessagingException {
        String subject = this.getSingleHeader("Subject");
        if (subject == null) {
            return null;
        }
        try {
            return MimeUtility.decodeText(MimeUtility.unfold(subject));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return subject;
        }
    }

    public void setSubject(String subject) throws MessagingException {
        this.setSubject(subject, null);
    }

    public void setSubject(String subject, String charset) throws MessagingException {
        if (subject == null) {
            this.removeHeader("Subject");
        } else {
            try {
                String s2 = MimeUtility.fold(9, MimeUtility.encodeText(subject, charset, null));
                this.setHeader("Subject", MimeUtility.fold(9, MimeUtility.encodeText(subject, charset, null)));
            }
            catch (UnsupportedEncodingException e2) {
                throw new MessagingException("Encoding error", e2);
            }
        }
    }

    public Date getSentDate() throws MessagingException {
        String value2 = this.getSingleHeader("Date");
        if (value2 == null) {
            return null;
        }
        try {
            return this.dateFormat.parse(value2);
        }
        catch (java.text.ParseException e2) {
            return null;
        }
    }

    public void setSentDate(Date sent) throws MessagingException {
        this.setOrRemoveHeader("Date", this.dateFormat.format(sent));
    }

    public Date getReceivedDate() throws MessagingException {
        return null;
    }

    public int getSize() throws MessagingException {
        if (this.content != null) {
            return this.content.length;
        }
        if (this.contentStream != null) {
            try {
                int size2 = this.contentStream.available();
                if (size2 > 0) {
                    return size2;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return -1;
    }

    public int getLineCount() throws MessagingException {
        return -1;
    }

    public String getContentType() throws MessagingException {
        String value2 = this.getSingleHeader("Content-Type");
        if (value2 == null) {
            value2 = "text/plain";
        }
        return value2;
    }

    public boolean isMimeType(String type) throws MessagingException {
        return new ContentType(this.getContentType()).match(type);
    }

    public String getDisposition() throws MessagingException {
        String disp = this.getSingleHeader("Content-Disposition");
        if (disp != null) {
            return new ContentDisposition(disp).getDisposition();
        }
        return null;
    }

    public void setDisposition(String disposition) throws MessagingException {
        if (disposition == null) {
            this.removeHeader("Content-Disposition");
        } else {
            String currentHeader = this.getSingleHeader("Content-Disposition");
            if (currentHeader != null) {
                ContentDisposition content2 = new ContentDisposition(currentHeader);
                content2.setDisposition(disposition);
                this.setHeader("Content-Disposition", content2.toString());
            } else {
                this.setHeader("Content-Disposition", disposition);
            }
        }
    }

    public String getEncoding() throws MessagingException {
        String encoding = this.getSingleHeader("Content-Transfer-Encoding");
        if (encoding != null) {
            HeaderTokenizer tokenizer = new HeaderTokenizer(encoding, "()<>@,;:\\\"\t []/?=");
            HeaderTokenizer.Token token2 = tokenizer.next();
            while (token2.getType() != -4) {
                if (token2.getType() != -1) continue;
                return token2.getValue();
            }
            return encoding;
        }
        return null;
    }

    public String getContentID() throws MessagingException {
        return this.getSingleHeader("Content-ID");
    }

    public void setContentID(String cid) throws MessagingException {
        this.setOrRemoveHeader("Content-ID", cid);
    }

    public String getContentMD5() throws MessagingException {
        return this.getSingleHeader("Content-MD5");
    }

    public void setContentMD5(String md5) throws MessagingException {
        this.setOrRemoveHeader("Content-MD5", md5);
    }

    public String getDescription() throws MessagingException {
        String description2 = this.getSingleHeader("Content-Description");
        if (description2 != null) {
            try {
                return MimeUtility.decodeText(MimeUtility.unfold(description2));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return description2;
    }

    public void setDescription(String description2) throws MessagingException {
        this.setDescription(description2, null);
    }

    public void setDescription(String description2, String charset) throws MessagingException {
        if (description2 == null) {
            this.removeHeader("Content-Description");
        } else {
            try {
                this.setHeader("Content-Description", MimeUtility.fold(21, MimeUtility.encodeText(description2, charset, null)));
            }
            catch (UnsupportedEncodingException e2) {
                throw new MessagingException(e2.getMessage(), e2);
            }
        }
    }

    public String[] getContentLanguage() throws MessagingException {
        return this.getHeader("Content-Language");
    }

    public void setContentLanguage(String[] languages) throws MessagingException {
        if (languages == null) {
            this.removeHeader("Content-Language");
        } else if (languages.length == 1) {
            this.setHeader("Content-Language", languages[0]);
        } else {
            StringBuffer buf = new StringBuffer(languages.length * 20);
            buf.append(languages[0]);
            for (int i = 1; i < languages.length; ++i) {
                buf.append(',').append(languages[i]);
            }
            this.setHeader("Content-Language", buf.toString());
        }
    }

    public String getMessageID() throws MessagingException {
        return this.getSingleHeader("Message-ID");
    }

    public String getFileName() throws MessagingException {
        String type;
        String disposition = this.getDisposition();
        String filename = null;
        if (disposition != null) {
            filename = new ContentDisposition(disposition).getParameter("filename");
        }
        if (filename == null && (type = this.getContentType()) != null) {
            try {
                filename = new ContentType(type).getParameter("name");
            }
            catch (ParseException e2) {
                // empty catch block
            }
        }
        if (filename != null && SessionUtil.getBooleanProperty(this.session, MIME_DECODEFILENAME, false)) {
            try {
                filename = MimeUtility.decodeText(filename);
            }
            catch (UnsupportedEncodingException e3) {
                throw new MessagingException("Unable to decode filename", e3);
            }
        }
        return filename;
    }

    public void setFileName(String name) throws MessagingException {
        String disposition;
        if (name != null && SessionUtil.getBooleanProperty(this.session, MIME_ENCODEFILENAME, false)) {
            try {
                name = MimeUtility.encodeText(name);
            }
            catch (UnsupportedEncodingException e2) {
                throw new MessagingException("Unable to encode filename", e2);
            }
        }
        if ((disposition = this.getDisposition()) == null) {
            disposition = "attachment";
        }
        ContentDisposition contentDisposition = new ContentDisposition(disposition);
        contentDisposition.setParameter("filename", name);
        this.setDisposition(contentDisposition.toString());
    }

    public InputStream getInputStream() throws MessagingException, IOException {
        return this.getDataHandler().getInputStream();
    }

    protected InputStream getContentStream() throws MessagingException {
        if (this.contentStream != null) {
            return this.contentStream;
        }
        if (this.content != null) {
            return new ByteArrayInputStream(this.content);
        }
        throw new MessagingException("No content");
    }

    public InputStream getRawInputStream() throws MessagingException {
        return this.getContentStream();
    }

    public synchronized DataHandler getDataHandler() throws MessagingException {
        if (this.dh == null) {
            this.dh = new DataHandler((DataSource)new MimePartDataSource(this));
        }
        return this.dh;
    }

    public Object getContent() throws MessagingException, IOException {
        return this.getDataHandler().getContent();
    }

    public void setDataHandler(DataHandler handler) throws MessagingException {
        this.dh = handler;
        this.removeHeader("Content-Type");
        this.removeHeader("Content-Transfer-Encoding");
    }

    public void setContent(Object content2, String type) throws MessagingException {
        this.setDataHandler(new DataHandler(content2, type));
    }

    public void setText(String text2) throws MessagingException {
        this.setText(text2, null, "plain");
    }

    public void setText(String text2, String charset) throws MessagingException {
        this.setText(text2, charset, "plain");
    }

    public void setText(String text2, String charset, String subtype) throws MessagingException {
        if (charset == null) {
            charset = !ASCIIUtil.isAscii(text2) ? MimeUtility.getDefaultMIMECharset() : "us-ascii";
        }
        this.setContent(text2, "text/" + subtype + "; charset=" + MimeUtility.quote(charset, "()<>@,;:\\\"\t []/?="));
    }

    public void setContent(Multipart part) throws MessagingException {
        this.setDataHandler(new DataHandler((Object)part, part.getContentType()));
        part.setParent(this);
    }

    public Message reply(boolean replyToAll) throws MessagingException {
        String messageID;
        MimeMessage reply = this.createMimeMessage(this.session);
        String newSubject = this.getSubject();
        if (newSubject != null) {
            if (!newSubject.regionMatches(true, 0, "Re: ", 0, 4)) {
                newSubject = "Re: " + newSubject;
            }
            reply.setSubject(newSubject);
        }
        if ((messageID = this.getSingleHeader("Message-ID")) != null) {
            reply.setHeader("In-Reply-To", messageID);
            String references = this.getSingleHeader("References");
            references = references == null ? messageID : references + " " + messageID;
            reply.setHeader("References", MimeUtility.fold("References: ".length(), references));
        }
        Address[] toRecipients = this.getReplyTo();
        reply.setRecipients(Message.RecipientType.TO, this.getReplyTo());
        if (replyToAll) {
            Address[] toList2;
            String alternates;
            HashMap<String, InternetAddress> masterList = new HashMap<String, InternetAddress>();
            InternetAddress localMail = InternetAddress.getLocalAddress(this.session);
            if (localMail != null) {
                masterList.put(localMail.getAddress(), localMail);
            }
            if ((alternates = this.session.getProperty(MAIL_ALTERNATES)) != null) {
                Address[] alternateList = InternetAddress.parse(alternates, false);
                this.mergeAddressList(masterList, alternateList);
            }
            if ((toList2 = this.pruneAddresses(masterList, this.getRecipients(Message.RecipientType.TO))).length != 0) {
                if (SessionUtil.getBooleanProperty(this.session, MAIL_REPLYALLCC, false)) {
                    reply.addRecipients(Message.RecipientType.CC, toList2);
                } else {
                    reply.addRecipients(Message.RecipientType.TO, toList2);
                }
            }
            if ((toList2 = this.pruneAddresses(masterList, this.getRecipients(Message.RecipientType.CC))).length != 0) {
                reply.addRecipients(Message.RecipientType.CC, toList2);
            }
            if ((toList2 = this.getRecipients(RecipientType.NEWSGROUPS)) != null && toList2.length != 0) {
                reply.addRecipients((Message.RecipientType)RecipientType.NEWSGROUPS, toList2);
            }
        }
        this.setFlags(new Flags(Flags.Flag.ANSWERED), true);
        return reply;
    }

    private void mergeAddressList(Map master, Address[] list2) {
        if (list2 == null) {
            return;
        }
        for (int i = 0; i < list2.length; ++i) {
            InternetAddress address = (InternetAddress)list2[i];
            if (master.containsKey(address.getAddress())) continue;
            master.put(address.getAddress(), address);
        }
    }

    private Address[] pruneAddresses(Map master, Address[] list2) {
        if (list2 == null) {
            return new Address[0];
        }
        ArrayList<InternetAddress> prunedList = new ArrayList<InternetAddress>(list2.length);
        for (int i = 0; i < list2.length; ++i) {
            InternetAddress address = (InternetAddress)list2[i];
            if (master.containsKey(address.getAddress())) continue;
            master.put(address.getAddress(), address);
            prunedList.add(address);
        }
        return prunedList.toArray(new Address[0]);
    }

    public void writeTo(OutputStream out) throws MessagingException, IOException {
        this.writeTo(out, null);
    }

    public void writeTo(OutputStream out, String[] ignoreHeaders) throws MessagingException, IOException {
        if (!this.saved) {
            this.saveChanges();
        }
        this.headers.writeTo(out, ignoreHeaders);
        out.write(13);
        out.write(10);
        if (this.modified) {
            OutputStream encoderStream = MimeUtility.encode(out, this.getEncoding());
            this.dh.writeTo(encoderStream);
            encoderStream.flush();
        } else if (this.content != null) {
            out.write(this.content);
        } else {
            InputStream in2 = this.getContentStream();
            byte[] buffer = new byte[8192];
            int length2 = in2.read(buffer);
            while (length2 > 0) {
                out.write(buffer, 0, length2);
                length2 = in2.read(buffer);
            }
            in2.close();
        }
        out.flush();
    }

    public String[] getHeader(String name) throws MessagingException {
        return this.headers.getHeader(name);
    }

    public String getHeader(String name, String delimiter) throws MessagingException {
        return this.headers.getHeader(name, delimiter);
    }

    public void setHeader(String name, String value2) throws MessagingException {
        this.headers.setHeader(name, value2);
    }

    private void setOrRemoveHeader(String name, String value2) throws MessagingException {
        if (value2 == null) {
            this.headers.removeHeader(name);
        } else {
            this.headers.setHeader(name, value2);
        }
    }

    public void addHeader(String name, String value2) throws MessagingException {
        this.headers.addHeader(name, value2);
    }

    public void removeHeader(String name) throws MessagingException {
        this.headers.removeHeader(name);
    }

    public Enumeration getAllHeaders() throws MessagingException {
        return this.headers.getAllHeaders();
    }

    public Enumeration getMatchingHeaders(String[] names) throws MessagingException {
        return this.headers.getMatchingHeaders(names);
    }

    public Enumeration getNonMatchingHeaders(String[] names) throws MessagingException {
        return this.headers.getNonMatchingHeaders(names);
    }

    public void addHeaderLine(String line) throws MessagingException {
        this.headers.addHeaderLine(line);
    }

    public Enumeration getAllHeaderLines() throws MessagingException {
        return this.headers.getAllHeaderLines();
    }

    public Enumeration getMatchingHeaderLines(String[] names) throws MessagingException {
        return this.headers.getMatchingHeaderLines(names);
    }

    public Enumeration getNonMatchingHeaderLines(String[] names) throws MessagingException {
        return this.headers.getNonMatchingHeaderLines(names);
    }

    public synchronized Flags getFlags() throws MessagingException {
        return (Flags)this.flags.clone();
    }

    public synchronized boolean isSet(Flags.Flag flag) throws MessagingException {
        return this.flags.contains(flag);
    }

    public synchronized void setFlags(Flags flag, boolean set2) throws MessagingException {
        if (set2) {
            this.flags.add(flag);
        } else {
            this.flags.remove(flag);
        }
    }

    public void saveChanges() throws MessagingException {
        this.modified = true;
        this.saved = true;
        this.updateHeaders();
    }

    protected void updateHeaders() throws MessagingException {
        DataHandler handler = this.getDataHandler();
        try {
            String type = this.dh.getContentType();
            String explicitType = this.getSingleHeader("Content-Type");
            ContentType content2 = new ContentType(type);
            if (content2.match("multipart/*")) {
                try {
                    MimeMultipart part = (MimeMultipart)handler.getContent();
                    part.updateHeaders();
                }
                catch (ClassCastException e2) {
                    throw new MessagingException("Message content is not MimeMultipart", e2);
                }
            } else if (!content2.match("message/rfc822")) {
                if (this.getSingleHeader("Content-Transfer-Encoding") == null) {
                    this.setHeader("Content-Transfer-Encoding", MimeUtility.getEncoding(handler));
                }
                if (explicitType == null && SessionUtil.getBooleanProperty(this.session, "MIME_MAIL_SETDEFAULTTEXTCHARSET", true) && content2.match("text/*") && content2.getParameter("charset") == null) {
                    String encoding = this.getEncoding();
                    if (encoding != null && encoding.equalsIgnoreCase("7bit")) {
                        content2.setParameter("charset", "us-ascii");
                    } else {
                        content2.setParameter("charset", MimeUtility.getDefaultMIMECharset());
                    }
                    type = content2.toString();
                }
            }
            if (explicitType == null) {
                ContentDisposition disposition;
                String filename;
                String disp = this.getSingleHeader("Content-Disposition");
                if (disp != null && (filename = (disposition = new ContentDisposition(disp)).getParameter("filename")) != null) {
                    content2.setParameter("name", filename);
                    type = content2.toString();
                }
                this.setHeader("Content-Type", type);
            }
            this.setHeader("MIME-Version", "1.0");
            this.updateMessageID();
        }
        catch (IOException e3) {
            throw new MessagingException("Error updating message headers", e3);
        }
    }

    protected InternetHeaders createInternetHeaders(InputStream in2) throws MessagingException {
        return new InternetHeaders(in2);
    }

    private Address[] getHeaderAsNewsAddresses(String header) throws MessagingException {
        String mergedHeader = this.getHeader(header, ",");
        if (mergedHeader != null) {
            return NewsAddress.parse(mergedHeader);
        }
        return null;
    }

    private Address[] getHeaderAsInternetAddresses(String header, boolean strict) throws MessagingException {
        String mergedHeader = this.getHeader(header, ",");
        if (mergedHeader != null) {
            return InternetAddress.parseHeader(mergedHeader, strict);
        }
        return null;
    }

    private boolean isStrictAddressing() {
        return SessionUtil.getBooleanProperty(this.session, MIME_ADDRESS_STRICT, true);
    }

    private void setHeader(String header, Address address) throws MessagingException {
        if (address == null) {
            this.removeHeader(header);
        } else {
            this.setHeader(header, address.toString());
        }
    }

    private void setHeader(String header, Address[] addresses) {
        if (addresses == null) {
            this.headers.removeHeader(header);
        } else {
            this.headers.setHeader(header, addresses);
        }
    }

    private void addHeader(String header, Address[] addresses) throws MessagingException {
        this.headers.addHeader(header, InternetAddress.toString(addresses));
    }

    private String getHeaderForRecipientType(Message.RecipientType type) throws MessagingException {
        if (RecipientType.TO == type) {
            return "To";
        }
        if (RecipientType.CC == type) {
            return "Cc";
        }
        if (RecipientType.BCC == type) {
            return "Bcc";
        }
        if (RecipientType.NEWSGROUPS == type) {
            return "Newsgroups";
        }
        throw new MessagingException("Unsupported recipient type: " + type.toString());
    }

    private String getSingleHeader(String name) throws MessagingException {
        String[] values2 = this.getHeader(name);
        if (values2 == null || values2.length == 0) {
            return null;
        }
        return values2[0];
    }

    protected void updateMessageID() throws MessagingException {
        StringBuffer id2 = new StringBuffer();
        id2.append('<');
        id2.append(new Object().hashCode());
        id2.append('.');
        id2.append(messageID++);
        id2.append(System.currentTimeMillis());
        id2.append('.');
        id2.append("JavaMail.");
        InternetAddress localAddress = InternetAddress.getLocalAddress(this.session);
        if (localAddress != null) {
            id2.append(localAddress.getAddress());
        } else {
            id2.append("javamailuser@localhost");
        }
        id2.append('>');
        this.setHeader("Message-ID", id2.toString());
    }

    protected MimeMessage createMimeMessage(Session session) throws MessagingException {
        return new MimeMessage(session);
    }

    public static class RecipientType
    extends Message.RecipientType {
        public static final RecipientType NEWSGROUPS = new RecipientType("Newsgroups");

        protected RecipientType(String type) {
            super(type);
        }

        protected Object readResolve() throws ObjectStreamException {
            if (this.type.equals("Newsgroups")) {
                return NEWSGROUPS;
            }
            return super.readResolve();
        }
    }
}

