/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownServiceException;
import javax.activation.DataSource;
import javax.mail.MessageAware;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class MimePartDataSource
implements DataSource,
MessageAware {
    protected MimePart part;

    public MimePartDataSource(MimePart part) {
        this.part = part;
    }

    public InputStream getInputStream() throws IOException {
        try {
            InputStream stream2;
            if (this.part instanceof MimeMessage) {
                stream2 = ((MimeMessage)this.part).getContentStream();
            } else if (this.part instanceof MimeBodyPart) {
                stream2 = ((MimeBodyPart)this.part).getContentStream();
            } else {
                throw new MessagingException("Unknown part");
            }
            return this.checkPartEncoding(this.part, stream2);
        }
        catch (MessagingException e2) {
            throw (IOException)new IOException(e2.getMessage()).initCause(e2);
        }
    }

    private InputStream checkPartEncoding(MimePart part, InputStream stream2) throws MessagingException {
        String encoding = part.getEncoding();
        if (encoding == null) {
            return stream2;
        }
        if ((encoding = encoding.toLowerCase()).equals("7bit") || encoding.equals("8bit") || encoding.equals("binary")) {
            return stream2;
        }
        String contentType = part.getContentType();
        if (contentType != null) {
            try {
                ContentType type = new ContentType(contentType);
                if (type.match("multipart/*")) {
                    return stream2;
                }
            }
            catch (ParseException e2) {
                // empty catch block
            }
        }
        return MimeUtility.decode(stream2, encoding);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException();
    }

    public String getContentType() {
        try {
            return this.part.getContentType();
        }
        catch (MessagingException e2) {
            return null;
        }
    }

    public String getName() {
        try {
            if (this.part instanceof MimeBodyPart) {
                return ((MimeBodyPart)this.part).getFileName();
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return "";
    }

    public synchronized MessageContext getMessageContext() {
        return new MessageContext(this.part);
    }
}

