/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.search.SearchTerm;

public final class FlagTerm
extends SearchTerm {
    private static final long serialVersionUID = -142991500302030647L;
    protected boolean set;
    protected Flags flags;

    public FlagTerm(Flags flags2, boolean set2) {
        this.set = set2;
        this.flags = flags2;
    }

    public Flags getFlags() {
        return this.flags;
    }

    public boolean getTestSet() {
        return this.set;
    }

    public boolean match(Message message) {
        try {
            Flags msgFlags = message.getFlags();
            if (this.set) {
                return msgFlags.contains(this.flags);
            }
            Flags.Flag[] system = this.flags.getSystemFlags();
            for (int i = 0; i < system.length; ++i) {
                Flags.Flag flag = system[i];
                if (!msgFlags.contains(flag)) continue;
                return false;
            }
            String[] user = this.flags.getUserFlags();
            for (int i = 0; i < user.length; ++i) {
                String flag = user[i];
                if (!msgFlags.contains(flag)) continue;
                return false;
            }
            return true;
        }
        catch (MessagingException e2) {
            return false;
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FlagTerm)) {
            return false;
        }
        FlagTerm otherFlags = (FlagTerm)other;
        return otherFlags.set == this.set && otherFlags.flags.equals(this.flags);
    }

    public int hashCode() {
        return this.set ? this.flags.hashCode() : ~this.flags.hashCode();
    }
}

