/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.search.StringTerm;

public final class HeaderTerm
extends StringTerm {
    private static final long serialVersionUID = 8342514650333389122L;
    protected String headerName;

    public HeaderTerm(String header, String pattern) {
        super(pattern);
        this.headerName = header;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public boolean match(Message message) {
        try {
            String[] values2 = message.getHeader(this.headerName);
            if (values2 != null) {
                for (int i = 0; i < values2.length; ++i) {
                    String value2 = values2[i];
                    if (!this.match(value2)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (MessagingException e2) {
            return false;
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof HeaderTerm)) {
            return false;
        }
        return this.headerName.equalsIgnoreCase(((HeaderTerm)other).headerName) && super.equals(other);
    }

    public int hashCode() {
        return this.headerName.toLowerCase().hashCode() + super.hashCode();
    }
}

