/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.search.AddressStringTerm;

public final class RecipientStringTerm
extends AddressStringTerm {
    private static final long serialVersionUID = -8293562089611618849L;
    private Message.RecipientType type;

    public RecipientStringTerm(Message.RecipientType type, String pattern) {
        super(pattern);
        this.type = type;
    }

    public Message.RecipientType getRecipientType() {
        return this.type;
    }

    public boolean match(Message message) {
        try {
            Address[] from2 = message.getRecipients(this.type);
            if (from2 == null) {
                return false;
            }
            for (int i = 0; i < from2.length; ++i) {
                Address address = from2[i];
                if (!this.match(address)) continue;
                return true;
            }
            return false;
        }
        catch (MessagingException e2) {
            return false;
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RecipientStringTerm)) {
            return false;
        }
        RecipientStringTerm otherTerm = (RecipientStringTerm)other;
        return this.pattern.equals(otherTerm.pattern) && this.type == otherTerm.type;
    }

    public int hashCode() {
        return this.pattern.hashCode() + this.type.hashCode();
    }
}

