/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.search.SearchTerm;

public abstract class StringTerm
extends SearchTerm {
    private static final long serialVersionUID = 1274042129007696269L;
    protected boolean ignoreCase;
    protected String pattern;

    protected StringTerm(String pattern) {
        this(pattern, true);
    }

    protected StringTerm(String pattern, boolean ignoreCase2) {
        this.pattern = pattern;
        this.ignoreCase = ignoreCase2;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    protected boolean match(String match) {
        int matchLength = this.pattern.length();
        int length2 = match.length() - matchLength;
        for (int i = 0; i <= length2; ++i) {
            if (!match.regionMatches(this.ignoreCase, i, this.pattern, 0, matchLength)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StringTerm)) {
            return false;
        }
        StringTerm term2 = (StringTerm)other;
        if (this.ignoreCase) {
            return term2.pattern.equalsIgnoreCase(this.pattern) && term2.ignoreCase == this.ignoreCase;
        }
        return term2.pattern.equals(this.pattern) && term2.ignoreCase == this.ignoreCase;
    }

    public int hashCode() {
        return this.pattern.hashCode() + (this.ignoreCase ? 32 : 79);
    }
}

