/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class ByteArrayDataSource
implements DataSource {
    private byte[] source;
    private String contentType;
    private String name = "";

    public ByteArrayDataSource(InputStream in2, String type) throws IOException {
        int bytesRead;
        ByteArrayOutputStream sink = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((bytesRead = in2.read(buffer)) > 0) {
            sink.write(buffer, 0, bytesRead);
        }
        this.source = sink.toByteArray();
        this.contentType = type;
    }

    public ByteArrayDataSource(byte[] data2, String type) {
        this.source = data2;
        this.contentType = type;
    }

    public ByteArrayDataSource(String data2, String type) throws IOException {
        String charset = null;
        try {
            ContentType content2 = new ContentType(type);
            charset = content2.getParameter("charset");
        }
        catch (ParseException e2) {
            // empty catch block
        }
        charset = charset == null ? MimeUtility.getDefaultJavaCharset() : MimeUtility.javaCharset(charset);
        this.source = data2.getBytes(charset);
        this.contentType = type;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.source);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("Writing to a ByteArrayDataSource is not supported");
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

