/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.dsig;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLDSigSecurity;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;

public abstract class TransformService
implements Transform {
    private String algorithm;
    private String mechanism;
    private Provider provider;

    protected TransformService() {
    }

    public static TransformService getInstance(String string2, String string3) throws NoSuchAlgorithmException {
        if (string3 == null || string2 == null) {
            throw new NullPointerException();
        }
        return TransformService.findInstance(string2, string3, null);
    }

    public static TransformService getInstance(String string2, String string3, Provider provider) throws NoSuchAlgorithmException {
        if (string3 == null || string2 == null || provider == null) {
            throw new NullPointerException();
        }
        return TransformService.findInstance(string2, string3, provider);
    }

    public static TransformService getInstance(String string2, String string3, String string4) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string3 == null || string2 == null || string4 == null) {
            throw new NullPointerException();
        }
        Provider provider = Security.getProvider(string4);
        if (provider == null) {
            throw new NoSuchProviderException("cannot find provider named " + string4);
        }
        return TransformService.findInstance(string2, string3, provider);
    }

    private static TransformService findInstance(String string2, String string3, Provider provider) throws NoSuchAlgorithmException {
        Object[] objectArray = XMLDSigSecurity.getImpl(string2, new MechanismMapEntry(string2, string3), "TransformService", provider);
        TransformService transformService = (TransformService)objectArray[0];
        transformService.mechanism = string3;
        transformService.algorithm = string2;
        transformService.provider = (Provider)objectArray[1];
        return transformService;
    }

    public final String getMechanismType() {
        return this.mechanism;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public abstract void init(TransformParameterSpec var1) throws InvalidAlgorithmParameterException;

    public abstract void marshalParams(XMLStructure var1, XMLCryptoContext var2) throws MarshalException;

    public abstract void init(XMLStructure var1, XMLCryptoContext var2) throws InvalidAlgorithmParameterException;

    private static class MechanismMapEntry
    implements Map.Entry {
        private final String mechanism;
        private final String key;

        MechanismMapEntry(String string2, String string3) {
            this.mechanism = string3;
            this.key = "TransformService." + string2 + " MechanismType";
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry2 = (Map.Entry)object;
            return (this.getKey() == null ? entry2.getKey() == null : this.getKey().equals(entry2.getKey())) && (this.getValue() == null ? entry2.getValue() == null : this.getValue().equals(entry2.getValue()));
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.mechanism;
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }
    }
}

