/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.dsig;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.Map;
import javax.xml.crypto.NoSuchMechanismException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;

final class XMLDSigSecurity {
    private XMLDSigSecurity() {
    }

    private static ProviderProperty getEngineClassName(String string2, Map.Entry entry2, String string3, String string4, boolean bl) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        boolean bl2 = false;
        ProviderProperty providerProperty = null;
        for (int i = 0; i < providerArray.length && !bl2; ++i) {
            try {
                providerProperty = XMLDSigSecurity.getEngineClassName(string2, entry2, string3, string4, providerArray[i], bl);
                bl2 = true;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl2) {
            if (bl) {
                throw new NoSuchMechanismException("Mechanism type " + string2 + " not available");
            }
            throw new NoSuchAlgorithmException("Algorithm type " + string2 + " not available");
        }
        return providerProperty;
    }

    private static ProviderProperty getEngineClassName(String string2, Map.Entry entry2, String string3, String string4, Provider provider, boolean bl) throws NoSuchAlgorithmException {
        Object object;
        String string5 = XMLDSigSecurity.getProviderProperty(string4, entry2, provider);
        if (string5 == null) {
            object = XMLDSigSecurity.getStandardName(string2, string3, provider);
            if (object != null) {
                string4 = string3 + "." + (String)object;
            }
            if (object == null || (string5 = XMLDSigSecurity.getProviderProperty(string4, entry2, provider)) == null) {
                if (bl) {
                    throw new NoSuchMechanismException("no such mechanism type: " + string2 + " for provider " + provider.getName());
                }
                throw new NoSuchAlgorithmException("no such algorithm: " + string2 + " for provider " + provider.getName());
            }
        }
        object = new ProviderProperty();
        ((ProviderProperty)object).className = string5;
        ((ProviderProperty)object).provider = provider;
        return object;
    }

    private static boolean checkSuperclass(Class clazz2, Class clazz3) {
        return clazz3.isAssignableFrom(clazz2);
    }

    static Object[] getImpl(String string2, String string3, Provider provider) throws NoSuchAlgorithmException {
        return XMLDSigSecurity.getImpl(string2, null, string3, provider);
    }

    static Object[] getImpl(String string2, Map.Entry entry2, String string3, Provider provider) throws NoSuchAlgorithmException {
        Class clazz2 = null;
        boolean bl = true;
        if (string3.equals("XMLSignatureFactory")) {
            clazz2 = XMLSignatureFactory.class;
        } else if (string3.equals("KeyInfoFactory")) {
            clazz2 = KeyInfoFactory.class;
        } else if (string3.equals("TransformService")) {
            clazz2 = TransformService.class;
            bl = false;
        }
        String string4 = string3 + "." + string2;
        if (provider == null) {
            return XMLDSigSecurity.doGetImpl(string3, clazz2, XMLDSigSecurity.getEngineClassName(string2, entry2, string3, string4, bl), bl);
        }
        return XMLDSigSecurity.doGetImpl(string3, clazz2, XMLDSigSecurity.getEngineClassName(string2, entry2, string3, string4, provider, bl), bl);
    }

    private static Object[] doGetImpl(String string2, Class clazz2, ProviderProperty providerProperty, boolean bl) throws NoSuchAlgorithmException {
        String string3 = providerProperty.className;
        String string4 = providerProperty.provider.getName();
        try {
            ClassLoader classLoader = clazz2.getClassLoader();
            Class<?> clazz3 = classLoader != null ? classLoader.loadClass(string3) : Class.forName(string3);
            if (XMLDSigSecurity.checkSuperclass(clazz3, clazz2)) {
                return new Object[]{clazz3.newInstance(), providerProperty.provider};
            }
            if (bl) {
                throw new NoSuchMechanismException("class configured for " + string2 + ": " + string3 + " not a " + string2);
            }
            throw new NoSuchAlgorithmException("class configured for " + string2 + ": " + string3 + " not a " + string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (bl) {
                throw new NoSuchMechanismException("class configured for " + string2 + "(provider: " + string4 + ")" + "cannot be found.\n", classNotFoundException);
            }
            throw (NoSuchAlgorithmException)new NoSuchAlgorithmException("class configured for " + string2 + "(provider: " + string4 + ")" + "cannot be found.\n").initCause(classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            if (bl) {
                throw new NoSuchMechanismException("class " + string3 + " configured for " + string2 + "(provider: " + string4 + ") cannot be " + "instantiated. ", instantiationException);
            }
            throw (NoSuchAlgorithmException)new NoSuchAlgorithmException("class " + string3 + " configured for " + string2 + "(provider: " + string4 + ") cannot be " + "instantiated. ").initCause(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            if (bl) {
                throw new NoSuchMechanismException("class " + string3 + " configured for " + string2 + "(provider: " + string4 + ") cannot be accessed.\n", illegalAccessException);
            }
            throw (NoSuchAlgorithmException)new NoSuchAlgorithmException("class " + string3 + " configured for " + string2 + "(provider: " + string4 + ") cannot be accessed.\n").initCause(illegalAccessException);
        }
    }

    private static String getProviderProperty(String string2, Map.Entry entry2, Provider provider) {
        String string3 = provider.getProperty(string2);
        if (string3 == null) {
            Enumeration<Object> enumeration = provider.keys();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                if (!string2.equalsIgnoreCase(string4)) continue;
                string3 = provider.getProperty(string4);
                break;
            }
        }
        if (!(string3 == null || entry2 == null || provider.entrySet().contains(entry2) || entry2.getValue().equals("DOM") && provider.get(entry2.getKey()) == null)) {
            string3 = null;
        }
        return string3;
    }

    private static String getStandardName(String string2, String string3, Provider provider) {
        return XMLDSigSecurity.getProviderProperty("Alg.Alias." + string3 + "." + string2, null, provider);
    }

    private static class ProviderProperty {
        String className;
        Provider provider;

        private ProviderProperty() {
        }
    }
}

