/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.dsig.spec;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class XPathType {
    private final String expression;
    private final Filter filter;
    private Map nsMap;

    public XPathType(String string2, Filter filter2) {
        if (string2 == null) {
            throw new NullPointerException("expression cannot be null");
        }
        if (filter2 == null) {
            throw new NullPointerException("filter cannot be null");
        }
        this.expression = string2;
        this.filter = filter2;
        this.nsMap = Collections.EMPTY_MAP;
    }

    public XPathType(String string2, Filter filter2, Map map3) {
        this(string2, filter2);
        if (map3 == null) {
            throw new NullPointerException("namespaceMap cannot be null");
        }
        this.nsMap = new HashMap(map3);
        Iterator iterator2 = this.nsMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry2 = iterator2.next();
            if (entry2.getKey() instanceof String && entry2.getValue() instanceof String) continue;
            throw new ClassCastException("not a String");
        }
        this.nsMap = Collections.unmodifiableMap(this.nsMap);
    }

    public String getExpression() {
        return this.expression;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Map getNamespaceMap() {
        return this.nsMap;
    }

    public static class Filter {
        private final String operation;
        public static final Filter INTERSECT = new Filter("intersect");
        public static final Filter SUBTRACT = new Filter("subtract");
        public static final Filter UNION = new Filter("union");

        private Filter(String string2) {
            this.operation = string2;
        }

        public String toString() {
            return this.operation;
        }
    }
}

