/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.json;

import java.io.Reader;
import java.io.StringReader;
import net.liftweb.json.JsonAST;
import net.liftweb.json.JsonParser;
import net.liftweb.json.JsonParser$;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.math.BigDecimal;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class JsonParser$ {
    public static final JsonParser$ MODULE$;
    private final BigDecimal BrokenDouble;
    private final Function1<JsonParser.Parser, JsonAST.JValue> astParser;
    private final char net$liftweb$json$JsonParser$$EOF;

    static {
        new JsonParser$();
    }

    public JsonAST.JValue parse(String s2) {
        return this.parse(new JsonParser.Buffer(new StringReader(s2), false));
    }

    public JsonAST.JValue parse(Reader s2, boolean closeAutomatically) {
        return this.parse(new JsonParser.Buffer(s2, closeAutomatically));
    }

    public Option<JsonAST.JValue> parseOpt(String s2) {
        Option option;
        try {
            option = this.parse(s2).toOpt();
        }
        catch (Exception exception) {
            option = None$.MODULE$;
        }
        return option;
    }

    public Option<JsonAST.JValue> parseOpt(Reader s2, boolean closeAutomatically) {
        Option option;
        try {
            option = this.parse(s2, closeAutomatically).toOpt();
        }
        catch (Exception exception) {
            option = None$.MODULE$;
        }
        return option;
    }

    public <A> A parse(String s2, Function1<JsonParser.Parser, A> p) {
        return this.parse((Reader)new StringReader(s2), p);
    }

    public <A> A parse(Reader s2, Function1<JsonParser.Parser, A> p) {
        return p.apply(new JsonParser.Parser(new JsonParser.Buffer(s2, false)));
    }

    private JsonAST.JValue parse(JsonParser.Buffer buf) {
        try {
            return this.astParser().apply(new JsonParser.Parser(buf));
        }
        catch (Exception exception) {
            throw new JsonParser.ParseException("parsing failed", exception);
        }
        catch (JsonParser.ParseException parseException) {
            throw parseException;
        }
        finally {
            buf.release();
        }
    }

    public boolean parse$default$2() {
        return true;
    }

    public boolean parseOpt$default$2() {
        return true;
    }

    public String unquote(String string2) {
        return this.unquote(new JsonParser.Buffer(new StringReader(string2), false));
    }

    public String unquote(JsonParser.Buffer buf) {
        buf.eofIsFailure_$eq(true);
        buf.mark();
        char c2 = buf.next();
        while (c2 != '\"') {
            if (c2 == '\\') {
                String s2 = this.unquote0$1(buf, buf.substring());
                buf.eofIsFailure_$eq(false);
                return s2;
            }
            c2 = buf.next();
        }
        buf.eofIsFailure_$eq(false);
        return buf.substring();
    }

    private BigDecimal BrokenDouble() {
        return this.BrokenDouble;
    }

    public double parseDouble(String s2) {
        BigDecimal d = scala.package$.MODULE$.BigDecimal().apply(s2);
        if (BoxesRunTime.equalsNumNum(d, this.BrokenDouble())) {
            throw package$.MODULE$.error("Error parsing 2.2250738585072012e-308");
        }
        return d.doubleValue();
    }

    private Function1<JsonParser.Parser, JsonAST.JValue> astParser() {
        return this.astParser;
    }

    public char net$liftweb$json$JsonParser$$EOF() {
        return this.net$liftweb$json$JsonParser$$EOF;
    }

    private final String unquote0$1(JsonParser.Buffer buf, String base) {
        StringBuilder s2 = new StringBuilder(base);
        char c2 = '\\';
        while (c2 != '\"') {
            StringBuilder stringBuilder;
            if (c2 == '\\') {
                char c3 = buf.next();
                switch (c3) {
                    default: {
                        stringBuilder = s2.append('\\');
                        break;
                    }
                    case 'u': {
                        char[] chars = Array$.MODULE$.apply(buf.next(), (Seq<Object>)Predef$.MODULE$.wrapCharArray(new char[]{buf.next(), buf.next(), buf.next()}));
                        int codePoint = Integer.parseInt(new String(chars), 16);
                        stringBuilder = s2.appendCodePoint(codePoint);
                        break;
                    }
                    case 't': {
                        stringBuilder = s2.append('\t');
                        break;
                    }
                    case 'r': {
                        stringBuilder = s2.append('\r');
                        break;
                    }
                    case 'n': {
                        stringBuilder = s2.append('\n');
                        break;
                    }
                    case 'f': {
                        stringBuilder = s2.append('\f');
                        break;
                    }
                    case 'b': {
                        stringBuilder = s2.append('\b');
                        break;
                    }
                    case '/': {
                        stringBuilder = s2.append('/');
                        break;
                    }
                    case '\\': {
                        stringBuilder = s2.append('\\');
                        break;
                    }
                    case '\"': {
                        stringBuilder = s2.append('\"');
                        break;
                    }
                }
            } else {
                stringBuilder = s2.append(c2);
            }
            c2 = buf.next();
        }
        return s2.toString();
    }

    private JsonParser$() {
        MODULE$ = this;
        this.BrokenDouble = scala.package$.MODULE$.BigDecimal().apply("2.2250738585072012e-308");
        this.astParser = new anonfun.2();
        this.net$liftweb$json$JsonParser$$EOF = (char)-1;
    }
}

