/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.core;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.cglib.asm.Attribute;
import net.sf.cglib.asm.Type;
import net.sf.cglib.core.ClassInfo;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.MethodInfo;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;

public class ReflectUtils {
    private static final Map primitives = new HashMap(8);
    private static final Map transforms = new HashMap(8);
    private static final ClassLoader defaultLoader = (class$net$sf$cglib$core$ReflectUtils == null ? (class$net$sf$cglib$core$ReflectUtils = ReflectUtils.class$("net.sf.cglib.core.ReflectUtils")) : class$net$sf$cglib$core$ReflectUtils).getClassLoader();
    private static Method DEFINE_CLASS;
    private static final ProtectionDomain PROTECTION_DOMAIN;
    private static final String[] CGLIB_PACKAGES;
    static /* synthetic */ Class class$net$sf$cglib$core$ReflectUtils;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$security$ProtectionDomain;
    static /* synthetic */ Class class$java$lang$Object;

    private ReflectUtils() {
    }

    public static Type[] getExceptionTypes(Member member) {
        if (member instanceof Method) {
            return TypeUtils.getTypes(((Method)member).getExceptionTypes());
        }
        if (member instanceof Constructor) {
            return TypeUtils.getTypes(((Constructor)member).getExceptionTypes());
        }
        throw new IllegalArgumentException("Cannot get exception types of a field");
    }

    public static Signature getSignature(Member member) {
        if (member instanceof Method) {
            return new Signature(member.getName(), Type.getMethodDescriptor((Method)member));
        }
        if (member instanceof Constructor) {
            Type[] types2 = TypeUtils.getTypes(((Constructor)member).getParameterTypes());
            return new Signature("<init>", Type.getMethodDescriptor(Type.VOID_TYPE, types2));
        }
        throw new IllegalArgumentException("Cannot get signature of a field");
    }

    public static Constructor findConstructor(String desc) {
        return ReflectUtils.findConstructor(desc, defaultLoader);
    }

    public static Constructor findConstructor(String desc, ClassLoader loader) {
        try {
            int lparen = desc.indexOf(40);
            String className = desc.substring(0, lparen).trim();
            return ReflectUtils.getClass(className, loader).getConstructor(ReflectUtils.parseTypes(desc, loader));
        }
        catch (ClassNotFoundException e2) {
            throw new CodeGenerationException(e2);
        }
        catch (NoSuchMethodException e3) {
            throw new CodeGenerationException(e3);
        }
    }

    public static Method findMethod(String desc) {
        return ReflectUtils.findMethod(desc, defaultLoader);
    }

    public static Method findMethod(String desc, ClassLoader loader) {
        try {
            int lparen = desc.indexOf(40);
            int dot = desc.lastIndexOf(46, lparen);
            String className = desc.substring(0, dot).trim();
            String methodName = desc.substring(dot + 1, lparen).trim();
            return ReflectUtils.getClass(className, loader).getDeclaredMethod(methodName, ReflectUtils.parseTypes(desc, loader));
        }
        catch (ClassNotFoundException e2) {
            throw new CodeGenerationException(e2);
        }
        catch (NoSuchMethodException e3) {
            throw new CodeGenerationException(e3);
        }
    }

    private static Class[] parseTypes(String desc, ClassLoader loader) throws ClassNotFoundException {
        int comma;
        int lparen = desc.indexOf(40);
        int rparen = desc.indexOf(41, lparen);
        ArrayList<String> params2 = new ArrayList<String>();
        int start2 = lparen + 1;
        while ((comma = desc.indexOf(44, start2)) >= 0) {
            params2.add(desc.substring(start2, comma).trim());
            start2 = comma + 1;
        }
        if (start2 < rparen) {
            params2.add(desc.substring(start2, rparen).trim());
        }
        Class[] types2 = new Class[params2.size()];
        for (int i = 0; i < types2.length; ++i) {
            types2[i] = ReflectUtils.getClass((String)params2.get(i), loader);
        }
        return types2;
    }

    private static Class getClass(String className, ClassLoader loader) throws ClassNotFoundException {
        return ReflectUtils.getClass(className, loader, CGLIB_PACKAGES);
    }

    private static Class getClass(String className, ClassLoader loader, String[] packages2) throws ClassNotFoundException {
        String save2 = className;
        int dimensions = 0;
        int index2 = 0;
        while ((index2 = className.indexOf("[]", index2) + 1) > 0) {
            ++dimensions;
        }
        StringBuffer brackets = new StringBuffer(className.length() - dimensions);
        for (int i = 0; i < dimensions; ++i) {
            brackets.append('[');
        }
        className = className.substring(0, className.length() - 2 * dimensions);
        String prefix2 = dimensions > 0 ? brackets + "L" : "";
        String suffix = dimensions > 0 ? ";" : "";
        try {
            return Class.forName(prefix2 + className + suffix, false, loader);
        }
        catch (ClassNotFoundException ignore2) {
            for (int i = 0; i < packages2.length; ++i) {
                try {
                    return Class.forName(prefix2 + packages2[i] + '.' + className + suffix, false, loader);
                }
                catch (ClassNotFoundException ignore3) {
                    continue;
                }
            }
            if (dimensions == 0) {
                Class c2 = (Class)primitives.get(className);
                if (c2 != null) {
                    return c2;
                }
            } else {
                String transform2 = (String)transforms.get(className);
                if (transform2 != null) {
                    try {
                        return Class.forName(brackets + transform2, false, loader);
                    }
                    catch (ClassNotFoundException ignore4) {
                        // empty catch block
                    }
                }
            }
            throw new ClassNotFoundException(save2);
        }
    }

    public static Object newInstance(Class type) {
        return ReflectUtils.newInstance(type, Constants.EMPTY_CLASS_ARRAY, null);
    }

    public static Object newInstance(Class type, Class[] parameterTypes, Object[] args2) {
        return ReflectUtils.newInstance(ReflectUtils.getConstructor(type, parameterTypes), args2);
    }

    public static Object newInstance(Constructor cstruct, Object[] args2) {
        boolean flag = cstruct.isAccessible();
        try {
            Object result2;
            cstruct.setAccessible(true);
            Object t2 = result2 = cstruct.newInstance(args2);
            return t2;
        }
        catch (InstantiationException e2) {
            throw new CodeGenerationException(e2);
        }
        catch (IllegalAccessException e3) {
            throw new CodeGenerationException(e3);
        }
        catch (InvocationTargetException e4) {
            throw new CodeGenerationException(e4.getTargetException());
        }
        finally {
            cstruct.setAccessible(flag);
        }
    }

    public static Constructor getConstructor(Class type, Class[] parameterTypes) {
        try {
            Constructor constructor = type.getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException e2) {
            throw new CodeGenerationException(e2);
        }
    }

    public static String[] getNames(Class[] classes2) {
        if (classes2 == null) {
            return null;
        }
        String[] names = new String[classes2.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = classes2[i].getName();
        }
        return names;
    }

    public static Class[] getClasses(Object[] objects) {
        Class[] classes2 = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            classes2[i] = objects[i].getClass();
        }
        return classes2;
    }

    public static Method findNewInstance(Class iface) {
        Method m = ReflectUtils.findInterfaceMethod(iface);
        if (!m.getName().equals("newInstance")) {
            throw new IllegalArgumentException(iface + " missing newInstance method");
        }
        return m;
    }

    public static Method[] getPropertyMethods(PropertyDescriptor[] properties2, boolean read2, boolean write2) {
        HashSet<Method> methods2 = new HashSet<Method>();
        for (int i = 0; i < properties2.length; ++i) {
            PropertyDescriptor pd = properties2[i];
            if (read2) {
                methods2.add(pd.getReadMethod());
            }
            if (!write2) continue;
            methods2.add(pd.getWriteMethod());
        }
        methods2.remove(null);
        return methods2.toArray(new Method[methods2.size()]);
    }

    public static PropertyDescriptor[] getBeanProperties(Class type) {
        return ReflectUtils.getPropertiesHelper(type, true, true);
    }

    public static PropertyDescriptor[] getBeanGetters(Class type) {
        return ReflectUtils.getPropertiesHelper(type, true, false);
    }

    public static PropertyDescriptor[] getBeanSetters(Class type) {
        return ReflectUtils.getPropertiesHelper(type, false, true);
    }

    private static PropertyDescriptor[] getPropertiesHelper(Class type, boolean read2, boolean write2) {
        try {
            BeanInfo info2 = Introspector.getBeanInfo(type, class$java$lang$Object == null ? (class$java$lang$Object = ReflectUtils.class$("java.lang.Object")) : class$java$lang$Object);
            PropertyDescriptor[] all2 = info2.getPropertyDescriptors();
            if (read2 && write2) {
                return all2;
            }
            ArrayList<PropertyDescriptor> properties2 = new ArrayList<PropertyDescriptor>(all2.length);
            for (int i = 0; i < all2.length; ++i) {
                PropertyDescriptor pd = all2[i];
                if ((!read2 || pd.getReadMethod() == null) && (!write2 || pd.getWriteMethod() == null)) continue;
                properties2.add(pd);
            }
            return properties2.toArray(new PropertyDescriptor[properties2.size()]);
        }
        catch (IntrospectionException e2) {
            throw new CodeGenerationException(e2);
        }
    }

    public static Method findDeclaredMethod(Class type, String methodName, Class[] parameterTypes) throws NoSuchMethodException {
        for (Class cl = type; cl != null; cl = cl.getSuperclass()) {
            try {
                return cl.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e2) {
                continue;
            }
        }
        throw new NoSuchMethodException(methodName);
    }

    public static List addAllMethods(Class type, List list2) {
        list2.addAll(Arrays.asList(type.getDeclaredMethods()));
        Class superclass = type.getSuperclass();
        if (superclass != null) {
            ReflectUtils.addAllMethods(superclass, list2);
        }
        Class<?>[] interfaces2 = type.getInterfaces();
        for (int i = 0; i < interfaces2.length; ++i) {
            ReflectUtils.addAllMethods(interfaces2[i], list2);
        }
        return list2;
    }

    public static List addAllInterfaces(Class type, List list2) {
        Class superclass = type.getSuperclass();
        if (superclass != null) {
            list2.addAll(Arrays.asList(type.getInterfaces()));
            ReflectUtils.addAllInterfaces(superclass, list2);
        }
        return list2;
    }

    public static Method findInterfaceMethod(Class iface) {
        if (!iface.isInterface()) {
            throw new IllegalArgumentException(iface + " is not an interface");
        }
        Method[] methods2 = iface.getDeclaredMethods();
        if (methods2.length != 1) {
            throw new IllegalArgumentException("expecting exactly 1 method in " + iface);
        }
        return methods2[0];
    }

    public static Class defineClass(String className, byte[] b, ClassLoader loader) throws Exception {
        Object[] args2 = new Object[]{className, b, new Integer(0), new Integer(b.length), PROTECTION_DOMAIN};
        return (Class)DEFINE_CLASS.invoke((Object)loader, args2);
    }

    public static int findPackageProtected(Class[] classes2) {
        for (int i = 0; i < classes2.length; ++i) {
            if (Modifier.isPublic(classes2[i].getModifiers())) continue;
            return i;
        }
        return 0;
    }

    public static MethodInfo getMethodInfo(final Member member, final int modifiers) {
        final Signature sig = ReflectUtils.getSignature(member);
        return new MethodInfo(){
            private ClassInfo ci;

            public ClassInfo getClassInfo() {
                if (this.ci == null) {
                    this.ci = ReflectUtils.getClassInfo(member.getDeclaringClass());
                }
                return this.ci;
            }

            public int getModifiers() {
                return modifiers;
            }

            public Signature getSignature() {
                return sig;
            }

            public Type[] getExceptionTypes() {
                return ReflectUtils.getExceptionTypes(member);
            }

            public Attribute getAttribute() {
                return null;
            }
        };
    }

    public static MethodInfo getMethodInfo(Member member) {
        return ReflectUtils.getMethodInfo(member, member.getModifiers());
    }

    public static ClassInfo getClassInfo(final Class clazz2) {
        final Type type = Type.getType(clazz2);
        final Type sc = clazz2.getSuperclass() == null ? null : Type.getType(clazz2.getSuperclass());
        return new ClassInfo(){

            public Type getType() {
                return type;
            }

            public Type getSuperType() {
                return sc;
            }

            public Type[] getInterfaces() {
                return TypeUtils.getTypes(clazz2.getInterfaces());
            }

            public int getModifiers() {
                return clazz2.getModifiers();
            }
        };
    }

    public static Method[] findMethods(String[] namesAndDescriptors, Method[] methods2) {
        HashMap<String, Method> map3 = new HashMap<String, Method>();
        for (int i = 0; i < methods2.length; ++i) {
            Method method = methods2[i];
            map3.put(method.getName() + Type.getMethodDescriptor(method), method);
        }
        Method[] result2 = new Method[namesAndDescriptors.length / 2];
        for (int i = 0; i < result2.length; ++i) {
            result2[i] = (Method)map3.get(namesAndDescriptors[i * 2] + namesAndDescriptors[i * 2 + 1]);
            if (result2[i] != null) continue;
        }
        return result2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PROTECTION_DOMAIN = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return (class$net$sf$cglib$core$ReflectUtils == null ? (class$net$sf$cglib$core$ReflectUtils = ReflectUtils.class$("net.sf.cglib.core.ReflectUtils")) : class$net$sf$cglib$core$ReflectUtils).getProtectionDomain();
            }
        });
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class<?> loader = Class.forName("java.lang.ClassLoader");
                    DEFINE_CLASS = loader.getDeclaredMethod("defineClass", class$java$lang$String == null ? (class$java$lang$String = ReflectUtils.class$("java.lang.String")) : class$java$lang$String, array$B == null ? (array$B = ReflectUtils.class$("[B")) : array$B, Integer.TYPE, Integer.TYPE, class$java$security$ProtectionDomain == null ? (class$java$security$ProtectionDomain = ReflectUtils.class$("java.security.ProtectionDomain")) : class$java$security$ProtectionDomain);
                    DEFINE_CLASS.setAccessible(true);
                }
                catch (ClassNotFoundException e2) {
                    throw new CodeGenerationException(e2);
                }
                catch (NoSuchMethodException e3) {
                    throw new CodeGenerationException(e3);
                }
                return null;
            }
        });
        CGLIB_PACKAGES = new String[]{"java.lang"};
        primitives.put("byte", Byte.TYPE);
        primitives.put("char", Character.TYPE);
        primitives.put("double", Double.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("int", Integer.TYPE);
        primitives.put("long", Long.TYPE);
        primitives.put("short", Short.TYPE);
        primitives.put("boolean", Boolean.TYPE);
        transforms.put("byte", "B");
        transforms.put("char", "C");
        transforms.put("double", "D");
        transforms.put("float", "F");
        transforms.put("int", "I");
        transforms.put("long", "J");
        transforms.put("short", "S");
        transforms.put("boolean", "Z");
    }
}

