/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.proxy;

import java.util.Iterator;
import java.util.List;
import net.sf.cglib.asm.Type;
import net.sf.cglib.core.Block;
import net.sf.cglib.core.ClassEmitter;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.EmitUtils;
import net.sf.cglib.core.MethodInfo;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;
import net.sf.cglib.proxy.CallbackGenerator;

class InvocationHandlerGenerator
implements CallbackGenerator {
    public static final InvocationHandlerGenerator INSTANCE = new InvocationHandlerGenerator();
    private static final Type INVOCATION_HANDLER = TypeUtils.parseType("net.sf.cglib.proxy.InvocationHandler");
    private static final Type UNDECLARED_THROWABLE_EXCEPTION = TypeUtils.parseType("net.sf.cglib.proxy.UndeclaredThrowableException");
    private static final Type METHOD = TypeUtils.parseType("java.lang.reflect.Method");
    private static final Signature INVOKE = TypeUtils.parseSignature("Object invoke(Object, java.lang.reflect.Method, Object[])");

    InvocationHandlerGenerator() {
    }

    public void generate(ClassEmitter ce, CallbackGenerator.Context context, List methods2) {
        Iterator it = methods2.iterator();
        while (it.hasNext()) {
            MethodInfo method = (MethodInfo)it.next();
            Signature impl = context.getImplSignature(method);
            ce.declare_field(26, impl.getName(), METHOD, null);
            CodeEmitter e2 = context.beginMethod(ce, method);
            Block handler = e2.begin_block();
            context.emitCallback(e2, context.getIndex(method));
            e2.load_this();
            e2.getfield(impl.getName());
            e2.create_arg_array();
            e2.invoke_interface(INVOCATION_HANDLER, INVOKE);
            e2.unbox(method.getSignature().getReturnType());
            e2.return_value();
            handler.end();
            EmitUtils.wrap_undeclared_throwable(e2, handler, method.getExceptionTypes(), UNDECLARED_THROWABLE_EXCEPTION);
            e2.end_method();
        }
    }

    public void generateStatic(CodeEmitter e2, CallbackGenerator.Context context, List methods2) {
        Iterator it = methods2.iterator();
        while (it.hasNext()) {
            MethodInfo method = (MethodInfo)it.next();
            EmitUtils.load_method(e2, method);
            e2.putfield(context.getImplSignature(method).getName());
        }
    }
}

