/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.transform;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.sf.cglib.asm.Attribute;
import net.sf.cglib.asm.ClassReader;
import net.sf.cglib.asm.ClassWriter;
import net.sf.cglib.core.ClassNameReader;
import net.sf.cglib.core.DebuggingClassWriter;
import net.sf.cglib.transform.AbstractProcessTask;
import net.sf.cglib.transform.ClassReaderGenerator;
import net.sf.cglib.transform.ClassTransformer;
import net.sf.cglib.transform.TransformingClassGenerator;

public abstract class AbstractTransformTask
extends AbstractProcessTask {
    private static final int ZIP_MAGIC = 1347093252;
    private static final int CLASS_MAGIC = -889275714;
    private boolean verbose;

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected abstract ClassTransformer getClassTransformer(String[] var1);

    protected Attribute[] attributes() {
        return null;
    }

    protected void processFile(File file) throws Exception {
        if (this.isClassFile(file)) {
            this.processClassFile(file);
        } else if (this.isJarFile(file)) {
            this.processJarFile(file);
        } else {
            this.log("ignoring " + file.toURL(), 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClassFile(File file) throws Exception, FileNotFoundException, IOException, MalformedURLException {
        ClassReader reader2 = AbstractTransformTask.getClassReader(file);
        String[] name = ClassNameReader.getClassInfo(reader2);
        DebuggingClassWriter w = new DebuggingClassWriter(1);
        ClassTransformer t2 = this.getClassTransformer(name);
        if (t2 != null) {
            if (this.verbose) {
                this.log("processing " + file.toURL());
            }
            new TransformingClassGenerator(new ClassReaderGenerator(AbstractTransformTask.getClassReader(file), this.attributes(), this.getFlags()), t2).generateClass(w);
            FileOutputStream fos = new FileOutputStream(file);
            try {
                fos.write(((ClassWriter)w).toByteArray());
            }
            finally {
                fos.close();
            }
        }
    }

    protected int getFlags() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassReader getClassReader(File file) throws Exception {
        BufferedInputStream in2 = new BufferedInputStream(new FileInputStream(file));
        try {
            ClassReader r;
            ClassReader classReader = r = new ClassReader(in2);
            return classReader;
        }
        finally {
            ((InputStream)in2).close();
        }
    }

    protected boolean isClassFile(File file) throws IOException {
        return this.checkMagic(file, -889275714L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processJarFile(File file) throws Exception {
        block19: {
            if (this.verbose) {
                this.log("processing " + file.toURL());
            }
            File tempFile = File.createTempFile(file.getName(), null, new File(file.getAbsoluteFile().getParent()));
            try {
                ZipInputStream zip2 = new ZipInputStream(new FileInputStream(file));
                try {
                    FileOutputStream fout = new FileOutputStream(tempFile, false);
                    try {
                        ZipEntry entry2;
                        ZipOutputStream out = new ZipOutputStream(fout);
                        while ((entry2 = zip2.getNextEntry()) != null) {
                            byte[] bytes2 = this.getBytes(zip2);
                            if (!entry2.isDirectory()) {
                                DataInputStream din = new DataInputStream(new ByteArrayInputStream(bytes2));
                                if (din.readInt() == -889275714) {
                                    bytes2 = this.process(bytes2);
                                } else if (this.verbose) {
                                    this.log("ignoring " + entry2.toString());
                                }
                            }
                            ZipEntry outEntry = new ZipEntry(entry2.getName());
                            outEntry.setMethod(entry2.getMethod());
                            outEntry.setComment(entry2.getComment());
                            outEntry.setSize(bytes2.length);
                            if (outEntry.getMethod() == 0) {
                                CRC32 crc = new CRC32();
                                crc.update(bytes2);
                                outEntry.setCrc(crc.getValue());
                                outEntry.setCompressedSize(bytes2.length);
                            }
                            out.putNextEntry(outEntry);
                            out.write(bytes2);
                            out.closeEntry();
                            zip2.closeEntry();
                        }
                        out.close();
                    }
                    finally {
                        fout.close();
                    }
                }
                finally {
                    zip2.close();
                }
                if (file.delete()) {
                    File newFile = new File(tempFile.getAbsolutePath());
                    if (!newFile.renameTo(file)) {
                        throw new IOException("can not rename " + tempFile + " to " + file);
                    }
                    break block19;
                }
                throw new IOException("can not delete " + file);
            }
            finally {
                tempFile.delete();
            }
        }
    }

    private byte[] process(byte[] bytes2) throws Exception {
        ClassReader reader2 = new ClassReader(new ByteArrayInputStream(bytes2));
        String[] name = ClassNameReader.getClassInfo(reader2);
        DebuggingClassWriter w = new DebuggingClassWriter(1);
        ClassTransformer t2 = this.getClassTransformer(name);
        if (t2 != null) {
            if (this.verbose) {
                this.log("processing " + name[0]);
            }
            new TransformingClassGenerator(new ClassReaderGenerator(new ClassReader(new ByteArrayInputStream(bytes2)), this.attributes(), this.getFlags()), t2).generateClass(w);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(((ClassWriter)w).toByteArray());
            return out.toByteArray();
        }
        return bytes2;
    }

    private byte[] getBytes(ZipInputStream zip2) throws IOException {
        int b;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        BufferedInputStream in2 = new BufferedInputStream(zip2);
        while ((b = ((InputStream)in2).read()) != -1) {
            bout.write(b);
        }
        return bout.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkMagic(File file, long magic) throws IOException {
        DataInputStream in2 = new DataInputStream(new FileInputStream(file));
        try {
            int m = in2.readInt();
            boolean bl = magic == (long)m;
            return bl;
        }
        finally {
            in2.close();
        }
    }

    protected boolean isJarFile(File file) throws IOException {
        return this.checkMagic(file, 1347093252L);
    }
}

