/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.binary.Base64;

public class Base64InputStream
extends FilterInputStream {
    private final boolean doEncode;
    private final Base64 base64;
    private final byte[] singleByte = new byte[1];

    public Base64InputStream(InputStream in2) {
        this(in2, false);
    }

    public Base64InputStream(InputStream in2, boolean doEncode) {
        super(in2);
        this.doEncode = doEncode;
        this.base64 = new Base64();
    }

    public Base64InputStream(InputStream in2, boolean doEncode, int lineLength, byte[] lineSeparator) {
        super(in2);
        this.doEncode = doEncode;
        this.base64 = new Base64(lineLength, lineSeparator);
    }

    public int read() throws IOException {
        int r = this.read(this.singleByte, 0, 1);
        while (r == 0) {
            r = this.read(this.singleByte, 0, 1);
        }
        if (r > 0) {
            return this.singleByte[0] < 0 ? 256 + this.singleByte[0] : this.singleByte[0];
        }
        return -1;
    }

    public int read(byte[] b, int offset2, int len2) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (offset2 < 0 || len2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (offset2 > b.length || offset2 + len2 > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len2 == 0) {
            return 0;
        }
        if (!this.base64.hasData()) {
            byte[] buf = new byte[this.doEncode ? 4096 : 8192];
            int c2 = this.in.read(buf);
            if (c2 > 0 && b.length == len2) {
                this.base64.setInitialBuffer(b, offset2, len2);
            }
            if (this.doEncode) {
                this.base64.encode(buf, 0, c2);
            } else {
                this.base64.decode(buf, 0, c2);
            }
        }
        return this.base64.readResults(b, offset2, len2);
    }

    public boolean markSupported() {
        return false;
    }
}

