/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringDecoder;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.net.RFC1522Codec;

public class BCodec
extends RFC1522Codec
implements StringEncoder,
StringDecoder {
    private final String charset;

    public BCodec() {
        this("UTF-8");
    }

    public BCodec(String charset) {
        this.charset = charset;
    }

    protected String getEncoding() {
        return "B";
    }

    protected byte[] doEncoding(byte[] bytes2) {
        if (bytes2 == null) {
            return null;
        }
        return Base64.encodeBase64(bytes2);
    }

    protected byte[] doDecoding(byte[] bytes2) {
        if (bytes2 == null) {
            return null;
        }
        return Base64.decodeBase64(bytes2);
    }

    public String encode(String value2, String charset) throws EncoderException {
        if (value2 == null) {
            return null;
        }
        try {
            return this.encodeText(value2, charset);
        }
        catch (UnsupportedEncodingException e2) {
            throw new EncoderException(e2.getMessage(), e2);
        }
    }

    public String encode(String value2) throws EncoderException {
        if (value2 == null) {
            return null;
        }
        return this.encode(value2, this.getDefaultCharset());
    }

    public String decode(String value2) throws DecoderException {
        if (value2 == null) {
            return null;
        }
        try {
            return this.decodeText(value2);
        }
        catch (UnsupportedEncodingException e2) {
            throw new DecoderException(e2.getMessage(), e2);
        }
    }

    public Object encode(Object value2) throws EncoderException {
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof String) {
            return this.encode((String)value2);
        }
        throw new EncoderException("Objects of type " + value2.getClass().getName() + " cannot be encoded using BCodec");
    }

    public Object decode(Object value2) throws DecoderException {
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof String) {
            return this.decode((String)value2);
        }
        throw new DecoderException("Objects of type " + value2.getClass().getName() + " cannot be decoded using BCodec");
    }

    public String getDefaultCharset() {
        return this.charset;
    }
}

