/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentSerializer {
    private Message message;
    private String bodyBoundary;
    private OutputStream out;
    private String encoding;
    private String multipartType;
    private Map<String, List<String>> rootHeaders = Collections.emptyMap();
    private boolean xop = true;

    public AttachmentSerializer(Message messageParam) {
        this.message = messageParam;
    }

    public AttachmentSerializer(Message messageParam, String multipartType, Map<String, List<String>> headers2) {
        this.message = messageParam;
        this.multipartType = multipartType;
        this.rootHeaders = headers2;
    }

    public void writeProlog() throws IOException {
        this.bodyBoundary = AttachmentUtil.getUniqueBoundaryValue();
        String bodyCt = (String)this.message.get("Content-Type");
        if ((bodyCt = bodyCt.replaceAll("\"", "\\\"")).indexOf(34) != -1 && bodyCt.indexOf(59) != -1) {
            int pos = bodyCt.indexOf(59);
            StringBuilder st = new StringBuilder(bodyCt.substring(0, pos));
            st.append("\"").append(bodyCt.substring(pos, bodyCt.length() - 1));
            bodyCt = st.toString();
        }
        String requestMimeType = this.multipartType == null ? "multipart/related" : this.multipartType;
        StringBuilder ct = new StringBuilder();
        ct.append(requestMimeType);
        if (requestMimeType.indexOf("type=") == -1) {
            ct.append("; ");
            if (this.xop) {
                ct.append("type=\"application/xop+xml\"");
            } else {
                ct.append("type=\"").append(bodyCt).append("\"");
            }
        }
        ct.append("; ");
        String rootContentId = this.getHeaderValue("Content-ID", "root.message@cxf.apache.org");
        ct.append("boundary=\"").append(this.bodyBoundary).append("\"; ").append("start=\"<").append(AttachmentSerializer.checkAngleBrackets(rootContentId)).append(">\"; ").append("start-info=\"").append(bodyCt).append("\"");
        this.message.put("Content-Type", ct.toString());
        this.out = this.message.getContent(OutputStream.class);
        this.encoding = (String)this.message.get(Message.ENCODING);
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        StringWriter writer = new StringWriter();
        writer.write("\r\n");
        writer.write("--");
        writer.write(this.bodyBoundary);
        StringBuilder mimeBodyCt = new StringBuilder();
        String bodyType = this.getHeaderValue("Content-Type", null);
        if (bodyType == null) {
            mimeBodyCt.append((this.xop ? "application/xop+xml" : "text/xml") + "; charset=").append(this.encoding).append("; type=\"").append(bodyCt).append("\";");
        } else {
            mimeBodyCt.append(bodyType);
        }
        AttachmentSerializer.writeHeaders(mimeBodyCt.toString(), rootContentId, this.rootHeaders, writer);
        this.out.write(writer.getBuffer().toString().getBytes(this.encoding));
    }

    private String getHeaderValue(String name, String defaultValue) {
        List<String> value2 = this.rootHeaders.get(name);
        if (value2 == null || value2.isEmpty()) {
            return defaultValue;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < value2.size(); ++i) {
            sb.append(value2.get(i));
            if (i + 1 >= value2.size()) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    private static void writeHeaders(String contentType, String attachmentId, Map<String, List<String>> headers2, Writer writer) throws IOException {
        writer.write("\r\n");
        writer.write("Content-Type: ");
        writer.write(contentType);
        writer.write("\r\n");
        writer.write("Content-Transfer-Encoding: binary\r\n");
        if (attachmentId != null) {
            attachmentId = AttachmentSerializer.checkAngleBrackets(attachmentId);
            writer.write("Content-ID: <");
            writer.write(URLDecoder.decode(attachmentId, "UTF-8"));
            writer.write(">\r\n");
        }
        for (Map.Entry<String, List<String>> entry2 : headers2.entrySet()) {
            String name = entry2.getKey();
            if ("Content-Type".equalsIgnoreCase(name) || "Content-ID".equalsIgnoreCase(name) || "Content-Transfer-Encoding".equalsIgnoreCase(name)) continue;
            writer.write(name + ": ");
            List<String> values2 = entry2.getValue();
            for (int i = 0; i < values2.size(); ++i) {
                writer.write(values2.get(i));
                if (i + 1 >= values2.size()) continue;
                writer.write(",");
            }
            writer.write("\r\n");
        }
        writer.write("\r\n");
    }

    private static String checkAngleBrackets(String value2) {
        if (value2.charAt(0) == '<' && value2.charAt(value2.length() - 1) == '>') {
            return value2.substring(1, value2.length() - 1);
        }
        return value2;
    }

    public void writeAttachments() throws IOException {
        if (this.message.getAttachments() != null) {
            for (Attachment a2 : this.message.getAttachments()) {
                StringWriter writer = new StringWriter();
                writer.write("\r\n");
                writer.write("--");
                writer.write(this.bodyBoundary);
                Map<String, List<String>> headers2 = null;
                Iterator<String> it = a2.getHeaderNames();
                if (it.hasNext()) {
                    headers2 = new LinkedHashMap();
                    while (it.hasNext()) {
                        String key = it.next();
                        headers2.put(key, Collections.singletonList(a2.getHeader(key)));
                    }
                } else {
                    headers2 = Collections.emptyMap();
                }
                DataHandler handler = a2.getDataHandler();
                handler.setCommandMap(AttachmentUtil.getCommandMap());
                AttachmentSerializer.writeHeaders(handler.getContentType(), a2.getId(), headers2, writer);
                this.out.write(writer.getBuffer().toString().getBytes(this.encoding));
                handler.writeTo(this.out);
            }
        }
        StringWriter writer = new StringWriter();
        writer.write("\r\n");
        writer.write("--");
        writer.write(this.bodyBoundary);
        writer.write("--");
        this.out.write(writer.getBuffer().toString().getBytes(this.encoding));
        this.out.flush();
    }

    public boolean isXop() {
        return this.xop;
    }

    public void setXop(boolean xop) {
        this.xop = xop;
    }
}

