/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.activation.CommandMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.MailcapCommandMap;
import javax.activation.URLDataSource;
import javax.mail.Header;
import javax.mail.internet.InternetHeaders;
import org.apache.cxf.attachment.AttachmentDataSource;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.attachment.ByteDataSource;
import org.apache.cxf.attachment.ImageDataContentHandler;
import org.apache.cxf.attachment.LazyAttachmentCollection;
import org.apache.cxf.attachment.LazyDataSource;
import org.apache.cxf.attachment.QuotedPrintableDecoderStream;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttachmentUtil {
    public static final String BODY_ATTACHMENT_ID = "root.message@cxf.apache.org";
    private static volatile int counter;
    private static final String ATT_UUID;
    private static final Random BOUND_RANDOM;
    private static final MailcapCommandMap COMMAND_MAP;

    private AttachmentUtil() {
    }

    public static CommandMap getCommandMap() {
        return COMMAND_MAP;
    }

    public static String createContentID(String ns) throws UnsupportedEncodingException {
        String cid = "cxf.apache.org";
        String name = ATT_UUID + "-" + String.valueOf(++counter);
        if (ns != null && ns.length() > 0) {
            try {
                String host;
                URI uri = new URI(ns);
                cid = host = uri.toURL().getHost();
            }
            catch (Exception e2) {
                cid = ns;
            }
        }
        return URLEncoder.encode(name, "UTF-8") + "@" + URLEncoder.encode(cid, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUniqueBoundaryValue() {
        long leastSigBits = 0L;
        long mostSigBits = 0L;
        Random random = BOUND_RANDOM;
        synchronized (random) {
            mostSigBits = BOUND_RANDOM.nextLong();
            leastSigBits = BOUND_RANDOM.nextLong();
        }
        mostSigBits &= 0xFFFFFFFFFFFF0FFFL;
        leastSigBits &= 0x3FFFFFFFFFFFFFFFL;
        UUID result2 = new UUID(mostSigBits |= 0x4000L, leastSigBits |= Long.MIN_VALUE);
        return "uuid:" + result2.toString();
    }

    public static String getAttachmentPartHeader(Attachment att) {
        String id2;
        StringBuilder buffer = new StringBuilder(200);
        buffer.append(HttpHeaderHelper.getHeaderKey("Content-Type") + ": " + att.getDataHandler().getContentType() + ";\r\n");
        if (att.isXOP()) {
            buffer.append("Content-Transfer-Encoding: binary\r\n");
        }
        if ((id2 = att.getId()).charAt(0) == '<') {
            id2 = id2.substring(1, id2.length() - 1);
        }
        buffer.append("Content-ID: <" + id2 + ">\r\n\r\n");
        return buffer.toString();
    }

    public static Map<String, DataHandler> getDHMap(Collection<Attachment> attachments) {
        Map<Object, Object> dataHandlers = null;
        if (attachments != null) {
            if (attachments instanceof LazyAttachmentCollection) {
                dataHandlers = ((LazyAttachmentCollection)attachments).createDataHandlerMap();
            } else {
                dataHandlers = new LinkedHashMap();
                for (Attachment attachment : attachments) {
                    dataHandlers.put(attachment.getId(), attachment.getDataHandler());
                }
            }
        }
        return dataHandlers == null ? new LinkedHashMap() : dataHandlers;
    }

    public static Attachment createAttachment(InputStream stream2, InternetHeaders headers2) throws IOException {
        AttachmentDataSource source;
        String id2 = headers2.getHeader("Content-ID", null);
        id2 = id2 != null && id2.startsWith("<") ? id2.substring(1, id2.length() - 1) : "Content-ID: <root.message@cxf.apache.org";
        id2 = URLDecoder.decode(id2.startsWith("cid:") ? id2.substring(4) : id2, "UTF-8");
        AttachmentImpl att = new AttachmentImpl(id2);
        String ct = headers2.getHeader("Content-Type", null);
        boolean quotedPrintable = false;
        Enumeration e2 = headers2.getAllHeaders();
        while (e2.hasMoreElements()) {
            Header header = (Header)e2.nextElement();
            if (header.getName().equalsIgnoreCase("Content-Transfer-Encoding")) {
                if (header.getValue().equalsIgnoreCase("binary")) {
                    att.setXOP(true);
                } else if (header.getValue().equalsIgnoreCase("quoted-printable")) {
                    quotedPrintable = true;
                }
            }
            att.setHeader(header.getName(), header.getValue());
        }
        if (quotedPrintable) {
            source = new AttachmentDataSource(ct, new QuotedPrintableDecoderStream(stream2));
            att.setDataHandler(new DataHandler((DataSource)source));
        } else {
            source = new AttachmentDataSource(ct, stream2);
            att.setDataHandler(new DataHandler((DataSource)source));
        }
        return att;
    }

    public static boolean isTypeSupported(String contentType, List<String> types2) {
        if (contentType == null) {
            return false;
        }
        contentType = contentType.toLowerCase();
        for (String s2 : types2) {
            if (contentType.indexOf(s2) == -1) continue;
            return true;
        }
        return false;
    }

    public static Attachment createMtomAttachment(boolean isXop, String mimeType, String elementNS, byte[] data2, int offset2, int length2, int threshold) {
        String id2;
        if (!isXop || length2 < threshold) {
            return null;
        }
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        ByteDataSource source = new ByteDataSource(data2, offset2, length2);
        source.setContentType(mimeType);
        DataHandler handler = new DataHandler((DataSource)source);
        try {
            id2 = AttachmentUtil.createContentID(elementNS);
        }
        catch (UnsupportedEncodingException e2) {
            throw new Fault(e2);
        }
        AttachmentImpl att = new AttachmentImpl(id2, handler);
        att.setXOP(isXop);
        return att;
    }

    public static Attachment createMtomAttachmentFromDH(boolean isXop, DataHandler handler, String elementNS, int threshold) {
        String id2;
        if (!isXop) {
            return null;
        }
        try {
            DataSource ds = handler.getDataSource();
            if (ds instanceof FileDataSource) {
                FileDataSource fds = (FileDataSource)ds;
                File file = fds.getFile();
                if (file.length() < (long)threshold) {
                    return null;
                }
            } else if (ds.getClass().getName().endsWith("ObjectDataSource")) {
                Object o = handler.getContent();
                if (o instanceof String && ((String)o).length() < threshold) {
                    return null;
                }
                if (o instanceof byte[] && ((byte[])o).length < threshold) {
                    return null;
                }
            }
        }
        catch (IOException e1) {
            // empty catch block
        }
        try {
            id2 = AttachmentUtil.createContentID(elementNS);
        }
        catch (UnsupportedEncodingException e2) {
            throw new Fault(e2);
        }
        AttachmentImpl att = new AttachmentImpl(id2, handler);
        att.setXOP(isXop);
        return att;
    }

    public static DataSource getAttachmentDataSource(String contentId, Collection<Attachment> atts) {
        if (contentId.startsWith("cid:")) {
            try {
                contentId = URLDecoder.decode(contentId.substring(4), "UTF-8");
            }
            catch (UnsupportedEncodingException ue) {
                contentId = contentId.substring(4);
            }
            return new LazyDataSource(contentId, atts);
        }
        if (contentId.indexOf("://") == -1) {
            return new LazyDataSource(contentId, atts);
        }
        try {
            return new URLDataSource(new URL(contentId));
        }
        catch (MalformedURLException e2) {
            throw new Fault(e2);
        }
    }

    static {
        ATT_UUID = UUID.randomUUID().toString();
        BOUND_RANDOM = new Random();
        COMMAND_MAP = new MailcapCommandMap();
        COMMAND_MAP.addMailcap("image/*;;x-java-content-handler=" + ImageDataContentHandler.class.getName());
    }
}

