/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class ImageDataContentHandler
implements DataContentHandler {
    private static final DataFlavor[] FLAVORS;

    public Object getContent(DataSource ds) throws IOException {
        return ImageIO.read(ds.getInputStream());
    }

    public Object getTransferData(DataFlavor df, DataSource ds) throws UnsupportedFlavorException, IOException {
        for (DataFlavor f2 : FLAVORS) {
            if (!f2.equals(df)) continue;
            return this.getContent(ds);
        }
        return null;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return FLAVORS;
    }

    public void writeTo(Object obj, String mimeType, OutputStream os2) throws IOException {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByMIMEType(mimeType);
        if (!writers.hasNext()) {
            throw new IOException("Attachment type not spported " + obj.getClass());
        }
        ImageWriter writer = writers.next();
        BufferedImage bimg = ImageDataContentHandler.convertToBufferedImage((Image)obj);
        ImageOutputStream out = ImageIO.createImageOutputStream(os2);
        writer.setOutput(out);
        writer.write(bimg);
        writer.dispose();
        out.flush();
        out.close();
    }

    private static BufferedImage convertToBufferedImage(Image image) throws IOException {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        MediaTracker tracker = new MediaTracker(new Component(){});
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException e2) {
            IOException ioe = new IOException(e2.getMessage());
            ioe.initCause(e2);
            throw ioe;
        }
        BufferedImage bufImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g = bufImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bufImage;
    }

    static {
        String[] types2 = ImageIO.getReaderMIMETypes();
        FLAVORS = new DataFlavor[types2.length];
        int i = 0;
        for (String type : types2) {
            ImageDataContentHandler.FLAVORS[i++] = new ActivationDataFlavor(Image.class, type, "Image");
        }
    }
}

