/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import javax.activation.DataSource;
import org.apache.cxf.message.Attachment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyDataSource
implements DataSource {
    private DataSource dataSource;
    private Collection<Attachment> attachments;
    private String id;

    public LazyDataSource(String id2, Collection<Attachment> attachments) {
        this.id = id2;
        this.attachments = attachments;
    }

    private synchronized void load() {
        if (this.dataSource == null) {
            for (Attachment a2 : this.attachments) {
                if (!a2.getId().equals(this.id)) continue;
                this.dataSource = a2.getDataHandler().getDataSource();
                break;
            }
        }
    }

    public String getContentType() {
        this.load();
        return this.dataSource.getContentType();
    }

    public InputStream getInputStream() throws IOException {
        this.load();
        return this.dataSource.getInputStream();
    }

    public String getName() {
        this.load();
        return this.dataSource.getName();
    }

    public OutputStream getOutputStream() throws IOException {
        this.load();
        return this.dataSource.getOutputStream();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

