/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class MimeBodyPartInputStream
extends InputStream {
    PushbackInputStream inStream;
    boolean boundaryFound;
    int pbAmount;
    byte[] boundary;
    byte[] boundaryBuffer;

    public MimeBodyPartInputStream(PushbackInputStream inStreamParam, byte[] boundaryParam, int pbsize) {
        this.inStream = inStreamParam;
        this.boundary = boundaryParam;
        this.pbAmount = pbsize;
    }

    public int read(byte[] buf, int origOff, int origLen) throws IOException {
        byte[] b = buf;
        int off = origOff;
        int len2 = origLen;
        if (this.boundaryFound) {
            return -1;
        }
        if (off < 0 || off > b.length || len2 < 0 || off + len2 > b.length || off + len2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len2 == 0) {
            return 0;
        }
        boolean bufferCreated = false;
        if (len2 < this.boundary.length * 2) {
            bufferCreated = true;
            if (this.boundaryBuffer == null) {
                this.boundaryBuffer = new byte[this.boundary.length * 2];
            }
            b = this.boundaryBuffer;
            off = 0;
            len2 = this.boundaryBuffer.length;
        }
        if (len2 > this.pbAmount) {
            len2 = this.pbAmount;
        }
        int read2 = 0;
        int idx = 0;
        while (read2 >= 0 && idx < len2 && idx < this.boundary.length * 2) {
            read2 = this.inStream.read(b, off + idx, len2 - idx);
            if (read2 == -1) continue;
            idx += read2;
        }
        if (read2 == -1 && idx == 0) {
            return -1;
        }
        len2 = idx;
        int i = this.processBuffer(b, off, len2);
        if (bufferCreated && i > 0) {
            if (origLen >= i) {
                System.arraycopy(b, 0, buf, origOff, i);
            } else {
                System.arraycopy(b, 0, buf, origOff, origLen);
                this.inStream.unread(b, origLen, i - origLen);
                i = origLen;
            }
        } else if (i == 0 && this.boundaryFound) {
            return -1;
        }
        return i;
    }

    private boolean hasData(byte[] b, int initialPointer, int pointer, int off, int len2) throws IOException {
        if (pointer < off + len2) {
            return true;
        }
        if (pointer >= 1000000000) {
            this.inStream.unread(b, initialPointer, off + len2 - initialPointer);
            return false;
        }
        int x = this.inStream.read();
        if (x != -1) {
            this.inStream.unread(x);
            this.inStream.unread(b, initialPointer, off + len2 - initialPointer);
            return false;
        }
        return true;
    }

    protected int processBuffer(byte[] buffer, int off, int len2) throws IOException {
        for (int i = off; i < off + len2; ++i) {
            int boundaryIndex;
            boolean needUnread0d0a = false;
            byte value2 = buffer[i];
            int initialI = i++;
            if (value2 == 13) {
                if (!this.hasData(buffer, initialI, initialI + 1, off, len2)) {
                    return initialI - off;
                }
                value2 = buffer[initialI + 1];
                if (value2 != 10) continue;
                if (!this.hasData(buffer, initialI, initialI + 2, off, len2)) {
                    return initialI - off;
                }
                value2 = buffer[initialI + 2];
                if ((byte)value2 != this.boundary[0]) continue;
                needUnread0d0a = true;
                i += 2;
            } else if (value2 != this.boundary[0]) continue;
            for (boundaryIndex = 0; boundaryIndex < this.boundary.length && value2 == this.boundary[boundaryIndex]; ++boundaryIndex) {
                if (!this.hasData(buffer, initialI, i + 1, off, len2)) {
                    return initialI - off;
                }
                value2 = buffer[++i];
            }
            if (boundaryIndex == this.boundary.length) {
                if (initialI != off) {
                    i = 1000000000;
                }
                if (initialI - off != 0 && !this.hasData(buffer, initialI, i + 1, off, len2)) {
                    return initialI - off;
                }
                this.boundaryFound = true;
                int j = i + 1;
                if (j < len2 && buffer[j] == 45 && value2 == 45) {
                    i += 2;
                }
                int processed = initialI - off;
                if (len2 - (i + 2) > 0) {
                    this.inStream.unread(buffer, i + 2, len2 - (i + 2) + off);
                }
                return processed;
            }
            if (value2 != -1) {
                --i;
            }
            if (needUnread0d0a) {
                i -= boundaryIndex;
                --i;
                value2 = 13;
                continue;
            }
            i -= boundaryIndex;
            ++i;
            value2 = this.boundary[0];
        }
        return len2;
    }

    public int read() throws IOException {
        int boundaryIndex;
        boolean needUnread0d0a = false;
        if (this.boundaryFound) {
            return -1;
        }
        int value2 = this.inStream.read();
        if (value2 == 13) {
            value2 = this.inStream.read();
            if (value2 != 10) {
                this.inStream.unread(value2);
                return 13;
            }
            value2 = this.inStream.read();
            if ((byte)value2 != this.boundary[0]) {
                this.inStream.unread(value2);
                this.inStream.unread(10);
                return 13;
            }
            needUnread0d0a = true;
        } else if ((byte)value2 != this.boundary[0]) {
            return value2;
        }
        for (boundaryIndex = 0; boundaryIndex < this.boundary.length && (byte)value2 == this.boundary[boundaryIndex]; ++boundaryIndex) {
            value2 = this.inStream.read();
        }
        if (boundaryIndex == this.boundary.length) {
            this.boundaryFound = true;
            int dashNext = this.inStream.read();
            if (dashNext == 45 && value2 == 45) {
                this.inStream.read();
                this.inStream.read();
            }
            return -1;
        }
        if (value2 != -1) {
            this.inStream.unread(value2);
        }
        if (needUnread0d0a) {
            this.inStream.unread(this.boundary, 0, boundaryIndex);
            this.inStream.unread(10);
            value2 = 13;
        } else {
            this.inStream.unread(this.boundary, 1, boundaryIndex - 1);
            value2 = this.boundary[0];
        }
        return value2;
    }
}

